/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.stack.Protocol;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcherTest
extends ChannelTestBase {
    RpcDispatcher disp1;
    RpcDispatcher disp2;
    RpcDispatcher disp3;
    JChannel c1;
    JChannel c2;
    JChannel c3;
    static final int[] SIZES = new int[]{10000, 20000, 40000, 80000, 100000, 200000, 400000, 800000, 1000000, 2000000, 5000000};
    static final int[] HUGESIZES = new int[]{10000000, 20000000};

    protected void setUp() throws Exception {
        super.setUp();
        this.c1 = this.createChannel("A");
        this.disp1 = new RpcDispatcher((Channel)this.c1, null, null, new ServerObject(1));
        this.c1.connect("demo");
        this.c2 = this.createChannel("A");
        this.disp2 = new RpcDispatcher((Channel)this.c2, null, null, new ServerObject(2));
        this.c2.connect("demo");
        this.c3 = this.createChannel("A");
        this.disp3 = new RpcDispatcher((Channel)this.c3, null, null, new ServerObject(3));
        this.c3.connect("demo");
        System.out.println("c1.view=" + this.c1.getView() + "\nc2.view=" + this.c2.getView() + "\nc3.view=" + this.c3.getView());
        View view = this.c3.getView();
        assert (view.size() == 3) : "view=" + view;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.disp3.stop();
        this.c3.close();
        this.disp2.stop();
        this.c2.close();
        this.disp1.stop();
        this.c1.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmptyConstructor() throws Exception {
        RpcDispatcher d1 = new RpcDispatcher();
        RpcDispatcher d2 = new RpcDispatcher();
        JChannel channel1 = null;
        JChannel channel2 = null;
        Util.close(this.c3, this.c2, this.c1);
        String GROUP = "RpcDispatcherTest.testEmptyConstructor";
        try {
            channel1 = this.createChannel();
            channel2 = this.createChannel();
            d1.setChannel(channel1);
            d2.setChannel(channel2);
            d1.setServerObject(new ServerObject(1));
            d2.setServerObject(new ServerObject(2));
            d1.start();
            d2.start();
            channel1.connect("RpcDispatcherTest.testEmptyConstructor");
            channel2.connect("RpcDispatcherTest.testEmptyConstructor");
            Util.sleep(500L);
            View view = channel2.getView();
            System.out.println("view channel 2= " + view);
            view = channel1.getView();
            System.out.println("view channel 1= " + view);
            assert (view.size() == 2);
            RspList rsps = d1.callRemoteMethods(null, "foo", null, (Class[])null, 2, 5000L);
            System.out.println("rsps:\n" + rsps);
            assert (rsps.size() == 2);
            for (Rsp rsp : rsps.values()) {
                assert (rsp.wasReceived());
                assert (!rsp.wasSuspected());
                assert (rsp.getValue() != null);
            }
            Object server_object = new Object(){

                public long foobar() {
                    return System.currentTimeMillis();
                }
            };
            d1.setServerObject(server_object);
            d2.setServerObject(server_object);
            rsps = d2.callRemoteMethods(null, "foobar", null, (Class[])null, 2, 5000L);
            System.out.println("rsps:\n" + rsps);
            assert (rsps.size() == 2);
            for (Rsp rsp : rsps.values()) {
                assert (rsp.wasReceived());
                assert (!rsp.wasSuspected());
                assert (rsp.getValue() != null);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            d2.stop();
            d1.stop();
            Util.close(channel2, channel1);
            throw throwable;
        }
        d2.stop();
        d1.stop();
        Util.close(channel2, channel1);
    }

    public void testResponseFilter() {
        long timeout = 10000L;
        RspList rsps = this.disp1.callRemoteMethods(null, "foo", null, null, 2, 10000L, false, new RspFilter(){
            int num = 0;

            public boolean isAcceptable(Object response, Address sender) {
                boolean retval = (Integer)response > 1;
                System.out.println("-- received " + response + " from " + sender + ": " + (retval ? "OK" : "NOTOK"));
                if (retval) {
                    ++this.num;
                }
                return retval;
            }

            public boolean needMoreResponses() {
                return this.num < 2;
            }
        });
        System.out.println("responses are:\n" + rsps);
        RpcDispatcherTest.assertEquals((String)"there should be three response values", (int)3, (int)rsps.size());
        RpcDispatcherTest.assertEquals((String)"number of responses received should be 2", (int)2, (int)rsps.numReceived());
    }

    public void testLargeReturnValue() {
        RpcDispatcherTest.setProps(this.c1);
        RpcDispatcherTest.setProps(this.c2);
        RpcDispatcherTest.setProps(this.c3);
        for (int i = 0; i < SIZES.length; ++i) {
            this._testLargeValue(SIZES[i]);
        }
    }

    public void testHugeReturnValue() {
        RpcDispatcherTest.setProps(this.c1);
        RpcDispatcherTest.setProps(this.c2);
        RpcDispatcherTest.setProps(this.c3);
        for (int i = 0; i < HUGESIZES.length; ++i) {
            this._testHugeValue(HUGESIZES[i]);
        }
    }

    public void testMethodInvocationToNonExistingMembers() {
        int timeout = 5000;
        View view = this.c3.getView();
        Vector<Address> members = view.getMembers();
        System.out.println("list is " + members);
        System.out.println("closing c3");
        this.c3.close();
        Util.sleep(1000L);
        System.out.println("calling method foo() in " + members + " (view=" + this.c2.getView() + ")");
        RspList rsps = this.disp1.callRemoteMethods(members, "foo", null, (Class[])null, 2, 5000L);
        System.out.println("responses:\n" + rsps);
        for (Map.Entry<Address, Rsp> entry : rsps.entrySet()) {
            Rsp rsp = entry.getValue();
            RpcDispatcherTest.assertTrue((String)("response from " + entry.getKey() + " was not received"), (boolean)rsp.wasReceived());
            RpcDispatcherTest.assertFalse((boolean)rsp.wasSuspected());
        }
    }

    public void testLargeReturnValueUnicastCall() throws Throwable {
        RpcDispatcherTest.setProps(this.c1);
        RpcDispatcherTest.setProps(this.c2);
        RpcDispatcherTest.setProps(this.c3);
        for (int i = 0; i < SIZES.length; ++i) {
            this._testLargeValueUnicastCall(this.c1.getLocalAddress(), SIZES[i]);
        }
    }

    private static void setProps(JChannel ch) {
        Properties props1 = new Properties();
        Properties props2 = new Properties();
        props1.setProperty("frag_size", "12000");
        props2.setProperty("max_bundle_size", "14000");
        Protocol prot = ch.getProtocolStack().findProtocol("FRAG2");
        if (prot == null) {
            prot = ch.getProtocolStack().findProtocol("FRAG");
        }
        if (prot != null) {
            prot.setProperties(props1);
        }
        if ((prot = ch.getProtocolStack().getTransport()) != null) {
            prot.setProperties(props2);
        }
    }

    void _testLargeValue(int size) {
        long timeout = 20000L;
        System.out.println("\ntesting with " + size + " bytes");
        RspList rsps = this.disp1.callRemoteMethods(null, "largeReturnValue", new Object[]{size}, new Class[]{Integer.TYPE}, 2, 20000L);
        System.out.println("rsps:");
        RpcDispatcherTest.assertEquals((String)"there should be three responses to the RPC call", (int)3, (int)rsps.size());
        for (Map.Entry<Address, Rsp> entry : rsps.entrySet()) {
            Object obj = entry.getValue().getValue();
            RpcDispatcherTest.assertFalse((String)"exception was raised in processing reasonably sized argument", (boolean)(obj instanceof Throwable));
            byte[] val = (byte[])obj;
            RpcDispatcherTest.assertNotNull((String)"return value should not be null", (Object)val);
            System.out.println(val.length + " bytes from " + entry.getValue().getSender());
            RpcDispatcherTest.assertEquals((String)"return value does not match required size", (int)size, (int)val.length);
        }
    }

    void _testHugeValue(int size) {
        long timeout = 20000L;
        System.out.println("\ntesting with " + size + " bytes");
        RspList rsps = this.disp1.callRemoteMethods(null, "largeReturnValue", new Object[]{size}, new Class[]{Integer.TYPE}, 2, 20000L);
        System.out.println("rsps:");
        RpcDispatcherTest.assertEquals((String)"there should be three responses to the RPC call", (int)3, (int)rsps.size());
        for (Map.Entry<Address, Rsp> entry : rsps.entrySet()) {
            Object obj = entry.getValue().getValue();
            if (obj instanceof Throwable) {
                Throwable t = (Throwable)obj;
                System.out.println(t.toString() + " exception was raised processing argument from " + entry.getValue().getSender() + " -this is expected");
                continue;
            }
            if (obj == null) {
                System.out.println("request timed out processing argument from " + entry.getValue().getSender() + " - this is expected");
                continue;
            }
            byte[] val = (byte[])obj;
            RpcDispatcherTest.assertNotNull((String)"return value should not be null", (Object)val);
            System.out.println(val.length + " bytes from " + entry.getValue().getSender());
            RpcDispatcherTest.assertEquals((String)"return value does not match required size", (int)size, (int)val.length);
        }
    }

    void _testLargeValueUnicastCall(Address dst, int size) throws Throwable {
        long timeout = 20000L;
        System.out.println("\ntesting unicast call with " + size + " bytes");
        RpcDispatcherTest.assertNotNull((Object)dst);
        Object retval = this.disp1.callRemoteMethod(dst, "largeReturnValue", new Object[]{size}, new Class[]{Integer.TYPE}, 2, 20000L);
        if (retval instanceof Throwable) {
            RpcDispatcherTest.fail((String)"exception was raised in processing resonably sized argument");
        }
        byte[] val = (byte[])retval;
        RpcDispatcherTest.assertNotNull((String)"return value should be non-null", (Object)val);
        System.out.println("rsp: " + val.length + " bytes");
        RpcDispatcherTest.assertEquals((String)"return value does not match requested size", (int)size, (int)val.length);
    }

    public static Test suite() {
        return new TestSuite(RpcDispatcherTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RpcDispatcherTest.suite());
    }

    private static class ServerObject {
        int i;

        public ServerObject(int i) {
            this.i = i;
        }

        public int foo() {
            return this.i;
        }

        public static byte[] largeReturnValue(int size) {
            return new byte[size];
        }
    }
}

