/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.FragHeader;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Range;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FRAG2
extends Protocol {
    int frag_size = 1500;
    int overhead = 200;
    private final FragmentationList fragment_list = new FragmentationList();
    private int curr_id = 1;
    private final Vector members = new Vector(11);
    private static final String name = "FRAG2";
    AtomicLong num_sent_msgs = new AtomicLong(0L);
    AtomicLong num_received_msgs = new AtomicLong(0L);
    AtomicLong num_sent_frags = new AtomicLong(0L);
    AtomicLong num_received_frags = new AtomicLong(0L);

    @Override
    public final String getName() {
        return name;
    }

    public int getFragSize() {
        return this.frag_size;
    }

    public void setFragSize(int s) {
        this.frag_size = s;
    }

    public int getOverhead() {
        return this.overhead;
    }

    public void setOverhead(int o) {
        this.overhead = o;
    }

    public long getNumberOfSentMessages() {
        return this.num_sent_msgs.get();
    }

    public long getNumberOfSentFragments() {
        return this.num_sent_frags.get();
    }

    public long getNumberOfReceivedMessages() {
        return this.num_received_msgs.get();
    }

    public long getNumberOfReceivedFragments() {
        return this.num_received_frags.get();
    }

    synchronized int getNextId() {
        return this.curr_id++;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("frag_size");
        if (str != null) {
            this.frag_size = Integer.parseInt(str);
            props.remove("frag_size");
        }
        if ((str = props.getProperty("overhead")) != null) {
            this.overhead = Integer.parseInt(str);
            props.remove("overhead");
        }
        int old_frag_size = this.frag_size;
        this.frag_size -= this.overhead;
        if (this.frag_size <= 0) {
            this.log.error((Object)("frag_size=" + old_frag_size + ", overhead=" + this.overhead + ", new frag_size=" + this.frag_size + ": new frag_size is invalid"));
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("frag_size=" + old_frag_size + ", overhead=" + this.overhead + ", new frag_size=" + this.frag_size));
        }
        if (!props.isEmpty()) {
            this.log.error((Object)("FRAG2.setProperties(): the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    @Override
    public void init() throws Exception {
        super.init();
        HashMap<String, Integer> info = new HashMap<String, Integer>(1);
        info.put("frag_size", this.frag_size);
        this.up_prot.up(new Event(84, info));
        this.down_prot.down(new Event(84, info));
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_sent_msgs.set(0L);
        this.num_sent_frags.set(0L);
        this.num_received_frags.set(0L);
        this.num_received_msgs.set(0L);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                long size = msg.getLength();
                this.num_sent_msgs.incrementAndGet();
                if (size <= (long)this.frag_size) break;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)new StringBuilder("message's buffer size is ").append(size).append(", will fragment ").append("(frag_size=").append(this.frag_size).append(')'));
                }
                this.fragment(msg);
                return null;
            }
            case 6: {
                View view = (View)evt.getArg();
                Vector<Address> new_mbrs = view.getMembers();
                Vector<Address> left_mbrs = Util.determineLeftMembers(this.members, new_mbrs);
                this.members.clear();
                this.members.addAll(new_mbrs);
                for (int i = 0; i < left_mbrs.size(); ++i) {
                    Address mbr = left_mbrs.elementAt(i);
                    this.fragment_list.remove(mbr);
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace((Object)("[VIEW_CHANGE] removed " + mbr + " from fragmentation table"));
                }
                break;
            }
            case 56: {
                Object ret = this.down_prot.down(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((Map)evt.getArg());
                return ret;
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                FragHeader hdr = (FragHeader)msg.getHeader(name);
                if (hdr != null) {
                    this.unfragment(msg, hdr);
                    return null;
                }
                this.num_received_msgs.incrementAndGet();
                break;
            }
            case 56: {
                Object ret = this.up_prot.up(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((Map)evt.getArg());
                return ret;
            }
        }
        return this.up_prot.up(evt);
    }

    void fragment(Message msg) {
        block4: {
            Address dest = msg.getDest();
            long id = this.getNextId();
            try {
                byte[] buffer = msg.getBuffer();
                List fragments = Util.computeFragOffsets(buffer, this.frag_size);
                int num_frags = fragments.size();
                this.num_sent_frags.addAndGet(num_frags);
                if (this.log.isTraceEnabled()) {
                    StringBuilder sb = new StringBuilder("fragmenting packet to ");
                    sb.append(dest != null ? dest.toString() : "<all members>").append(" (size=").append(buffer.length);
                    sb.append(") into ").append(num_frags).append(" fragment(s) [frag_size=").append(this.frag_size).append(']');
                    this.log.trace((Object)sb.toString());
                }
                for (int i = 0; i < fragments.size(); ++i) {
                    Range r = (Range)fragments.get(i);
                    Message frag_msg = msg.copy(false);
                    frag_msg.setBuffer(buffer, (int)r.low, (int)r.high);
                    FragHeader hdr = new FragHeader(id, i, num_frags);
                    frag_msg.putHeader(name, hdr);
                    Event evt = new Event(1, frag_msg);
                    this.down_prot.down(evt);
                }
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block4;
                this.log.error((Object)"fragmentation failure", (Throwable)e);
            }
        }
    }

    private void unfragment(Message msg, FragHeader hdr) {
        block7: {
            Address sender = msg.getSrc();
            FragmentationTable frag_table = this.fragment_list.get(sender);
            if (frag_table == null) {
                frag_table = new FragmentationTable(sender);
                try {
                    this.fragment_list.add(sender, frag_table);
                }
                catch (IllegalArgumentException x) {
                    frag_table = this.fragment_list.get(sender);
                }
            }
            this.num_received_frags.incrementAndGet();
            Message assembled_msg = frag_table.add(hdr.id, hdr.frag_id, hdr.num_frags, msg);
            if (assembled_msg != null) {
                try {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("assembled_msg is " + assembled_msg));
                    }
                    assembled_msg.setSrc(sender);
                    this.num_received_msgs.incrementAndGet();
                    this.up_prot.up(new Event(1, assembled_msg));
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block7;
                    this.log.error((Object)"unfragmentation failed", (Throwable)e);
                }
            }
        }
    }

    void handleConfigEvent(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("frag_size")) {
            this.frag_size = (Integer)map.get("frag_size");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("setting frag_size=" + this.frag_size));
            }
        }
    }

    static class FragmentationTable {
        private final Address sender;
        private final Hashtable h = new Hashtable(11);

        FragmentationTable(Address sender) {
            this.sender = sender;
        }

        public synchronized Message add(long id, int frag_id, int tot_frags, Message fragment) {
            Message retval = null;
            Entry e = (Entry)this.h.get(new Long(id));
            if (e == null) {
                e = new Entry(id, tot_frags);
                this.h.put(new Long(id), e);
            }
            e.set(frag_id, fragment);
            if (e.isComplete()) {
                retval = e.assembleMessage();
                this.h.remove(new Long(id));
            }
            return retval;
        }

        public void reset() {
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("Fragmentation Table Sender:").append(this.sender).append("\n\t");
            Enumeration e = this.h.elements();
            while (e.hasMoreElements()) {
                Entry entry = (Entry)e.nextElement();
                int count = 0;
                for (int i = 0; i < entry.fragments.length; ++i) {
                    if (entry.fragments[i] == null) continue;
                    ++count;
                }
                buf.append("Message ID:").append(entry.msg_id).append("\n\t");
                buf.append("Total Frags:").append(entry.tot_frags).append("\n\t");
                buf.append("Frags Received:").append(count).append("\n\n");
            }
            return buf.toString();
        }

        static class Entry {
            int tot_frags = 0;
            Message[] fragments = null;
            int number_of_frags_recvd = 0;
            long msg_id = -1L;

            Entry(long msg_id, int tot_frags) {
                this.msg_id = msg_id;
                this.tot_frags = tot_frags;
                this.fragments = new Message[tot_frags];
                for (int i = 0; i < tot_frags; ++i) {
                    this.fragments[i] = null;
                }
            }

            public void set(int frag_id, Message frag) {
                if (this.fragments[frag_id] == null) {
                    this.fragments[frag_id] = frag;
                    ++this.number_of_frags_recvd;
                }
            }

            public boolean isComplete() {
                if (this.number_of_frags_recvd < this.tot_frags) {
                    return false;
                }
                for (int i = 0; i < this.fragments.length; ++i) {
                    if (this.fragments[i] != null) continue;
                    return false;
                }
                return true;
            }

            public Message assembleMessage() {
                Message fragment;
                int i;
                int combined_length = 0;
                int index = 0;
                for (i = 0; i < this.fragments.length; ++i) {
                    fragment = this.fragments[i];
                    combined_length += fragment.getLength();
                }
                byte[] combined_buffer = new byte[combined_length];
                for (i = 0; i < this.fragments.length; ++i) {
                    fragment = this.fragments[i];
                    byte[] tmp = fragment.getRawBuffer();
                    int length = fragment.getLength();
                    int offset = fragment.getOffset();
                    System.arraycopy(tmp, offset, combined_buffer, index, length);
                    index += length;
                }
                Message retval = this.fragments[0].copy(false);
                retval.setBuffer(combined_buffer);
                return retval;
            }

            public String toString() {
                StringBuilder ret = new StringBuilder();
                ret.append("[tot_frags=").append(this.tot_frags).append(", number_of_frags_recvd=").append(this.number_of_frags_recvd).append(']');
                return ret.toString();
            }

            public int hashCode() {
                return super.hashCode();
            }
        }
    }

    static class FragmentationList {
        private final HashMap frag_tables = new HashMap(11);

        FragmentationList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Address sender, FragmentationTable table) throws IllegalArgumentException {
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                FragmentationTable healthCheck = (FragmentationTable)this.frag_tables.get(sender);
                if (healthCheck != null) {
                    throw new IllegalArgumentException("Sender <" + sender + "> already exists in the fragementation list.");
                }
                this.frag_tables.put(sender, table);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FragmentationTable get(Address sender) {
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                return (FragmentationTable)this.frag_tables.get(sender);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsSender(Address sender) {
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                return this.frag_tables.containsKey(sender);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Address sender) {
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                boolean result = this.containsSender(sender);
                this.frag_tables.remove(sender);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Address[] getSenders() {
            Address[] result;
            int index = 0;
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                result = new Address[this.frag_tables.size()];
                Iterator it = this.frag_tables.keySet().iterator();
                while (it.hasNext()) {
                    result[index++] = (Address)it.next();
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder buf = new StringBuilder("Fragmentation list contains ");
            HashMap hashMap = this.frag_tables;
            synchronized (hashMap) {
                buf.append(this.frag_tables.size()).append(" tables\n");
                for (Map.Entry entry : this.frag_tables.entrySet()) {
                    buf.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
                }
            }
            return buf.toString();
        }
    }
}

