/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Transport;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.ThreadNamingPattern;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolStack
extends Protocol
implements Transport {
    public static final int ABOVE = 1;
    public static final int BELOW = 2;
    protected PatternedThreadFactory thread_factory;
    protected PatternedThreadFactory timer_thread_factory;
    public final TimeScheduler timer;
    private Protocol top_prot = null;
    private Protocol bottom_prot = null;
    private String setup_string;
    private JChannel channel = null;
    private volatile boolean stopped = true;
    private final Map<Thread, ReentrantLock> locks = new ConcurrentHashMap<Thread, ReentrantLock>();
    private static final ConcurrentMap<String, Tuple<TP, Short>> singleton_transports = new ConcurrentHashMap<String, Tuple<TP, Short>>();

    public ProtocolStack(JChannel channel, String setup_string) throws ChannelException {
        this(ProtocolStack.newThreadFactory(Util.getGlobalThreadGroup(), "", false), channel, setup_string);
    }

    public ProtocolStack(ThreadFactory factory, JChannel channel, String setup_string) throws ChannelException {
        this.thread_factory = new PatternedThreadFactory(factory, null);
        this.setup_string = setup_string;
        this.channel = channel;
        ClassConfigurator.getInstance(true);
        this.timer_thread_factory = new PatternedThreadFactory(ProtocolStack.newThreadFactory(new ThreadGroup(Util.getGlobalThreadGroup(), "Timers"), "Timer", true), null);
        this.timer = new TimeScheduler(this.timer_thread_factory);
    }

    public ProtocolStack() throws ChannelException {
        this(null, null, null);
    }

    public ThreadFactory getThreadFactory() {
        return this.thread_factory;
    }

    public ThreadFactory getTimerThreadFactory() {
        return this.timer_thread_factory;
    }

    public void setThreadFactory(ThreadFactory f) {
        this.thread_factory = new PatternedThreadFactory(f, null);
    }

    public void setTimerThreadFactory(ThreadFactory f) {
        this.timer_thread_factory = new PatternedThreadFactory(f, null);
        this.timer.setThreadFactory(f);
    }

    public Map<Thread, ReentrantLock> getLocks() {
        return this.locks;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public int getTimerThreads() {
        return this.timer.getCorePoolSize();
    }

    public Vector<Protocol> getProtocols() {
        Vector<Protocol> v = new Vector<Protocol>();
        for (Protocol p = this.top_prot; p != null; p = p.getDownProtocol()) {
            v.addElement(p);
        }
        return v;
    }

    public Protocol getTransport() {
        Vector<Protocol> prots = this.getProtocols();
        return !prots.isEmpty() ? prots.lastElement() : null;
    }

    public static ConcurrentMap<String, Tuple<TP, Short>> getSingletonTransports() {
        return singleton_transports;
    }

    @Override
    public Map<String, Object> dumpStats() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        for (Protocol p = this.top_prot; p != null; p = p.getDownProtocol()) {
            String prot_name = p.getName();
            Map<String, Object> tmp = p.dumpStats();
            if (prot_name == null || tmp == null) continue;
            retval.put(prot_name, tmp);
        }
        return retval;
    }

    public String dumpTimerQueue() {
        return this.timer.dumpTaskQueue();
    }

    public String printProtocolSpec(boolean include_properties) {
        StringBuilder sb = new StringBuilder();
        Protocol prot = this.top_prot;
        while (prot != null) {
            Properties tmpProps;
            String name = prot.getName();
            if (name == null) continue;
            if ("ProtocolStack".equals(name)) break;
            sb.append(name);
            if (include_properties && (tmpProps = prot.getProperties()) != null) {
                sb.append('\n');
                for (Map.Entry<Object, Object> entry : tmpProps.entrySet()) {
                    sb.append(entry).append("\n");
                }
            }
            sb.append('\n');
            prot = prot.getDownProtocol();
        }
        return sb.toString();
    }

    public String printProtocolSpecAsXML() {
        StringBuilder sb = new StringBuilder();
        Protocol prot = this.bottom_prot;
        int max_len = 30;
        sb.append("<config>\n");
        while (prot != null) {
            String name = prot.getName();
            if (name == null) continue;
            if ("ProtocolStack".equals(name)) break;
            sb.append("  <").append(name).append(" ");
            Properties tmpProps = prot.getProperties();
            if (tmpProps != null) {
                int len = name.length();
                for (Map.Entry<Object, Object> entry : tmpProps.entrySet()) {
                    String s = entry.getKey() + "=\"" + entry.getValue() + "\" ";
                    if (len + s.length() > max_len) {
                        sb.append("\n       ");
                        len = 8;
                    }
                    sb.append(s);
                    len += s.length();
                }
            }
            sb.append("/>\n");
            prot = prot.getUpProtocol();
        }
        sb.append("</config>");
        return sb.toString();
    }

    public void setup() throws Exception {
        if (this.top_prot == null) {
            this.top_prot = Configurator.setupProtocolStack(this.setup_string, this);
            this.top_prot.setUpProtocol(this);
            this.bottom_prot = Configurator.getBottommostProtocol(this.top_prot);
            Vector<Protocol> protocols = this.getProtocols();
            Configurator.initProtocolStack(protocols);
        }
    }

    public Protocol createProtocol(String prot_spec) throws Exception {
        return Configurator.createProtocol(prot_spec, this);
    }

    public void insertProtocol(Protocol prot, int position, String neighbor_prot) throws Exception {
        Configurator.insertProtocol(prot, position, neighbor_prot, this);
    }

    public Protocol removeProtocol(String prot_name) throws Exception {
        return Configurator.removeProtocol(this.top_prot, prot_name);
    }

    public Protocol findProtocol(String name) {
        for (Protocol tmp = this.top_prot; tmp != null; tmp = tmp.getDownProtocol()) {
            String prot_name = tmp.getName();
            if (prot_name == null || !prot_name.equals(name)) continue;
            return tmp;
        }
        return null;
    }

    public Protocol findProtocol(Class<?> clazz) {
        for (Protocol tmp = this.top_prot; tmp != null; tmp = tmp.getDownProtocol()) {
            Class<?> protClass = tmp.getClass();
            if (!clazz.isAssignableFrom(protClass)) continue;
            return tmp;
        }
        return null;
    }

    @Override
    public void destroy() {
        if (this.top_prot != null) {
            Configurator.destroyProtocolStack(this.getProtocols());
            this.top_prot = null;
        }
        try {
            this.timer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startStack(String cluster_name) throws Exception {
        if (!this.stopped) {
            return;
        }
        this.timer.start();
        Configurator.startProtocolStack(this.getProtocols(), cluster_name, singleton_transports);
        this.stopped = false;
    }

    public void stopStack(String cluster_name) {
        if (this.stopped) {
            return;
        }
        Configurator.stopProtocolStack(this.getProtocols(), cluster_name, singleton_transports);
        this.stopped = true;
    }

    public void flushEvents() {
    }

    @Override
    public void send(Message msg) throws Exception {
        this.down(new Event(1, msg));
    }

    @Override
    public Object receive(long timeout) throws Exception {
        throw new Exception("ProtocolStack.receive(): not implemented !");
    }

    @Override
    public String getName() {
        return "ProtocolStack";
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 84: {
                Map info = (Map)evt.getArg();
                if (!info.containsKey("thread_naming_pattern")) break;
                ThreadNamingPattern thread_naming_pattern = (ThreadNamingPattern)info.get("thread_naming_pattern");
                this.thread_factory.setThreadNamingPattern(thread_naming_pattern);
                this.timer_thread_factory.setThreadNamingPattern(thread_naming_pattern);
            }
        }
        return this.channel.up(evt);
    }

    @Override
    public Object down(Event evt) {
        ReentrantLock lock = this.locks.remove(Thread.currentThread());
        if (lock != null && lock.isHeldByCurrentThread()) {
            lock.unlock();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("released lock held by " + Thread.currentThread()));
            }
        }
        if (this.top_prot != null) {
            return this.top_prot.down(evt);
        }
        return null;
    }

    public static ThreadFactory newThreadFactory(ThreadGroup group, String baseName, boolean createDaemons) {
        return new DefaultThreadFactory(group, baseName, createDaemons);
    }

    public static ThreadFactory newThreadFactory(ThreadNamingPattern pattern, ThreadGroup group, String baseName, boolean createDaemons) {
        return new PatternedThreadFactory(new DefaultThreadFactory(group, baseName, createDaemons), pattern);
    }

    static class PatternedThreadFactory
    implements ThreadFactory {
        private final ThreadFactory f;
        private ThreadNamingPattern pattern;

        public PatternedThreadFactory(ThreadFactory factory, ThreadNamingPattern pattern) {
            this.f = factory;
            this.pattern = pattern;
        }

        public void setThreadNamingPattern(ThreadNamingPattern pattern) {
            this.pattern = pattern;
        }

        public Thread newThread(Runnable r, String name) {
            Thread newThread = this.f.newThread(r, name);
            if (this.pattern != null) {
                this.pattern.renameThread(newThread);
            }
            return newThread;
        }

        public Thread newThread(Runnable r) {
            Thread newThread = this.f.newThread(r);
            if (this.pattern != null) {
                this.pattern.renameThread(newThread);
            }
            return newThread;
        }

        public Thread newThread(ThreadGroup group, Runnable r, String name) {
            Thread newThread = this.f.newThread(group, r, name);
            if (this.pattern != null) {
                this.pattern.renameThread(newThread);
            }
            return newThread;
        }
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final String baseName;
        private final boolean createDaemons;

        public DefaultThreadFactory(ThreadGroup group, String baseName, boolean createDaemons) {
            this.group = group;
            this.baseName = baseName;
            this.createDaemons = createDaemons;
        }

        public Thread newThread(Runnable r, String name) {
            return this.newThread(this.group, r, name);
        }

        public Thread newThread(Runnable r) {
            return this.newThread(this.group, r, this.baseName);
        }

        public Thread newThread(ThreadGroup group, Runnable r, String name) {
            Thread thread = new Thread(group, r, name);
            thread.setDaemon(this.createDaemons);
            return thread;
        }
    }
}

