/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolData;
import org.jgroups.conf.ProtocolParameter;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class SharedTransportTest
extends ChannelTestBase {
    private JChannel a;
    private JChannel b;
    private JChannel c;
    private MyReceiver r1;
    private MyReceiver r2;
    private MyReceiver r3;
    static final String SINGLETON_1 = "singleton-1";
    static final String SINGLETON_2 = "singleton-2";

    protected void tearDown() throws Exception {
        if (this.c != null) {
            this.c.close();
        }
        if (this.b != null) {
            this.b.close();
        }
        if (this.a != null) {
            this.a.close();
        }
        this.r3 = null;
        this.r2 = null;
        this.r1 = null;
        super.tearDown();
    }

    public void testCreationNonSharedTransport() throws Exception {
        this.a = this.createChannel();
        this.a.connect("x");
        View view = this.a.getView();
        System.out.println("view = " + view);
        SharedTransportTest.assertEquals((int)1, (int)view.size());
    }

    public void testCreationOfDuplicateCluster() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.a.connect("x");
        try {
            this.b.connect("x");
            SharedTransportTest.fail((String)"b should not be able to join cluster 'x' as a has already joined it");
        }
        catch (Exception ex) {
            System.out.println("b was not able to join the same cluster (\"x\") as expected");
        }
    }

    public void testView() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_2);
        this.a.setReceiver(new MyReceiver(SINGLETON_1));
        this.b.setReceiver(new MyReceiver(SINGLETON_2));
        this.a.connect("x");
        this.b.connect("x");
        View view = this.a.getView();
        SharedTransportTest.assertEquals((int)2, (int)view.size());
        view = this.b.getView();
        SharedTransportTest.assertEquals((int)2, (int)view.size());
    }

    public void testView2() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.a.setReceiver(new MyReceiver("first-channel"));
        this.b.setReceiver(new MyReceiver("second-channel"));
        this.a.connect("x");
        this.b.connect("y");
        View view = this.a.getView();
        SharedTransportTest.assertEquals((int)1, (int)view.size());
        view = this.b.getView();
        SharedTransportTest.assertEquals((int)1, (int)view.size());
    }

    public void testView3() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.c = SharedTransportTest.createSharedChannel(SINGLETON_2);
        this.r1 = new MyReceiver("A::singleton-1");
        this.r2 = new MyReceiver("B::singleton-1");
        this.r3 = new MyReceiver("C::singleton-2");
        this.a.setReceiver(this.r1);
        this.b.setReceiver(this.r2);
        this.c.setReceiver(this.r3);
        this.a.connect("a");
        this.c.connect("a");
        View view = this.a.getView();
        SharedTransportTest.assertEquals((int)2, (int)view.size());
        view = this.c.getView();
        SharedTransportTest.assertEquals((int)2, (int)view.size());
        this.a.send(new Message(null, null, (Serializable)((Object)"msg-1")));
        this.c.send(new Message(null, null, (Serializable)((Object)"msg-2")));
        Util.sleep(1000L);
        List<Message> list = this.r1.getList();
        SharedTransportTest.assertEquals((int)2, (int)list.size());
        list = this.r3.getList();
        SharedTransportTest.assertEquals((int)2, (int)list.size());
        this.r1.clear();
        this.r2.clear();
        this.r3.clear();
        this.b.connect("b");
        this.a.send(new Message(null, null, (Serializable)((Object)"msg-3")));
        this.b.send(new Message(null, null, (Serializable)((Object)"msg-4")));
        this.c.send(new Message(null, null, (Serializable)((Object)"msg-5")));
        Util.sleep(1000L);
        list = this.r1.getList();
        SharedTransportTest.assertEquals((int)2, (int)list.size());
        list = this.r2.getList();
        SharedTransportTest.assertEquals((int)1, (int)list.size());
        list = this.r3.getList();
        SharedTransportTest.assertEquals((int)2, (int)list.size());
    }

    private static void printLists(MyReceiver ... receivers) {
        StringBuilder sb = new StringBuilder();
        int cnt = 1;
        for (MyReceiver rec : receivers) {
            List<Message> list = rec.getList();
            sb.append("receiver #" + cnt++).append(":\n");
            for (Message msg : list) {
                sb.append(msg.getObject()).append("\n");
            }
        }
        System.out.println(sb);
    }

    public void testSharedTransportAndNonsharedTransport() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b = this.createChannel();
        this.a.setReceiver(new MyReceiver("first-channel"));
        this.b.setReceiver(new MyReceiver("second-channel"));
        this.a.connect("x");
        this.b.connect("x");
        View view = this.a.getView();
        SharedTransportTest.assertEquals((int)2, (int)view.size());
        view = this.b.getView();
        SharedTransportTest.assertEquals((int)2, (int)view.size());
    }

    public void testCreationOfDifferentCluster() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_2);
        this.a.connect("x");
        this.b.connect("x");
        View view = this.b.getView();
        System.out.println("b's view is " + view);
        SharedTransportTest.assertEquals((int)2, (int)view.size());
    }

    public void testReferenceCounting() throws ChannelException {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.r1 = new MyReceiver("a");
        this.a.setReceiver(this.r1);
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.r2 = new MyReceiver("b");
        this.b.setReceiver(this.r2);
        this.c = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.r3 = new MyReceiver("c");
        this.c.setReceiver(this.r3);
        this.a.connect("A");
        this.b.connect("B");
        this.c.connect("C");
        this.a.send(null, null, (Serializable)((Object)"message from a"));
        this.b.send(null, null, (Serializable)((Object)"message from b"));
        this.c.send(null, null, (Serializable)((Object)"message from c"));
        Util.sleep(500L);
        SharedTransportTest.assertEquals((int)1, (int)this.r1.size());
        SharedTransportTest.assertEquals((int)1, (int)this.r2.size());
        SharedTransportTest.assertEquals((int)1, (int)this.r3.size());
        this.r1.clear();
        this.r2.clear();
        this.r3.clear();
        this.b.disconnect();
        System.out.println("\n");
        this.a.send(null, null, (Serializable)((Object)"message from a"));
        this.c.send(null, null, (Serializable)((Object)"message from c"));
        Util.sleep(500L);
        SharedTransportTest.assertEquals((int)1, (int)this.r1.size());
        SharedTransportTest.assertEquals((int)1, (int)this.r3.size());
        this.r1.clear();
        this.r3.clear();
        this.c.disconnect();
        System.out.println("\n");
        this.a.send(null, null, (Serializable)((Object)"message from a"));
        Util.sleep(500L);
        SharedTransportTest.assertEquals((int)1, (int)this.r1.size());
    }

    public void testSimpleReCreation() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.a.setReceiver(new MyReceiver("A"));
        this.a.connect("A");
        this.a.disconnect();
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b.setReceiver(new MyReceiver("A'"));
        this.b.connect("A");
    }

    public void testCreationFollowedByDeletion() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.a.setReceiver(new MyReceiver("A"));
        this.a.connect("A");
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b.setReceiver(new MyReceiver("B"));
        this.b.connect("B");
        this.b.close();
        this.a.close();
    }

    public void test2ChannelsCreationFollowedByDeletion() throws Exception {
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.a.setReceiver(new MyReceiver("A"));
        this.a.connect("A");
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_2);
        this.b.setReceiver(new MyReceiver("B"));
        this.b.connect("A");
        this.c = SharedTransportTest.createSharedChannel(SINGLETON_2);
        this.c.setReceiver(new MyReceiver("C"));
        this.c.connect("B");
        this.c.send(null, null, (Serializable)((Object)"hello world from C"));
    }

    public void testReCreationWithSurvivingChannel() throws Exception {
        System.out.println("-- creating A");
        this.a = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.a.setReceiver(new MyReceiver("A"));
        this.a.connect("A");
        System.out.println("-- creating B");
        this.b = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.b.setReceiver(new MyReceiver("B"));
        this.b.connect("B");
        System.out.println("-- disconnecting A");
        this.a.disconnect();
        System.out.println("-- creating A'");
        this.c = SharedTransportTest.createSharedChannel(SINGLETON_1);
        this.c.setReceiver(new MyReceiver("A'"));
        this.c.connect("A");
    }

    private static JChannel createSharedChannel(String singleton_name) throws ChannelException {
        ProtocolStackConfigurator config = ConfiguratorFactory.getStackConfigurator(CHANNEL_CONFIG);
        ProtocolData[] protocols = config.getProtocolStack();
        ProtocolData transport = protocols[0];
        transport.getParameters().put("singleton_name", new ProtocolParameter("singleton_name", singleton_name));
        return new JChannel(config);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReceiver
    extends ReceiverAdapter {
        final List<Message> list = new LinkedList<Message>();
        final String name;

        private MyReceiver(String name) {
            this.name = name;
        }

        public List<Message> getList() {
            return this.list;
        }

        public int size() {
            return this.list.size();
        }

        public void clear() {
            this.list.clear();
        }

        @Override
        public void receive(Message msg) {
            System.out.println("[" + this.name + "]: received message from " + msg.getSrc() + ": " + msg.getObject());
            this.list.add(msg);
        }

        @Override
        public void viewAccepted(View new_view) {
            StringBuilder sb = new StringBuilder();
            sb.append("[" + this.name + "]: view = " + new_view);
            System.out.println(sb);
        }
    }
}

