/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListenerAdapter;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.mux.MuxChannel;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.FD;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class ShunTest
extends ChannelTestBase {
    JChannel c1;
    JChannel c2;
    RpcDispatcher disp1;
    RpcDispatcher disp2;

    public void setUp() throws Exception {
        super.setUp();
        CHANNEL_CONFIG = System.getProperty("channel.conf.flush", "flush-udp.xml");
    }

    protected void tearDown() throws Exception {
        if (this.disp2 != null) {
            this.disp2.stop();
        }
        if (this.c2 != null) {
            this.c2.close();
        }
        if (this.disp1 != null) {
            this.disp1.stop();
        }
        if (this.c1 != null) {
            this.c1.close();
        }
        super.tearDown();
    }

    public boolean useBlocking() {
        return true;
    }

    public void testShunning() {
        this.connectAndShun(2, false);
    }

    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public void testTwoMembersShun() throws Exception {
        View view;
        CHANNEL_CONFIG = System.getProperty("channel.conf.flush", "udp.xml");
        this.c1 = this.createChannel();
        this.c1.setOpt(6, false);
        this.c1.addChannelListener(new BelasChannelListener("C1"));
        this.c2 = this.createChannel();
        this.c2.setOpt(6, false);
        this.c2.addChannelListener(new BelasChannelListener("C2"));
        this.disp1 = new RpcDispatcher((Channel)this.c1, null, (MembershipListener)new BelasReceiver("C1"), (Object)this);
        this.disp2 = new RpcDispatcher((Channel)this.c2, null, (MembershipListener)new BelasReceiver("C2"), (Object)this);
        this.c1.connect("demo");
        this.c2.connect("demo");
        ShunTest.assertEquals((int)2, (int)this.c1.getView().size());
        RspList rsps = this.disp2.callRemoteMethods(null, "getCurrentTime", null, (Class[])null, 2, 10000L);
        System.out.println(">> rsps:\n" + rsps);
        ShunTest.assertEquals((int)2, (int)rsps.size());
        ProtocolStack stack = this.c1.getProtocolStack();
        stack.removeProtocol("VERIFY_SUSPECT");
        Protocol transport = stack.getTransport();
        System.out.println(">> suspecting C2:");
        transport.up(new Event(9, this.c2.getLocalAddress()));
        System.out.println(">> shunning C2:");
        if (this.c2 instanceof MuxChannel) {
            ((MuxChannel)this.c2).getChannel().up(new Event(46));
        } else {
            this.c2.up(new Event(46));
        }
        Util.sleep(1000L);
        System.out.println("waiting for C2 to come back");
        for (int count = 1; ((view = this.c2.getView()) == null || view.size() < 2) && count < 10; ++count) {
            Util.sleep(1000L);
        }
        view = this.c2.getView();
        System.out.println(">>> view is " + view + " <<<< (should have 2 members)");
        ShunTest.assertEquals((int)2, (int)view.size());
        Util.sleep(1000L);
        System.out.println("invoking RPC on shunned member");
        rsps = this.disp2.callRemoteMethods(null, "getCurrentTime", null, (Class[])null, 2, 10000L);
        System.out.println(">> rsps:\n" + rsps);
        ShunTest.assertEquals((int)2, (int)rsps.size());
        for (Map.Entry<Address, Rsp> entry : rsps.entrySet()) {
            Rsp rsp = entry.getValue();
            ShunTest.assertFalse((boolean)rsp.wasSuspected());
            ShunTest.assertTrue((boolean)rsp.wasReceived());
        }
        this.c1.setReceiver(null);
        this.c2.setReceiver(null);
        this.c1.clearChannelListeners();
        this.c2.clearChannelListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectAndShun(int shunChannelIndex, boolean useDispatcher) {
        String[] names = null;
        names = ShunTest.isMuxChannelUsed() ? this.createMuxApplicationNames(1) : new String[]{"A", "B", "C", "D"};
        int count = names.length;
        ChannelTestBase.MemberRetrievable[] channels = new ShunChannel[count];
        try {
            Semaphore semaphore = new Semaphore(count);
            semaphore.acquire(count);
            for (int i = 0; i < count; ++i) {
                channels[i] = new ShunChannel(names[i], semaphore, useDispatcher);
                JChannel c = (JChannel)((ChannelTestBase.ChannelApplication)channels[i]).getChannel();
                if (c instanceof MuxChannel) {
                    c = ((MuxChannel)c).getChannel();
                }
                c.addChannelListener(new MyChannelListener((ShunChannel[])channels));
                ((ChannelTestBase.ChannelApplication)channels[i]).start();
                semaphore.release(1);
                Util.sleep(2000L);
            }
            if (ShunTest.isMuxChannelUsed()) {
                ShunTest.blockUntilViewsReceived(channels, this.getMuxFactoryCount(), 60000L);
            } else {
                ShunTest.blockUntilViewsReceived(channels, 60000L);
            }
            ChannelTestBase.MemberRetrievable shun = channels[shunChannelIndex];
            this.log.info((Object)"Start shun attempt");
            this.addDiscardProtocol((JChannel)((ChannelTestBase.ChannelApplication)shun).getChannel());
            Util.sleep(20000L);
            if (ShunTest.isMuxChannelUsed()) {
                ShunTest.blockUntilViewsReceived(channels, this.getMuxFactoryCount(), 60000L);
            } else {
                ShunTest.blockUntilViewsReceived(channels, 60000L);
            }
        }
        catch (Exception ex) {
            this.log.warn((Object)"Exception encountered during test", (Throwable)ex);
            ShunTest.fail((String)ex.getLocalizedMessage());
        }
        finally {
            for (ChannelTestBase.MemberRetrievable channel : channels) {
                ((ChannelTestBase.ChannelApplication)channel).cleanup();
                Util.sleep(2000L);
            }
        }
    }

    private void modifyStack(JChannel ch) {
        ProtocolStack stack = ch.getProtocolStack();
        try {
            ch.getProtocolStack().removeProtocol("VERIFY_SUSPECT");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FD fd = (FD)stack.findProtocol("FD");
        if (fd != null) {
            fd.setMaxTries(3);
            fd.setTimeout(1000L);
        }
    }

    private void addDiscardProtocol(JChannel ch) throws Exception {
        ProtocolStack stack = ch.getProtocolStack();
        Protocol transport = stack.getTransport();
        DISCARD discard = new DISCARD();
        Properties props = new Properties();
        props.setProperty("up", "1.0");
        discard.setProperties(props);
        discard.setProtocolStack(ch.getProtocolStack());
        discard.start();
        stack.insertProtocol(discard, 1, transport.getName());
    }

    public static Test suite() {
        return new TestSuite(ShunTest.class);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{ShunTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    protected class ShunChannel
    extends ChannelTestBase.PushChannelApplicationWithSemaphore {
        public ShunChannel(String name, Semaphore semaphore, boolean useDispatcher) throws Exception {
            super(name, semaphore, useDispatcher);
            ShunTest.this.modifyStack((JChannel)this.channel);
        }

        public void useChannel() throws Exception {
            this.channel.connect("test");
            this.channel.getState(null, 5000L);
            this.channel.send(null, null, this.channel.getLocalAddress());
        }

        public void setState(byte[] state) {
            super.setState(state);
        }

        public byte[] getState() {
            super.getState();
            return new byte[]{106, 103, 114, 111, 117, 112, 115};
        }

        public void getState(OutputStream ostream) {
            super.getState(ostream);
        }

        public void setState(InputStream istream) {
            super.setState(istream);
        }
    }

    private static class BelasReceiver
    extends ReceiverAdapter {
        final String name;

        public BelasReceiver(String name) {
            this.name = name;
        }

        public void viewAccepted(View new_view) {
            System.out.println("[" + this.name + "] new_view = " + new_view);
        }
    }

    private static class BelasChannelListener
    extends ChannelListenerAdapter {
        final String name;

        public BelasChannelListener(String name) {
            this.name = name;
        }

        public void channelClosed(Channel channel) {
            System.out.println("[" + this.name + "] channelClosed()");
        }

        public void channelConnected(Channel channel) {
            System.out.println("[" + this.name + "] channelConnected()");
        }

        public void channelDisconnected(Channel channel) {
            System.out.println("[" + this.name + "] channelDisconnected()");
        }

        public void channelReconnected(Address addr) {
            System.out.println("[" + this.name + "] channelReconnected(" + addr + ")");
        }

        public void channelShunned() {
            System.out.println("[" + this.name + "] channelShunned()");
        }
    }

    private static class MyChannelListener
    extends ChannelListenerAdapter {
        ShunChannel[] channels;
        Channel channel;

        public MyChannelListener(ShunChannel[] channels) {
            this.channels = channels;
        }

        public void channelConnected(Channel channel) {
            this.channel = channel;
        }

        public void channelReconnected(Address addr) {
            System.out.println("Channel reconnected , new address is " + addr);
        }

        public void channelShunned() {
            System.out.println("Shunned channel is " + this.channel.getLocalAddress());
            System.out.println("Removing discard ");
            for (ShunChannel ch : this.channels) {
                JChannel c = (JChannel)ch.getChannel();
                try {
                    if (c.getProtocolStack().findProtocol("DISCARD") == null) continue;
                    c.getProtocolStack().removeProtocol("DISCARD");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    c.close();
                }
            }
        }
    }
}

