/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;
import org.jgroups.ChannelListenerAdapter;
import org.jgroups.JChannel;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.mux.Multiplexer;
import org.jgroups.mux.MuxChannel;
import org.jgroups.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
@MBean(description="Factory to create channels")
public class JChannelFactory
implements ChannelFactory {
    private ProtocolStackConfigurator configurator;
    private Log log = LogFactory.getLog(this.getClass());
    private final Map<String, String> stacks = Collections.synchronizedMap(new HashMap());
    private final Map<String, Multiplexer> channels = Collections.synchronizedMap(new HashMap());
    private MBeanServer server = null;
    @ManagedAttribute(writable=true)
    private String domain = "jgroups";
    @ManagedAttribute(description="Expose channels via JMX", writable=true)
    private boolean expose_channels = true;
    @ManagedAttribute(description="Expose protocols via JMX", writable=true)
    private boolean expose_protocols = true;
    private static final String PROTOCOL_STACKS = "protocol_stacks";
    private static final String STACK = "stack";
    private static final String NAME = "name";
    private static final String CONFIG = "config";

    public JChannelFactory() {
    }

    public JChannelFactory(File properties) throws ChannelException {
        this.configurator = ConfiguratorFactory.getStackConfigurator(properties);
    }

    public JChannelFactory(Element properties) throws ChannelException {
        this.configurator = ConfiguratorFactory.getStackConfigurator(properties);
    }

    public JChannelFactory(URL properties) throws ChannelException {
        this.configurator = ConfiguratorFactory.getStackConfigurator(properties);
    }

    public JChannelFactory(String properties) throws ChannelException {
        this.configurator = ConfiguratorFactory.getStackConfigurator(properties);
    }

    @Override
    public void setMultiplexerConfig(Object properties) throws Exception {
        this.setMultiplexerConfig(properties, true);
    }

    public void setMultiplexerConfig(Object properties, boolean replace) throws Exception {
        InputStream input = ConfiguratorFactory.getConfigStream(properties);
        if (input == null) {
            throw new FileNotFoundException(properties.toString());
        }
        try {
            this.parse(input, replace);
        }
        catch (Exception ex) {
            throw new Exception("failed parsing " + properties, ex);
        }
        finally {
            Util.close(input);
        }
    }

    @Override
    public void setMultiplexerConfig(File file) throws Exception {
        this.setMultiplexerConfig(file, true);
    }

    public void setMultiplexerConfig(File file, boolean replace) throws Exception {
        InputStream input = ConfiguratorFactory.getConfigStream(file);
        if (input == null) {
            throw new FileNotFoundException(file.toString());
        }
        try {
            this.parse(input, replace);
        }
        catch (Exception ex) {
            throw new Exception("failed parsing " + file.toString(), ex);
        }
        finally {
            Util.close(input);
        }
    }

    @Override
    public void setMultiplexerConfig(Element properties) throws Exception {
        this.parse(properties, true);
    }

    public void setMultiplexerConfig(Element properties, boolean replace) throws Exception {
        this.parse(properties, replace);
    }

    @Override
    public void setMultiplexerConfig(URL url) throws Exception {
        this.setMultiplexerConfig(url, true);
    }

    public void setMultiplexerConfig(URL url, boolean replace) throws Exception {
        InputStream input = ConfiguratorFactory.getConfigStream(url);
        if (input == null) {
            throw new FileNotFoundException(url.toString());
        }
        try {
            this.parse(input, replace);
        }
        catch (Exception ex) {
            throw new Exception("failed parsing " + url.toString(), ex);
        }
        finally {
            Util.close(input);
        }
    }

    @Override
    @ManagedOperation
    public void setMultiplexerConfig(String properties) throws Exception {
        this.setMultiplexerConfig(properties, true);
    }

    @ManagedOperation
    public void setMultiplexerConfig(String properties, boolean replace) throws Exception {
        InputStream input = ConfiguratorFactory.getConfigStream(properties);
        if (input == null) {
            throw new FileNotFoundException(properties);
        }
        try {
            this.parse(input, replace);
        }
        catch (Exception ex) {
            throw new Exception("failed parsing " + properties, ex);
        }
        finally {
            Util.close(input);
        }
    }

    @ManagedOperation
    public String getConfig(String stack_name) throws Exception {
        String cfg = this.stacks.get(stack_name);
        if (cfg == null) {
            throw new Exception("stack \"" + stack_name + "\" not found in " + this.stacks.keySet());
        }
        return cfg;
    }

    @ManagedOperation(description="Returns all configurations")
    public String getMultiplexerConfig() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.stacks.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Removes all configurations")
    public void clearConfigurations() {
        this.stacks.clear();
    }

    public boolean removeConfig(String stack_name) {
        return stack_name != null && this.stacks.remove(stack_name) != null;
    }

    public MBeanServer getServer() {
        return this.server;
    }

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean isExposeChannels() {
        return this.expose_channels;
    }

    public void setExposeChannels(boolean expose_channels) {
        this.expose_channels = expose_channels;
    }

    public boolean isExposeProtocols() {
        return this.expose_protocols;
    }

    public void setExposeProtocols(boolean expose_protocols) {
        this.expose_protocols = expose_protocols;
        if (expose_protocols) {
            this.expose_channels = true;
        }
    }

    @Override
    public Channel createChannel(Object properties) throws ChannelException {
        return new JChannel(properties);
    }

    @Override
    public Channel createChannel() throws ChannelException {
        return new JChannel(this.configurator);
    }

    @Override
    public Channel createChannel(String stack_name) throws Exception {
        String props = stack_name != null ? this.getConfig(stack_name) : null;
        return new JChannel(props);
    }

    @Override
    @ManagedOperation(description="Create multiplexed channel")
    public Channel createMultiplexerChannel(String stack_name, String id) throws Exception {
        return this.createMultiplexerChannel(stack_name, id, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManagedOperation(description="Create multiplexed channel with state transfer reguistration")
    public Channel createMultiplexerChannel(String stack_name, String id, boolean register_for_state_transfer, String substate_id) throws Exception {
        if (stack_name == null || id == null) {
            throw new IllegalArgumentException("stack name and service ID have to be non null");
        }
        if (stack_name.length() == 0 || id.length() == 0) {
            throw new IllegalArgumentException("stack name and service ID have to non empty strings");
        }
        Multiplexer mux = null;
        Map<String, Multiplexer> map = this.channels;
        synchronized (map) {
            if (!this.channels.containsKey(stack_name)) {
                JChannel ch = new JChannel(this.getConfig(stack_name));
                this.registerChannel(ch, stack_name);
                mux = new Multiplexer(ch);
                this.channels.put(stack_name, mux);
            } else {
                mux = this.channels.get(stack_name);
            }
        }
        if (register_for_state_transfer) {
            mux.registerForStateTransfer(id, substate_id);
        }
        Channel c = mux.createMuxChannel(id, stack_name);
        c.addChannelListener(new MuxFactoryChannelListener());
        return c;
    }

    public boolean hasMuxChannel(String stack_name, String id) {
        Multiplexer entry = this.channels.get(stack_name);
        if (entry != null) {
            Set<String> services = entry.getServiceIds();
            return services != null && services.contains(id);
        }
        return false;
    }

    public void create() throws Exception {
        if (this.expose_channels) {
            if (this.server == null) {
                this.server = Util.getMBeanServer();
            }
            if (this.server == null) {
                throw new Exception("No MBeanServer found; JChannelFactory needs to be run with an MBeanServer present, e.g. inside JBoss or JDK 5, or with ExposeChannel set to false");
            }
            if (this.domain == null) {
                this.domain = "jgroups";
            }
        }
    }

    @ManagedOperation
    public void start() throws Exception {
    }

    @ManagedOperation
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public void destroy() {
        Map<String, Multiplexer> map = this.channels;
        synchronized (map) {
            for (Map.Entry<String, Multiplexer> entry : this.channels.entrySet()) {
                Multiplexer m = entry.getValue();
                if (m == null) continue;
                m.closeAll();
                m.close();
            }
        }
        this.unregister(this.domain + ":*");
        this.channels.clear();
    }

    @ManagedOperation
    public String dumpConfiguration() {
        return this.stacks.keySet().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public String dumpChannels() {
        StringBuilder sb = new StringBuilder();
        Map<String, Multiplexer> map = this.channels;
        synchronized (map) {
            for (Map.Entry<String, Multiplexer> entry : this.channels.entrySet()) {
                Multiplexer m = entry.getValue();
                sb.append(entry.getKey()).append(": ").append(m.getServiceIds()).append("\n");
            }
        }
        return sb.toString();
    }

    private void registerChannel(JChannel ch, String stack_name) throws Exception {
        if (this.expose_channels && this.server != null) {
            JmxConfigurator.registerChannel(ch, this.server, this.domain, stack_name, this.expose_protocols);
        }
    }

    private void unregister(String name) {
        if (this.expose_channels && this.server != null) {
            try {
                JmxConfigurator.unregister(this.server, name);
            }
            catch (Exception e) {
                this.log.error("failed unregistering " + name, e);
            }
        }
    }

    private void parse(InputStream input, boolean replace) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(input);
        Element configElement = document.getDocumentElement();
        this.parse(configElement, replace);
    }

    private void parse(Element root, boolean replace) throws Exception {
        String root_name = root.getNodeName();
        if (!PROTOCOL_STACKS.equals(root_name.trim().toLowerCase())) {
            String error = "XML protocol stack configuration does not start with a '<protocol_stacks>' element; maybe the XML configuration needs to be converted to the new format ?\nuse 'java org.jgroups.conf.XmlConfigurator <old XML file> -new_format' to do so";
            throw new IOException("invalid XML configuration: " + error);
        }
        NodeList tmp_stacks = root.getChildNodes();
        for (int i = 0; i < tmp_stacks.getLength(); ++i) {
            Node node = tmp_stacks.item(i);
            if (node.getNodeType() != 1) continue;
            Element stack = (Element)node;
            String tmp = stack.getNodeName();
            if (!STACK.equals(tmp.trim().toLowerCase())) {
                throw new IOException("invalid configuration: didn't find a \"stack\" element under \"protocol_stacks\"");
            }
            NamedNodeMap attrs = stack.getAttributes();
            Node name = attrs.getNamedItem(NAME);
            String st_name = name.getNodeValue();
            NodeList configs = stack.getChildNodes();
            for (int j = 0; j < configs.getLength(); ++j) {
                Node tmp_config = configs.item(j);
                if (tmp_config.getNodeType() != 1) continue;
                Element cfg = (Element)tmp_config;
                tmp = cfg.getNodeName();
                if (!CONFIG.equals(tmp)) {
                    throw new IOException("invalid configuration: didn't find a \"config\" element under \"stack\"");
                }
                XmlConfigurator conf = XmlConfigurator.getInstance(cfg);
                ConfiguratorFactory.substituteVariables(conf);
                String val = conf.getProtocolStackString();
                if (replace) {
                    this.stacks.put(st_name, val);
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace("added config '" + st_name + "'");
                    continue;
                }
                if (!this.stacks.containsKey(st_name)) {
                    this.stacks.put(st_name, val);
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace("added config '" + st_name + "'");
                    continue;
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("didn't add config '" + st_name + " because one of the same name already existed");
            }
        }
    }

    private class MuxFactoryChannelListener
    extends ChannelListenerAdapter {
        private MuxFactoryChannelListener() {
        }

        @Override
        public void channelClosed(Channel channel) {
            MuxChannel mch = (MuxChannel)channel;
            Multiplexer multiplexer = mch.getMultiplexer();
            boolean all_closed = multiplexer.close();
            if (all_closed) {
                JChannelFactory.this.channels.remove(mch.getStackName());
                JChannelFactory.this.unregister(JChannelFactory.this.domain + ":*,cluster=" + mch.getStackName());
            }
        }
    }
}

