/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

public class Version {
    public static final short major = 2;
    public static final short minor = 12;
    public static final short micro = 1;
    public static final String description = "2.12.1.3.Final";
    public static final short version = Version.encode(2, 12, 1);
    public static final String string_version = Version.print(version);
    private static final int MAJOR_SHIFT = 11;
    private static final int MINOR_SHIFT = 6;
    private static final int MAJOR_MASK = 63488;
    private static final int MINOR_MASK = 1984;
    private static final int MICRO_MASK = 63;

    public static void main(String[] args) {
        System.out.println("\nVersion:      2.12.1.3.Final");
    }

    public static String printDescription() {
        return "JGroups 2.12.1.3.Final";
    }

    public static String printVersion() {
        return string_version;
    }

    public static boolean isSame(short v) {
        return version == v;
    }

    public static short encode(int major, int minor, int micro) {
        return (short)((major << 11) + (minor << 6) + micro);
    }

    public static String print(short version) {
        int major = (version & 0xF800) >> 11;
        int minor = (version & 0x7C0) >> 6;
        int micro = version & 0x3F;
        return major + "." + minor + "." + micro;
    }

    public static short[] decode(short version) {
        short major = (short)((version & 0xF800) >> 11);
        short minor = (short)((version & 0x7C0) >> 6);
        short micro = (short)(version & 0x3F);
        return new short[]{major, minor, micro};
    }

    public static boolean isBinaryCompatible(short ver) {
        if (version == ver) {
            return true;
        }
        short tmp_major = (short)((ver & 0xF800) >> 11);
        short tmp_minor = (short)((ver & 0x7C0) >> 6);
        return 2 == tmp_major && 12 == tmp_minor;
    }

    public static boolean isBinaryCompatible(short ver1, short ver2) {
        if (ver1 == ver2) {
            return true;
        }
        short[] tmp = Version.decode(ver1);
        short tmp_major = tmp[0];
        short tmp_minor = tmp[1];
        tmp = Version.decode(ver2);
        short tmp_major2 = tmp[0];
        short tmp_minor2 = tmp[1];
        return tmp_major == tmp_major2 && tmp_minor == tmp_minor2;
    }
}

