/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class PingData
implements Streamable {
    private Address own_addr = null;
    private View view = null;
    private boolean is_server = false;
    private String logical_name = null;
    private Collection<PhysicalAddress> physical_addrs = null;

    public PingData() {
    }

    public PingData(Address own_addr, View view, boolean is_server) {
        this.own_addr = own_addr;
        this.view = view;
        this.is_server = is_server;
    }

    public PingData(Address own_addr, View view, boolean is_server, String logical_name, Collection<PhysicalAddress> physical_addrs) {
        this(own_addr, view, is_server);
        this.logical_name = logical_name;
        if (physical_addrs != null) {
            this.physical_addrs = new ArrayList<PhysicalAddress>(physical_addrs);
        }
    }

    public boolean isCoord() {
        Address coord_addr = this.getCoordAddress();
        return this.is_server && this.own_addr != null && coord_addr != null && this.own_addr.equals(coord_addr);
    }

    public boolean hasCoord() {
        Address coord_addr = this.getCoordAddress();
        return this.is_server && this.own_addr != null && coord_addr != null;
    }

    public Address getAddress() {
        return this.own_addr;
    }

    public Address getCoordAddress() {
        return this.view != null ? this.view.getVid().getCoordAddress() : null;
    }

    public Collection<Address> getMembers() {
        return this.view != null ? this.view.getMembers() : null;
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public boolean isServer() {
        return this.is_server;
    }

    public String getLogicalName() {
        return this.logical_name;
    }

    public Collection<PhysicalAddress> getPhysicalAddrs() {
        return this.physical_addrs;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PingData)) {
            return false;
        }
        PingData other = (PingData)obj;
        return this.own_addr != null && this.own_addr.equals(other.own_addr);
    }

    public int hashCode() {
        int retval = 0;
        if (this.own_addr != null) {
            retval += this.own_addr.hashCode();
        }
        if (retval == 0) {
            retval = super.hashCode();
        }
        return retval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("own_addr=").append(this.own_addr).append(", view id=").append(this.view != null ? this.view.getVid() : null).append(", is_server=").append(this.is_server).append(", is_coord=" + this.isCoord());
        if (this.logical_name != null) {
            sb.append(", logical_name=").append(this.logical_name);
        }
        if (this.physical_addrs != null && !this.physical_addrs.isEmpty()) {
            sb.append(", physical_addrs=").append(Util.printListWithDelimiter(this.physical_addrs, ", "));
        }
        return sb.toString();
    }

    @Override
    public void writeTo(DataOutputStream outstream) throws IOException {
        Util.writeAddress(this.own_addr, outstream);
        Util.writeView(this.view, outstream);
        outstream.writeBoolean(this.is_server);
        Util.writeString(this.logical_name, outstream);
        Util.writeAddresses(this.physical_addrs, outstream);
    }

    @Override
    public void readFrom(DataInputStream instream) throws IOException, IllegalAccessException, InstantiationException {
        this.own_addr = Util.readAddress(instream);
        this.view = Util.readView(instream);
        this.is_server = instream.readBoolean();
        this.logical_name = Util.readString(instream);
        this.physical_addrs = Util.readAddresses(instream, ArrayList.class);
    }

    public int size() {
        int retval = 1;
        retval += Util.size(this.own_addr);
        retval += Util.size(this.view);
        ++retval;
        if (this.logical_name != null) {
            retval += this.logical_name.length() + 2;
        }
        retval = (int)((long)retval + Util.size(this.physical_addrs));
        return retval;
    }
}

