/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.ssl;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import java.net.Socket;
import java.security.cert.Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.resource.spi.work.Work;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.tcp.TcpMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;

public class SslMessageReceiver
extends TcpMessageReceiver
implements HandshakeCompletedListener {
    private CountDownLatch handshakeComplete = new CountDownLatch(1);
    private static final long HANDSHAKE_WAIT = 30000L;
    private Certificate[] peerCertificateChain;
    private Certificate[] localCertificateChain;

    public SslMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
    }

    protected Work createWork(Socket socket) throws IOException {
        if (this.endpoint.isStreaming()) {
            return new SslStreamWorker(socket, (AbstractMessageReceiver)this);
        }
        return new SslWorker(socket, (AbstractMessageReceiver)this);
    }

    private void preRoute(MuleMessage message) throws Exception {
        this.handshakeComplete.await(30000L, TimeUnit.MILLISECONDS);
        if (0L != this.handshakeComplete.getCount()) {
            throw new IllegalStateException("Handshake did not complete");
        }
        if (this.peerCertificateChain != null) {
            message.setProperty("PEER_CERTIFICATES", this.peerCertificateChain);
        }
        if (this.localCertificateChain != null) {
            message.setProperty("LOCAL_CERTIFICATES", this.localCertificateChain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handshakeCompleted(HandshakeCompletedEvent event) {
        try {
            this.localCertificateChain = event.getLocalCertificates();
            try {
                this.peerCertificateChain = event.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                this.logger.debug((Object)("Cannot get peer certificate chain: " + e.getMessage()));
            }
        }
        finally {
            this.handshakeComplete.countDown();
        }
    }

    protected class SslStreamWorker
    extends TcpMessageReceiver.TcpStreamWorker {
        public SslStreamWorker(Socket socket, AbstractMessageReceiver receiver) throws IOException {
            super((TcpMessageReceiver)SslMessageReceiver.this, socket, receiver);
            ((SSLSocket)socket).addHandshakeCompletedListener(SslMessageReceiver.this);
        }

        protected void preRouteMuleMessage(MuleMessage message) throws Exception {
            super.preRouteMuleMessage(message);
            SslMessageReceiver.this.preRoute(message);
        }
    }

    protected class SslWorker
    extends TcpMessageReceiver.TcpWorker {
        public SslWorker(Socket socket, AbstractMessageReceiver receiver) throws IOException {
            super(SslMessageReceiver.this, socket, receiver);
            ((SSLSocket)socket).addHandshakeCompletedListener(SslMessageReceiver.this);
        }

        protected void preRouteMuleMessage(MuleMessage message) throws Exception {
            super.preRouteMuleMessage(message);
            SslMessageReceiver.this.preRoute(message);
        }
    }
}

