/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import org.apache.commons.lang.BooleanUtils;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsMessageUtils;
import org.mule.providers.jms.JmsSupport;
import org.mule.providers.jms.filters.JmsSelectorFilter;
import org.mule.providers.jms.i18n.JmsMessages;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.ClassUtils;
import org.mule.util.NumberUtils;
import org.mule.util.StringUtils;
import org.mule.util.concurrent.Latch;
import org.mule.util.concurrent.WaitableBoolean;

public class JmsMessageDispatcher
extends AbstractMessageDispatcher {
    private JmsConnector connector;
    private Session cachedSession;

    public JmsMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (JmsConnector)endpoint.getConnector();
    }

    protected void doDispatch(UMOEvent event) throws Exception {
        this.dispatchMessage(event);
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UMOMessage dispatchMessage(UMOEvent event) throws Exception {
        boolean cached;
        boolean transacted;
        Destination replyTo;
        MessageConsumer consumer;
        MessageProducer producer;
        Session session;
        block56: {
            Message result;
            block57: {
                boolean persistent;
                int priority;
                long ttl;
                Message msg;
                boolean topic;
                block54: {
                    Message result2;
                    block55: {
                        UMOMessage uMOMessage;
                        session = null;
                        producer = null;
                        consumer = null;
                        replyTo = null;
                        transacted = false;
                        cached = false;
                        boolean remoteSync = this.useRemoteSync(event);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("dispatching on endpoint: " + event.getEndpoint().getEndpointURI() + ". Event id is: " + event.getId()));
                        }
                        try {
                            session = this.connector.getSessionFromTransaction();
                            if (session != null) {
                                transacted = true;
                                if (remoteSync) {
                                    throw new IllegalTransactionStateException(JmsMessages.connectorDoesNotSupportSyncReceiveWhenTransacted());
                                }
                            } else if (event.getMessage().getBooleanProperty("cacheJmsSessions", this.connector.isCacheJmsSessions())) {
                                cached = true;
                                if (this.cachedSession != null) {
                                    session = this.cachedSession;
                                } else {
                                    this.cachedSession = session = this.connector.getSession(event.getEndpoint());
                                }
                            } else {
                                session = this.connector.getSession(event.getEndpoint());
                                if (event.getEndpoint().getTransactionConfig().isTransacted()) {
                                    transacted = true;
                                }
                            }
                            UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
                            topic = this.connector.getTopicResolver().isTopic(event.getEndpoint(), true);
                            Destination dest = this.connector.getJmsSupport().createDestination(session, endpointUri.getAddress(), topic);
                            producer = this.connector.getJmsSupport().createProducer(session, dest, topic);
                            Object message = event.getTransformedMessage();
                            if (!(message instanceof Message)) {
                                throw new DispatchException(JmsMessages.checkTransformer("JMS message", message.getClass(), this.connector.getName()), event.getMessage(), event.getEndpoint());
                            }
                            msg = (Message)message;
                            if (event.getMessage().getCorrelationId() != null) {
                                msg.setJMSCorrelationID(event.getMessage().getCorrelationId());
                            }
                            UMOMessage eventMsg = event.getMessage();
                            if (this.connector.supportsProperty("JMSReplyTo")) {
                                Object tempReplyTo = eventMsg.removeProperty("JMSReplyTo");
                                if (tempReplyTo != null) {
                                    if (tempReplyTo instanceof Destination) {
                                        replyTo = (Destination)tempReplyTo;
                                    } else {
                                        boolean replyToTopic = false;
                                        String reply = tempReplyTo.toString();
                                        int i = reply.indexOf(":");
                                        if (i > -1) {
                                            String qtype = reply.substring(0, i);
                                            replyToTopic = "topic".equalsIgnoreCase(qtype);
                                            reply = reply.substring(i + 1);
                                        }
                                        replyTo = this.connector.getJmsSupport().createDestination(session, reply, replyToTopic);
                                    }
                                }
                                if (remoteSync && replyTo == null) {
                                    replyTo = this.connector.getJmsSupport().createTemporaryDestination(session, topic);
                                }
                                if (replyTo != null) {
                                    msg.setJMSReplyTo(replyTo);
                                }
                                if (remoteSync) {
                                    consumer = this.connector.getJmsSupport().createConsumer(session, replyTo, topic);
                                }
                            }
                            String ttlString = (String)eventMsg.removeProperty("timeToLive");
                            String priorityString = (String)eventMsg.removeProperty("priority");
                            String persistentDeliveryString = (String)eventMsg.removeProperty("persistentDelivery");
                            ttl = StringUtils.isNotBlank(ttlString) ? NumberUtils.toLong(ttlString) : 0L;
                            priority = StringUtils.isNotBlank(priorityString) ? NumberUtils.toInt(priorityString) : 4;
                            boolean bl = persistent = StringUtils.isNotBlank(persistentDeliveryString) ? BooleanUtils.toBoolean(persistentDeliveryString) : this.connector.isPersistentDelivery();
                            if (this.connector.isHonorQosHeaders()) {
                                int priorityProp = eventMsg.getIntProperty("JMSPriority", -1);
                                int deliveryModeProp = eventMsg.getIntProperty("JMSDeliveryMode", -1);
                                if (priorityProp != -1) {
                                    priority = priorityProp;
                                }
                                if (deliveryModeProp != -1) {
                                    boolean bl2 = persistent = deliveryModeProp == 2;
                                }
                            }
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Sending message of type " + ClassUtils.getSimpleName(msg.getClass())));
                            }
                            if (consumer == null || !topic) break block54;
                            Latch l = new Latch();
                            ReplyToListener listener = new ReplyToListener(l);
                            consumer.setMessageListener((MessageListener)listener);
                            this.connector.getJmsSupport().send(producer, msg, persistent, priority, ttl, topic);
                            int timeout2 = event.getTimeout();
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Waiting for return event for: " + timeout2 + " ms on " + replyTo));
                            }
                            l.await(timeout2, TimeUnit.MILLISECONDS);
                            consumer.setMessageListener(null);
                            listener.release();
                            result2 = listener.getMessage();
                            if (result2 != null) break block55;
                            this.logger.debug((Object)"No message was returned via replyTo destination");
                            uMOMessage = null;
                            Object var29_37 = null;
                            this.connector.closeQuietly(producer);
                            this.connector.closeQuietly(consumer);
                        }
                        catch (Throwable throwable) {
                            block58: {
                                Object var29_42 = null;
                                this.connector.closeQuietly(producer);
                                this.connector.closeQuietly(consumer);
                                if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                                    if (replyTo instanceof TemporaryQueue) {
                                        this.connector.closeQuietly((TemporaryQueue)replyTo);
                                    } else {
                                        this.connector.closeQuietly((TemporaryTopic)replyTo);
                                    }
                                }
                                if (session == null || cached || transacted) break block58;
                                this.connector.closeQuietly(session);
                            }
                            throw throwable;
                        }
                        if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                            if (replyTo instanceof TemporaryQueue) {
                                this.connector.closeQuietly((TemporaryQueue)replyTo);
                            } else {
                                this.connector.closeQuietly((TemporaryTopic)replyTo);
                            }
                        }
                        if (session != null && !cached && !transacted) {
                            this.connector.closeQuietly(session);
                        }
                        return uMOMessage;
                    }
                    UMOMessageAdapter adapter = this.connector.getMessageAdapter(result2);
                    MuleMessage muleMessage = new MuleMessage(JmsMessageUtils.toObject(result2, this.connector.getSpecification()), adapter);
                    Object var29_38 = null;
                    this.connector.closeQuietly(producer);
                    this.connector.closeQuietly(consumer);
                    if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                        if (replyTo instanceof TemporaryQueue) {
                            this.connector.closeQuietly((TemporaryQueue)replyTo);
                        } else {
                            this.connector.closeQuietly((TemporaryTopic)replyTo);
                        }
                    }
                    if (session != null && !cached && !transacted) {
                        this.connector.closeQuietly(session);
                    }
                    return muleMessage;
                }
                this.connector.getJmsSupport().send(producer, msg, persistent, priority, ttl, topic);
                if (consumer == null) break block56;
                int timeout = event.getTimeout();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Waiting for return event for: " + timeout + " ms on " + replyTo));
                }
                if ((result = consumer.receive((long)timeout)) != null) break block57;
                this.logger.debug((Object)"No message was returned via replyTo destination");
                UMOMessage timeout2 = null;
                Object var29_39 = null;
                this.connector.closeQuietly(producer);
                this.connector.closeQuietly(consumer);
                if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                    if (replyTo instanceof TemporaryQueue) {
                        this.connector.closeQuietly((TemporaryQueue)replyTo);
                    } else {
                        this.connector.closeQuietly((TemporaryTopic)replyTo);
                    }
                }
                if (session != null && !cached && !transacted) {
                    this.connector.closeQuietly(session);
                }
                return timeout2;
            }
            UMOMessageAdapter adapter = this.connector.getMessageAdapter(result);
            MuleMessage muleMessage = new MuleMessage(JmsMessageUtils.toObject(result, this.connector.getSpecification()), adapter);
            Object var29_40 = null;
            this.connector.closeQuietly(producer);
            this.connector.closeQuietly(consumer);
            if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                if (replyTo instanceof TemporaryQueue) {
                    this.connector.closeQuietly((TemporaryQueue)replyTo);
                } else {
                    this.connector.closeQuietly((TemporaryTopic)replyTo);
                }
            }
            if (session != null && !cached && !transacted) {
                this.connector.closeQuietly(session);
            }
            return muleMessage;
        }
        UMOMessage uMOMessage = null;
        Object var29_41 = null;
        this.connector.closeQuietly(producer);
        this.connector.closeQuietly(consumer);
        if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
            if (replyTo instanceof TemporaryQueue) {
                this.connector.closeQuietly((TemporaryQueue)replyTo);
            } else {
                this.connector.closeQuietly((TemporaryTopic)replyTo);
            }
        }
        if (session != null && !cached && !transacted) {
            this.connector.closeQuietly(session);
        }
        return uMOMessage;
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        UMOMessage message = this.dispatchMessage(event);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected UMOMessage doReceive(long timeout) throws Exception {
        Message message;
        MessageConsumer consumer;
        Session session;
        block12: {
            String durableName;
            session = null;
            consumer = null;
            boolean topic = this.connector.getTopicResolver().isTopic(this.endpoint);
            JmsSupport support = this.connector.getJmsSupport();
            session = this.connector.getSession(false, topic);
            Destination dest = support.createDestination(session, this.endpoint.getEndpointURI().getAddress(), topic);
            String selector = null;
            if (this.endpoint.getFilter() != null && this.endpoint.getFilter() instanceof JmsSelectorFilter) {
                selector = ((JmsSelectorFilter)this.endpoint.getFilter()).getExpression();
            } else if (this.endpoint.getProperties() != null) {
                selector = (String)this.endpoint.getProperties().get("selector");
            }
            String tempDurable = (String)this.endpoint.getProperties().get("durable");
            boolean durable = this.connector.isDurable();
            if (tempDurable != null) {
                durable = Boolean.valueOf(tempDurable);
            }
            if ((durableName = (String)this.endpoint.getProperties().get("durableName")) == null && durable && topic) {
                durableName = "mule." + this.connector.getName() + "." + this.endpoint.getEndpointURI().getAddress();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Jms Connector for this receiver is durable but no durable name has been specified. Defaulting to: " + durableName));
                }
            }
            consumer = support.createConsumer(session, dest, selector, this.connector.isNoLocal(), durableName, topic);
            message = timeout == -1L ? consumer.receiveNoWait() : (timeout == 0L ? consumer.receive() : consumer.receive(timeout));
            if (message != null) break block12;
            UMOMessage uMOMessage = null;
            this.connector.closeQuietly(consumer);
            this.connector.closeQuietly(session);
            return uMOMessage;
        }
        message = this.connector.preProcessMessage(message, session);
        MuleMessage muleMessage = new MuleMessage(this.connector.getMessageAdapter(message));
        this.connector.closeQuietly(consumer);
        this.connector.closeQuietly(session);
        return muleMessage;
        {
            catch (Exception e) {
                try {
                    this.connector.handleException(e);
                    UMOMessage uMOMessage = null;
                    this.connector.closeQuietly(consumer);
                    this.connector.closeQuietly(session);
                    return uMOMessage;
                }
                catch (Throwable throwable) {
                    this.connector.closeQuietly(consumer);
                    this.connector.closeQuietly(session);
                    throw throwable;
                }
            }
        }
    }

    protected void doDispose() {
    }

    private class ReplyToListener
    implements MessageListener {
        private final Latch latch;
        private volatile Message message;
        private final WaitableBoolean released = new WaitableBoolean(false);

        public ReplyToListener(Latch latch) {
            this.latch = latch;
        }

        public Message getMessage() {
            return this.message;
        }

        public void release() {
            this.released.set(true);
        }

        public void onMessage(Message message) {
            this.message = message;
            this.latch.countDown();
            try {
                this.released.whenTrue(null);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

