/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.vm;

import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import java.util.LinkedList;
import java.util.List;
import org.mule.impl.MuleMessage;
import org.mule.providers.PollingReceiverWorker;
import org.mule.providers.TransactedPollingMessageReceiver;
import org.mule.providers.vm.VMConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueSession;

public class VMMessageReceiver
extends TransactedPollingMessageReceiver {
    private VMConnector connector;
    private final Object lock = new Object();

    public VMMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
        this.setReceiveMessagesInTransaction(endpoint.getTransactionConfig().isTransacted());
        this.connector = (VMConnector)connector;
    }

    protected void schedule() throws RejectedExecutionException, NullPointerException, IllegalArgumentException {
        if (this.connector.isQueueEvents()) {
            super.schedule();
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
        if (this.connector.isQueueEvents()) {
            QueueSession queueSession = this.connector.getQueueSession();
            Queue q = queueSession.getQueue(this.endpoint.getEndpointURI().getAddress());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Current queue depth for queue: " + this.endpoint.getEndpointURI().getAddress() + " is: " + q.size()));
            }
        }
    }

    protected void doDisconnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(UMOEvent event) throws UMOException {
        MuleMessage msg = new MuleMessage(event.getTransformedMessage(), event.getMessage());
        Object object = this.lock;
        synchronized (object) {
            this.routeMessage(msg);
        }
    }

    public Object onCall(UMOEvent event) throws UMOException {
        MuleMessage msg = new MuleMessage(event.getTransformedMessage(), event.getMessage());
        return this.routeMessage((UMOMessage)msg, event.isSynchronous());
    }

    protected List getMessages() throws Exception {
        QueueSession qs = this.connector.getQueueSession();
        Queue queue = qs.getQueue(this.endpoint.getEndpointURI().getAddress());
        LinkedList<UMOEvent> messages = new LinkedList<UMOEvent>();
        int maxThreads = this.connector.getReceiverThreadingProfile().getMaxThreadsActive();
        int batchSize = Math.max(1, Math.min(queue.size(), maxThreads / 2 - 1));
        UMOEvent event = (UMOEvent)queue.poll(this.connector.getQueueTimeout());
        if (event != null) {
            messages.add(event);
            for (int i = 0; i < batchSize && event != null; ++i) {
                event = (UMOEvent)queue.poll(0L);
                if (event == null) continue;
                messages.add(event);
            }
        }
        return messages;
    }

    protected void processMessage(Object msg) throws Exception {
        UMOEvent event = (UMOEvent)msg;
        MuleMessage message = new MuleMessage(event.getTransformedMessage(), event.getMessage());
        this.routeMessage(message);
    }

    protected PollingReceiverWorker createWork() {
        return new VMReceiverWorker(this);
    }

    protected static class VMReceiverWorker
    extends PollingReceiverWorker {
        public VMReceiverWorker(VMMessageReceiver pollingMessageReceiver) {
            super(pollingMessageReceiver);
        }

        public void run() {
            while (this.getReceiver().isConnected()) {
                super.run();
            }
        }
    }
}

