/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.MuleRuntimeException;
import org.mule.config.MuleManifest;
import org.mule.config.PoolingProfile;
import org.mule.config.QueueProfile;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.CoreMessages;
import org.mule.providers.ConnectionStrategy;
import org.mule.providers.SingleAttemptConnectionStrategy;
import org.mule.umo.manager.DefaultWorkListener;
import org.mule.util.FileUtils;
import org.mule.util.StringUtils;
import org.mule.util.queue.EventFilePersistenceStrategy;
import org.mule.util.queue.QueuePersistenceStrategy;

public class MuleConfiguration {
    private static final String DEFAULT_LOG_DIRECTORY = "logs";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    public static final String DEFAULT_SERVER_URL = "tcp://localhost:60504";
    public static final String USE_MANAGER_PROPERTIES = "org.mule.useManagerProperties";
    public static final String SYNCHRONOUS_PROPERTY = "synchronous";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_OS_ENCODING = System.getProperty("file.encoding");
    public static final boolean DEFAULT_SYNCHRONOUS = false;
    public static final int DEFAULT_MAX_OUTSTANDING_MESSAGES = 1000;
    public static final int DEFAULT_TIMEOUT = 10000;
    public static final int DEFAULT_TRANSACTION_TIMEOUT = 30000;
    public static final String DEFAULT_SYSTEM_MODEL_TYPE = "seda";
    public static final String DEFAULT_WORKING_DIRECTORY = "./.mule";
    public static final String DEFAULT_QUEUE_STORE = "queuestore";
    private boolean synchronous = false;
    private String systemModelType = "seda";
    private boolean enableMessageEvents = false;
    private String model = null;
    private String encoding = "UTF-8";
    private String osEncoding = DEFAULT_OS_ENCODING;
    private PoolingProfile poolingProfile = new PoolingProfile();
    private ThreadingProfile messageDispatcherThreadingProfile = null;
    private ThreadingProfile messageReceiverThreadingProfile = null;
    private ThreadingProfile componentPoolThreadingProfile = null;
    private QueueProfile queueProfile = new QueueProfile(1000, false);
    private QueuePersistenceStrategy persistenceStrategy = new EventFilePersistenceStrategy();
    private int synchronousEventTimeout = 10000;
    private int transactionTimeout = 30000;
    private boolean remoteSync = false;
    private boolean recoverableMode = false;
    private ThreadingProfile defaultThreadingProfile = new ThreadingProfile();
    private String workingDirectory;
    private String[] configResources = new String[0];
    private String serverUrl = "tcp://localhost:60504";
    private Manifest manifest = null;
    private boolean clientMode = false;
    private boolean embedded = false;
    private String modelType = "default";
    private ConnectionStrategy connectionStrategy = new SingleAttemptConnectionStrategy();
    private WorkListener workListener = new DefaultWorkListener();
    static /* synthetic */ Class class$org$mule$config$MuleConfiguration;

    public MuleConfiguration() {
        this.setWorkingDirectory(DEFAULT_WORKING_DIRECTORY);
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public ThreadingProfile getMessageDispatcherThreadingProfile() {
        return this.getThreadingProfile(this.messageDispatcherThreadingProfile);
    }

    public void setMessageDispatcherThreadingProfile(ThreadingProfile messageDispatcherThreadingProfile) {
        this.messageDispatcherThreadingProfile = messageDispatcherThreadingProfile;
    }

    public ThreadingProfile getMessageReceiverThreadingProfile() {
        return this.getThreadingProfile(this.messageReceiverThreadingProfile);
    }

    public void setMessageReceiverThreadingProfile(ThreadingProfile messageReceiverThreadingProfile) {
        this.messageReceiverThreadingProfile = messageReceiverThreadingProfile;
    }

    public ThreadingProfile getComponentThreadingProfile() {
        return this.getThreadingProfile(this.componentPoolThreadingProfile);
    }

    public void setComponentThreadingProfile(ThreadingProfile componentPoolThreadingProfile) {
        this.componentPoolThreadingProfile = componentPoolThreadingProfile;
    }

    public ThreadingProfile getDefaultThreadingProfile() {
        return this.getThreadingProfile(this.defaultThreadingProfile);
    }

    public void setDefaultThreadingProfile(ThreadingProfile defaultThreadingProfile) {
        if (defaultThreadingProfile == null) {
            return;
        }
        this.defaultThreadingProfile = defaultThreadingProfile;
    }

    private ThreadingProfile getThreadingProfile(ThreadingProfile profile) {
        if (profile != null) {
            return new ThreadingProfile(profile);
        }
        return new ThreadingProfile(this.defaultThreadingProfile);
    }

    public PoolingProfile getPoolingProfile() {
        return new PoolingProfile(this.poolingProfile);
    }

    public void setPoolingProfile(PoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public int getSynchronousEventTimeout() {
        return this.synchronousEventTimeout;
    }

    public void setSynchronousEventTimeout(int synchronousEventTimeout) {
        this.synchronousEventTimeout = synchronousEventTimeout;
    }

    public boolean isRemoteSync() {
        return this.remoteSync;
    }

    public void setRemoteSync(boolean remoteSync) {
        this.remoteSync = remoteSync;
    }

    public QueueProfile getQueueProfile() {
        return new QueueProfile(this.queueProfile);
    }

    public void setQueueProfile(QueueProfile queueProfile) {
        this.queueProfile = queueProfile;
    }

    public boolean isRecoverableMode() {
        return this.recoverableMode;
    }

    public void setRecoverableMode(boolean recoverableMode) {
        this.recoverableMode = recoverableMode;
        if (recoverableMode) {
            this.queueProfile.setPersistent(true);
        }
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getMuleHomeDirectory() {
        return System.getProperty("mule.home");
    }

    public String getLogDirectory() {
        return this.getMuleHomeDirectory() + File.separator + DEFAULT_LOG_DIRECTORY;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = FileUtils.newFile(workingDirectory).getAbsolutePath().replaceAll("\\\\", "/");
        this.updateApplicationProperty("mule.working.dir", this.workingDirectory);
    }

    public String[] getConfigResources() {
        return this.configResources;
    }

    public void setConfigResources(String[] configResources) {
        if (configResources != null) {
            int current = this.configResources.length;
            String[] newResources = new String[configResources.length + current];
            System.arraycopy(this.configResources, 0, newResources, 0, current);
            System.arraycopy(configResources, 0, newResources, current, configResources.length);
            this.configResources = newResources;
        } else {
            this.configResources = configResources;
        }
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = this.embedded ? null : serverUrl;
    }

    public String getProductVersion() {
        return MuleManifest.getProductVersion();
    }

    public String getVendorName() {
        return MuleManifest.getVendorName();
    }

    public String getVendorUrl() {
        return MuleManifest.getVendorUrl();
    }

    public String getProductUrl() {
        return MuleManifest.getProductUrl();
    }

    public String getProductName() {
        return MuleManifest.getProductName();
    }

    public String getProductMoreInfo() {
        return MuleManifest.getProductMoreInfo();
    }

    public String getProductSupport() {
        return MuleManifest.getProductSupport();
    }

    public String getProductLicenseInfo() {
        return MuleManifest.getProductLicenseInfo();
    }

    public String getProductDescription() {
        return MuleManifest.getProductDescription();
    }

    public String getBuildDate() {
        return MuleManifest.getBuildDate();
    }

    public Manifest getManifest() {
        if (this.manifest == null) {
            this.manifest = new Manifest();
            InputStream is = null;
            try {
                URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            Enumeration<URL> e = (class$org$mule$config$MuleConfiguration == null ? (class$org$mule$config$MuleConfiguration = MuleConfiguration.class$("org.mule.config.MuleConfiguration")) : class$org$mule$config$MuleConfiguration).getClassLoader().getResources("META-INF/MANIFEST.MF");
                            while (e.hasMoreElements()) {
                                URL url = e.nextElement();
                                if (url.toExternalForm().indexOf("mule-core") <= -1) continue;
                                return url;
                            }
                        }
                        catch (IOException e1) {
                            MuleConfiguration.this.logger.error((Object)("Failure reading manifest: " + e1.getMessage()), (Throwable)e1);
                        }
                        return null;
                    }
                });
                if (url != null) {
                    is = url.openStream();
                }
                if (is != null) {
                    this.manifest.read(is);
                }
            }
            catch (IOException e) {
                this.logger.warn((Object)("Failed to read manifest Info, Manifest information will not display correctly: " + e.getMessage()));
            }
        }
        return this.manifest;
    }

    protected String getManifestProperty(String name) {
        return this.getManifest().getMainAttributes().getValue(new Attributes.Name(name));
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
        if (clientMode) {
            this.setServerUrl("");
        }
    }

    public QueuePersistenceStrategy getPersistenceStrategy() {
        return this.persistenceStrategy;
    }

    public void setPersistenceStrategy(QueuePersistenceStrategy persistenceStrategy) {
        this.persistenceStrategy = persistenceStrategy;
    }

    public ConnectionStrategy getConnectionStrategy() {
        try {
            return (ConnectionStrategy)BeanUtils.cloneBean(this.connectionStrategy);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(CoreMessages.failedToClone("Connection Strategy"), (Throwable)e);
        }
    }

    public void setConnectionStrategy(ConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
        if (embedded) {
            this.serverUrl = null;
        }
    }

    public String getModelType() {
        return this.modelType;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (StringUtils.isEmpty(encoding)) {
            this.logger.warn((Object)"Cannot set encoding to null or empty String");
            return;
        }
        this.encoding = encoding;
    }

    public String getOSEncoding() {
        return this.osEncoding;
    }

    public void setOSEncoding(String osEncoding) {
        this.osEncoding = osEncoding;
    }

    public boolean isEnableMessageEvents() {
        return this.enableMessageEvents;
    }

    public void setEnableMessageEvents(boolean enableMessageEvents) {
        this.enableMessageEvents = enableMessageEvents;
    }

    public WorkListener getWorkListener() {
        return this.workListener;
    }

    public void setWorkListener(WorkListener workListener) {
        if (workListener == null) {
            throw new IllegalArgumentException("workListener is null");
        }
        this.workListener = workListener;
    }

    private void updateApplicationProperty(String name, Object value) {
        if (MuleManager.isInstanciated()) {
            MuleManager.getInstance().setProperty(name, value);
        }
    }

    public String getSystemModelType() {
        return this.systemModelType;
    }

    public void setSystemModelType(String systemModelType) {
        this.systemModelType = systemModelType;
    }
}

