/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.endpoint;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.impl.endpoint.EndpointBuilder;
import org.mule.providers.service.TransportFactory;
import org.mule.providers.service.TransportFactoryException;
import org.mule.providers.service.TransportServiceDescriptor;
import org.mule.umo.endpoint.MalformedEndpointException;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.util.PropertiesUtils;
import org.mule.util.StringUtils;

public class MuleEndpointURI
implements UMOEndpointURI {
    private static final long serialVersionUID = 3906735768171252877L;
    protected static final Log logger = LogFactory.getLog((Class)MuleEndpointURI.class);
    private String address;
    private String filterAddress;
    private String endpointName;
    private String connectorName;
    private String transformers;
    private String responseTransformers;
    private int createConnector = 0;
    private Properties params = new Properties();
    private URI uri;
    private String uriString;
    private String userInfo;
    private String schemeMetaInfo;
    private String resourceInfo;

    public static boolean isMuleUri(String url) {
        return url.indexOf(":/") != -1;
    }

    MuleEndpointURI(String address, String endpointName, String connectorName, String transformers, String responseTransformers, int createConnector, Properties properties, URI uri, String userInfo) {
        this(address, endpointName, connectorName, transformers, responseTransformers, createConnector, properties, uri);
        if (userInfo != null) {
            this.userInfo = userInfo;
        }
    }

    public MuleEndpointURI(String address, String endpointName, String connectorName, String transformers, String responseTransformers, int createConnector, Properties properties, URI uri) {
        this.address = address;
        this.endpointName = endpointName;
        this.connectorName = connectorName;
        this.transformers = transformers;
        this.responseTransformers = responseTransformers;
        this.createConnector = createConnector;
        this.params = properties;
        this.uri = uri;
        this.uriString = uri.toASCIIString();
        this.userInfo = uri.getUserInfo();
        if (properties != null) {
            this.resourceInfo = (String)properties.remove("resourceInfo");
        }
    }

    public MuleEndpointURI(UMOEndpointURI endpointUri) {
        this.initialise(endpointUri);
    }

    public MuleEndpointURI(UMOEndpointURI endpointUri, String filterAddress) {
        this.initialise(endpointUri);
        this.filterAddress = filterAddress;
    }

    public MuleEndpointURI(String uri) throws MalformedEndpointException {
        String uriIdentifier = MuleManager.getInstance().lookupEndpointIdentifier(uri, uri);
        if (!uriIdentifier.equals(uri)) {
            this.endpointName = uri;
            uri = uriIdentifier;
        }
        if (!this.validateUrl(uri = uri.trim().replaceAll(" ", "%20"))) {
            throw new MalformedEndpointException(uri);
        }
        try {
            this.schemeMetaInfo = this.retrieveSchemeMetaInfo(uri);
            if (this.schemeMetaInfo != null) {
                uri = uri.replaceFirst(this.schemeMetaInfo + ":", "");
            }
            this.uri = new URI(uri);
            this.userInfo = this.uri.getRawUserInfo();
        }
        catch (URISyntaxException e) {
            throw new MalformedEndpointException(uri, (Throwable)e);
        }
        try {
            String scheme = this.schemeMetaInfo == null ? this.uri.getScheme() : this.schemeMetaInfo;
            TransportServiceDescriptor csd = TransportFactory.getServiceDescriptor(scheme);
            EndpointBuilder builder = csd.createEndpointBuilder();
            UMOEndpointURI built = builder.build(this.uri);
            this.initialise(built);
        }
        catch (TransportFactoryException e) {
            throw new MalformedEndpointException(e);
        }
    }

    private String retrieveSchemeMetaInfo(String url) {
        int i = url.indexOf(58);
        if (i == -1) {
            return null;
        }
        if (url.charAt(i + 1) == '/') {
            return null;
        }
        return url.substring(0, i);
    }

    protected boolean validateUrl(String url) {
        return url.indexOf(":/") > 0;
    }

    private void initialise(UMOEndpointURI endpointUri) {
        this.address = endpointUri.getAddress();
        if (this.endpointName == null) {
            this.endpointName = endpointUri.getEndpointName();
        }
        this.connectorName = endpointUri.getConnectorName();
        this.transformers = endpointUri.getTransformers();
        this.responseTransformers = endpointUri.getResponseTransformers();
        this.createConnector = endpointUri.getCreateConnector();
        this.params = endpointUri.getParams();
        this.uri = endpointUri.getUri();
        this.uriString = this.uri.toASCIIString();
        this.resourceInfo = endpointUri.getResourceInfo();
        this.userInfo = endpointUri.getUserInfo();
    }

    public String getAddress() {
        return this.address;
    }

    public String getEndpointName() {
        return StringUtils.isEmpty(this.endpointName) ? null : this.endpointName;
    }

    public Properties getParams() {
        if (this.params.size() == 0 && this.getQuery() != null) {
            this.params = PropertiesUtils.getPropertiesFromQueryString(this.getQuery());
        }
        return this.params;
    }

    public Properties getUserParams() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.params);
        p.remove("endpointName");
        p.remove("address");
        p.remove("createConnector");
        p.remove("transformers");
        return p;
    }

    public URI parseServerAuthority() throws URISyntaxException {
        return this.uri.parseServerAuthority();
    }

    public URI normalize() {
        return this.uri.normalize();
    }

    public URI resolve(URI uri) {
        return uri.resolve(uri);
    }

    public URI resolve(String str) {
        return this.uri.resolve(str);
    }

    public URI relativize(URI uri) {
        return uri.relativize(uri);
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String getFullScheme() {
        return this.schemeMetaInfo == null ? this.uri.getScheme() : this.schemeMetaInfo + ':' + this.uri.getScheme();
    }

    public boolean isAbsolute() {
        return this.uri.isAbsolute();
    }

    public boolean isOpaque() {
        return this.uri.isOpaque();
    }

    public String getRawSchemeSpecificPart() {
        return this.uri.getRawSchemeSpecificPart();
    }

    public String getSchemeSpecificPart() {
        return this.uri.getSchemeSpecificPart();
    }

    public String getRawAuthority() {
        return this.uri.getRawAuthority();
    }

    public String getAuthority() {
        return this.uri.getAuthority();
    }

    public String getRawUserInfo() {
        return this.uri.getRawUserInfo();
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getRawPath() {
        return this.uri.getRawPath();
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public String getRawQuery() {
        return this.uri.getRawQuery();
    }

    public String getQuery() {
        return this.uri.getQuery();
    }

    public String getRawFragment() {
        return this.uri.getRawFragment();
    }

    public String getFragment() {
        return this.uri.getFragment();
    }

    public String toString() {
        return this.uriString;
    }

    public String getTransformers() {
        return this.transformers;
    }

    public int getCreateConnector() {
        return this.createConnector;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public String getSchemeMetaInfo() {
        return this.schemeMetaInfo == null ? this.uri.getScheme() : this.schemeMetaInfo;
    }

    public String getResourceInfo() {
        return this.resourceInfo;
    }

    public String getFilterAddress() {
        return this.filterAddress;
    }

    public void setEndpointName(String name) {
        this.endpointName = name;
    }

    public String getUsername() {
        if (StringUtils.isNotBlank(this.userInfo)) {
            int i = this.userInfo.indexOf(58);
            if (i == -1) {
                return this.userInfo;
            }
            return this.userInfo.substring(0, i);
        }
        return null;
    }

    public String getResponseTransformers() {
        return this.responseTransformers;
    }

    public String getPassword() {
        int i;
        if (StringUtils.isNotBlank(this.userInfo) && (i = this.userInfo.indexOf(58)) > -1) {
            return this.userInfo.substring(i + 1);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MuleEndpointURI)) {
            return false;
        }
        MuleEndpointURI muleEndpointURI = (MuleEndpointURI)o;
        if (this.createConnector != muleEndpointURI.createConnector) {
            return false;
        }
        if (this.address != null ? !this.address.equals(muleEndpointURI.address) : muleEndpointURI.address != null) {
            return false;
        }
        if (this.connectorName != null ? !this.connectorName.equals(muleEndpointURI.connectorName) : muleEndpointURI.connectorName != null) {
            return false;
        }
        if (this.endpointName != null ? !this.endpointName.equals(muleEndpointURI.endpointName) : muleEndpointURI.endpointName != null) {
            return false;
        }
        if (this.filterAddress != null ? !this.filterAddress.equals(muleEndpointURI.filterAddress) : muleEndpointURI.filterAddress != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(muleEndpointURI.params) : muleEndpointURI.params != null) {
            return false;
        }
        if (this.resourceInfo != null ? !this.resourceInfo.equals(muleEndpointURI.resourceInfo) : muleEndpointURI.resourceInfo != null) {
            return false;
        }
        if (this.schemeMetaInfo != null ? !this.schemeMetaInfo.equals(muleEndpointURI.schemeMetaInfo) : muleEndpointURI.schemeMetaInfo != null) {
            return false;
        }
        if (this.transformers != null ? !this.transformers.equals(muleEndpointURI.transformers) : muleEndpointURI.transformers != null) {
            return false;
        }
        if (this.responseTransformers != null ? !this.responseTransformers.equals(muleEndpointURI.responseTransformers) : muleEndpointURI.responseTransformers != null) {
            return false;
        }
        return !(this.uri != null ? !this.uri.equals(muleEndpointURI.uri) : muleEndpointURI.uri != null);
    }

    public int hashCode() {
        int result = this.address != null ? this.address.hashCode() : 0;
        result = 29 * result + (this.filterAddress != null ? this.filterAddress.hashCode() : 0);
        result = 29 * result + (this.endpointName != null ? this.endpointName.hashCode() : 0);
        result = 29 * result + (this.connectorName != null ? this.connectorName.hashCode() : 0);
        result = 29 * result + (this.transformers != null ? this.transformers.hashCode() : 0);
        result = 29 * result + (this.responseTransformers != null ? this.responseTransformers.hashCode() : 0);
        result = 29 * result + this.createConnector;
        result = 29 * result + (this.params != null ? this.params.hashCode() : 0);
        result = 29 * result + (this.uri != null ? this.uri.hashCode() : 0);
        result = 29 * result + (this.schemeMetaInfo != null ? this.schemeMetaInfo.hashCode() : 0);
        return 29 * result + (this.resourceInfo != null ? this.resourceInfo.hashCode() : 0);
    }
}

