/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.notifications;

import org.mule.impl.internal.notifications.BlockingServerEvent;
import org.mule.umo.UMOTransaction;
import org.mule.umo.manager.UMOServerNotification;

public class TransactionNotification
extends UMOServerNotification
implements BlockingServerEvent {
    private static final long serialVersionUID = -3245036187011582121L;
    public static final int TRANSACTION_BEGAN = 1201;
    public static final int TRANSACTION_COMMITTED = 1202;
    public static final int TRANSACTION_ROLLEDBACK = 1203;
    private static final transient String[] ACTIONS = new String[]{"begin", "commit", "rollback"};
    private String transactionStringId;

    public TransactionNotification(UMOTransaction transaction, int action) {
        super(transaction, action);
        this.transactionStringId = transaction.toString();
    }

    public String getTransactionStringId() {
        return this.transactionStringId;
    }

    protected String getActionName(int action) {
        int i = action - 1200;
        if (i - 1 > ACTIONS.length) {
            return String.valueOf(action);
        }
        return ACTIONS[i - 1];
    }

    public String toString() {
        return this.EVENT_NAME + "{" + "action=" + this.getActionName(this.action) + ", transactionStringId=" + this.transactionStringId + ", timestamp=" + this.timestamp + "}";
    }
}

