/*
 * Decompiled with CFR 0.152.
 */
package org.mule.interceptors;

import java.util.Iterator;
import java.util.List;
import org.mule.umo.Invocation;
import org.mule.umo.UMOException;
import org.mule.umo.UMOInterceptor;
import org.mule.umo.UMOInterceptorStack;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;

public class InterceptorStack
implements UMOInterceptorStack,
Initialisable,
Disposable {
    private List interceptors;

    public InterceptorStack() {
    }

    public InterceptorStack(List interceptors) {
        this.interceptors = interceptors;
    }

    public UMOMessage intercept(Invocation invocation) throws UMOException {
        return new Invoc(invocation).execute();
    }

    public List getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List interceptors) {
        this.interceptors = interceptors;
    }

    public void initialise() throws InitialisationException {
        Iterator it = this.interceptors.iterator();
        while (it.hasNext()) {
            UMOInterceptor interceptor = (UMOInterceptor)it.next();
            if (!(interceptor instanceof Initialisable)) continue;
            ((Initialisable)((Object)interceptor)).initialise();
        }
    }

    public void dispose() {
        Iterator it = this.interceptors.iterator();
        while (it.hasNext()) {
            UMOInterceptor interceptor = (UMOInterceptor)it.next();
            if (!(interceptor instanceof Disposable)) continue;
            ((Disposable)((Object)interceptor)).dispose();
        }
    }

    private class Invoc
    extends Invocation {
        private int cursor;
        private Invocation invocation;

        public Invoc(Invocation invocation) {
            super(invocation.getDescriptor(), invocation.getMessage(), invocation);
            this.cursor = 0;
            this.invocation = invocation;
        }

        public UMOMessage execute() throws UMOException {
            if (InterceptorStack.this.interceptors != null && this.cursor < InterceptorStack.this.interceptors.size()) {
                UMOInterceptor interceptor = (UMOInterceptor)InterceptorStack.this.interceptors.get(this.cursor);
                ++this.cursor;
                this.setMessage(interceptor.intercept(this));
            } else {
                this.invocation.setMessage(this.getMessage());
                this.setMessage(this.invocation.execute());
            }
            return this.getMessage();
        }
    }
}

