/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats;

import java.io.PrintWriter;
import org.mule.management.stats.RouterStatistics;
import org.mule.management.stats.Statistics;
import org.mule.management.stats.printers.SimplePrinter;

public class ComponentStatistics
implements Statistics {
    private static final long serialVersionUID = -2086999226732861674L;
    private String name;
    private long totalExecTime = 0L;
    private long receivedEventSync = 0L;
    private long receivedEventASync = 0L;
    private long queuedEvent = 0L;
    private long maxQueuedEvent = 0L;
    private long averageQueueSize = 0L;
    private long totalQueuedEvent = 0L;
    private long sentEventSync = 0L;
    private long sentReplyToEvent = 0L;
    private long sentEventASync = 0L;
    private long executedEvent = 0L;
    private long executionError = 0L;
    private long fatalError = 0L;
    private long minExecutionTime = 0L;
    private long maxExecutionTime = 0L;
    private long averageExecutionTime = 0L;
    private boolean enabled = false;
    private int threadPoolSize = 0;
    private long samplePeriod = 0L;
    private RouterStatistics inboundRouterStat = null;
    private RouterStatistics outboundRouterStat = null;

    public ComponentStatistics(String name, int threadPoolSize) {
        this.name = name;
        this.threadPoolSize = threadPoolSize;
        this.clear();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean b) {
        this.enabled = b;
        if (this.inboundRouterStat != null) {
            this.inboundRouterStat.setEnabled(b);
        }
        if (this.outboundRouterStat != null) {
            this.outboundRouterStat.setEnabled(b);
        }
    }

    public synchronized void incReceivedEventSync() {
        ++this.receivedEventSync;
    }

    public synchronized void incReceivedEventASync() {
        ++this.receivedEventASync;
    }

    public synchronized void incExecutionError() {
        ++this.executionError;
    }

    public synchronized void incFatalError() {
        ++this.fatalError;
    }

    public synchronized void incSentEventSync() {
        ++this.sentEventSync;
    }

    public synchronized void incSentEventASync() {
        ++this.sentEventASync;
    }

    public synchronized void incSentReplyToEvent() {
        ++this.sentReplyToEvent;
    }

    public synchronized void incQueuedEvent() {
        ++this.queuedEvent;
        ++this.totalQueuedEvent;
        if (this.queuedEvent > this.maxQueuedEvent) {
            this.maxQueuedEvent = this.queuedEvent;
        }
        this.averageQueueSize = Math.round(this.getAsyncEventsReceived() / this.totalQueuedEvent);
    }

    public synchronized void decQueuedEvent() {
        --this.queuedEvent;
    }

    public synchronized void addExecutionTime(long time) {
        ++this.executedEvent;
        this.totalExecTime += time == 0L ? 1L : time;
        if (this.minExecutionTime == 0L || time < this.minExecutionTime) {
            this.minExecutionTime = time;
        }
        if (this.maxExecutionTime == 0L || time > this.maxExecutionTime) {
            this.maxExecutionTime = time;
        }
        this.averageExecutionTime = Math.round(this.totalExecTime / this.executedEvent);
    }

    public long getAverageExecutionTime() {
        return this.averageExecutionTime;
    }

    public long getAverageQueueSize() {
        return this.averageQueueSize;
    }

    public long getMaxQueueSize() {
        return this.maxQueuedEvent;
    }

    public long getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public long getFatalErrors() {
        return this.fatalError;
    }

    public long getMinExecutionTime() {
        return this.minExecutionTime;
    }

    public long getTotalExecutionTime() {
        return this.totalExecTime;
    }

    public long getQueuedEvents() {
        return this.queuedEvent;
    }

    public long getAsyncEventsReceived() {
        return this.receivedEventASync;
    }

    public long getSyncEventsReceived() {
        return this.receivedEventSync;
    }

    public long getReplyToEventsSent() {
        return this.sentReplyToEvent;
    }

    public long getSyncEventsSent() {
        return this.sentEventSync;
    }

    public long getAsyncEventsSent() {
        return this.sentEventASync;
    }

    public long getTotalEventsSent() {
        return this.getSyncEventsSent() + this.getAsyncEventsSent();
    }

    public long getTotalEventsReceived() {
        return this.getSyncEventsReceived() + this.getAsyncEventsReceived();
    }

    public long getExecutedEvents() {
        return this.executedEvent;
    }

    public long getExecutionErrors() {
        return this.executionError;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public void logSummary() {
        this.logSummary(new SimplePrinter(System.out));
    }

    public void logSummary(PrintWriter printer) {
        printer.print(this);
    }

    public synchronized void clear() {
        this.totalExecTime = 0L;
        this.receivedEventSync = 0L;
        this.receivedEventASync = 0L;
        this.queuedEvent = 0L;
        this.maxQueuedEvent = 0L;
        this.totalQueuedEvent = 0L;
        this.averageQueueSize = 0L;
        this.sentEventSync = 0L;
        this.sentEventASync = 0L;
        this.sentReplyToEvent = 0L;
        this.executedEvent = 0L;
        this.executionError = 0L;
        this.fatalError = 0L;
        this.minExecutionTime = 0L;
        this.maxExecutionTime = 0L;
        if (this.getInboundRouterStat() != null) {
            this.getInboundRouterStat().clear();
        }
        if (this.getOutboundRouterStat() != null) {
            this.getOutboundRouterStat().clear();
        }
        this.samplePeriod = System.currentTimeMillis();
    }

    public RouterStatistics getInboundRouterStat() {
        return this.inboundRouterStat;
    }

    public void setInboundRouterStat(RouterStatistics inboundRouterStat) {
        this.inboundRouterStat = inboundRouterStat;
        this.inboundRouterStat.setEnabled(this.enabled);
    }

    public RouterStatistics getOutboundRouterStat() {
        return this.outboundRouterStat;
    }

    public void setOutboundRouterStat(RouterStatistics outboundRouterStat) {
        this.outboundRouterStat = outboundRouterStat;
        this.outboundRouterStat.setEnabled(this.enabled);
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public long getSamplePeriod() {
        return System.currentTimeMillis() - this.samplePeriod;
    }
}

