/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.support;

import java.io.ObjectStreamException;
import java.lang.reflect.Method;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.management.support.JmxLegacySupport;
import org.mule.management.support.JmxModernSupport;
import org.mule.management.support.JmxSupport;
import org.mule.management.support.JmxSupportFactory;
import org.mule.util.ClassUtils;

public class AutoDiscoveryJmxSupportFactory
implements JmxSupportFactory {
    private static final JmxSupportFactory instance = new AutoDiscoveryJmxSupportFactory();
    private transient Log logger = LogFactory.getLog(this.getClass());
    private JmxSupport jmxSupport;

    protected AutoDiscoveryJmxSupportFactory() {
        boolean jmxModernAvailable = this.isModernSpecAvailable();
        this.jmxSupport = jmxModernAvailable ? new JmxModernSupport() : new JmxLegacySupport();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("JMX support instance is " + this.jmxSupport));
        }
    }

    public static JmxSupportFactory getInstance() {
        return instance;
    }

    public JmxSupport getJmxSupport() {
        return this.jmxSupport;
    }

    protected boolean isModernSpecAvailable() {
        Class clazz = ObjectName.class;
        Method method = ClassUtils.getMethod(clazz, "quote", new Class[]{String.class});
        return method != null;
    }

    private Object readResolve() throws ObjectStreamException {
        return instance;
    }
}

