/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import java.util.Map;
import org.mule.impl.ThreadSafeAccess;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.providers.NullPayload;
import org.mule.umo.provider.UMOMessageAdapter;

public class DefaultMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = 1908152148142575505L;
    protected Object message;

    public DefaultMessageAdapter(Object message) {
        this.message = message == null ? NullPayload.getInstance() : message;
    }

    public DefaultMessageAdapter(Object message, UMOMessageAdapter previous) {
        super(previous);
        if (previous != null) {
            this.message = message == null ? NullPayload.getInstance() : message;
        } else {
            throw new IllegalArgumentException("previousAdapter may not be null");
        }
    }

    public DefaultMessageAdapter(Object message, Map properties, Map attachments) {
        this(message);
        if (properties != null) {
            this.properties.putAll(properties);
        }
        if (attachments != null) {
            this.attachments.putAll(attachments);
        }
    }

    public String getPayloadAsString(String encoding) throws Exception {
        if (this.message instanceof byte[]) {
            if (encoding != null) {
                return new String((byte[])this.message, encoding);
            }
            return new String((byte[])this.message);
        }
        return this.message.toString();
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return this.convertToBytes(this.message);
    }

    public Object getPayload() {
        return this.message;
    }

    public String getUniqueId() {
        return this.id;
    }

    public ThreadSafeAccess newThreadCopy() {
        return new DefaultMessageAdapter(this.getPayload(), this);
    }
}

