/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Comparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.io.IOUtils;
import org.mule.MuleException;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractPollingMessageReceiver;
import org.mule.providers.ConnectException;
import org.mule.providers.file.FileConnector;
import org.mule.providers.file.i18n.FileMessages;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.routing.RoutingException;
import org.mule.util.FileUtils;

public class FileMessageReceiver
extends AbstractPollingMessageReceiver {
    public static final String COMPARATOR_CLASS_NAME_PROPERTY = "comparator";
    public static final String COMPARATOR_REVERSE_ORDER_PROPERTY = "reverseOrder";
    private String readDir = null;
    private String moveDir = null;
    private File readDirectory = null;
    private File moveDirectory = null;
    private String moveToPattern = null;
    private FilenameFilter filenameFilter = null;
    private FileFilter fileFilter = null;

    public FileMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, String readDir, String moveDir, String moveToPattern, long frequency) throws InitialisationException {
        super(connector, component, endpoint);
        this.setFrequency(frequency);
        this.readDir = readDir;
        this.moveDir = moveDir;
        this.moveToPattern = moveToPattern;
        if (endpoint.getFilter() instanceof FilenameFilter) {
            this.filenameFilter = (FilenameFilter)((Object)endpoint.getFilter());
        } else if (endpoint.getFilter() instanceof FileFilter) {
            this.fileFilter = (FileFilter)((Object)endpoint.getFilter());
        } else if (endpoint.getFilter() != null) {
            throw new InitialisationException(FileMessages.invalidFileFilter(endpoint.getEndpointURI()), (Object)this);
        }
    }

    protected void doConnect() throws Exception {
        if (this.readDir != null) {
            this.readDirectory = FileUtils.openDirectory(this.readDir);
            if (!this.readDirectory.canRead()) {
                throw new ConnectException(FileMessages.fileDoesNotExist(this.readDirectory.getAbsolutePath()), (Object)this);
            }
            this.logger.debug((Object)("Listening on endpointUri: " + this.readDirectory.getAbsolutePath()));
        }
        if (this.moveDir != null) {
            this.moveDirectory = FileUtils.openDirectory(this.moveDir);
            if (!this.moveDirectory.canRead() || !this.moveDirectory.canWrite()) {
                throw new ConnectException(FileMessages.moveToDirectoryNotWritable(), (Object)this);
            }
        }
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doDispose() {
    }

    public void poll() {
        try {
            Object[] files = this.listFiles();
            Comparator comparator = this.getComparator();
            if (comparator != null) {
                Arrays.sort(files, comparator);
            }
            for (int i = 0; i < files.length; ++i) {
                if (!((File)files[i]).isFile()) continue;
                this.processFile((File)files[i]);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public synchronized void processFile(File sourceFile) throws UMOException {
        UMOMessageAdapter msgAdapter;
        boolean checkFileAge = ((FileConnector)this.connector).getCheckFileAge();
        if (checkFileAge) {
            long fileAge = ((FileConnector)this.connector).getFileAge();
            long lastMod = sourceFile.lastModified();
            long now = System.currentTimeMillis();
            long thisFileAge = now - lastMod;
            if (thisFileAge < fileAge) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("The file has not aged enough yet, will return nothing for: " + sourceFile));
                }
                return;
            }
        }
        if (!this.attemptFileLock(sourceFile)) {
            return;
        }
        File destinationFile = null;
        String sourceFileOriginalName = sourceFile.getName();
        FileInputStream fileIn = null;
        if (this.endpoint.isStreaming()) {
            try {
                fileIn = new FileInputStream(sourceFile);
                msgAdapter = this.connector.getStreamMessageAdapter(fileIn, null);
            }
            catch (FileNotFoundException e) {
                this.logger.error((Object)"File being read disappeared!", (Throwable)e);
                return;
            }
        } else {
            msgAdapter = this.connector.getMessageAdapter(sourceFile);
        }
        msgAdapter.setProperty("originalFilename", sourceFileOriginalName);
        if (this.moveDir != null) {
            String destinationFileName = sourceFileOriginalName;
            if (this.moveToPattern != null) {
                destinationFileName = ((FileConnector)this.connector).getFilenameParser().getFilename(msgAdapter, this.moveToPattern);
            }
            destinationFile = FileUtils.newFile(this.moveDir, destinationFileName);
        }
        boolean fileWasMoved = false;
        try {
            if (!(sourceFile.canRead() && sourceFile.exists() && sourceFile.isFile())) {
                throw new MuleException(FileMessages.fileDoesNotExist(sourceFileOriginalName));
            }
            if (destinationFile != null) {
                if (fileIn != null) {
                    fileIn.close();
                }
                if (!(fileWasMoved = this.moveFile(sourceFile, destinationFile))) {
                    throw new MuleException(FileMessages.failedToMoveFile(sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath()));
                }
                msgAdapter = this.endpoint.isStreaming() ? this.connector.getStreamMessageAdapter(new FileInputStream(destinationFile), null) : this.connector.getMessageAdapter(destinationFile);
                msgAdapter.setProperty("filename", destinationFile.getName());
                msgAdapter.setProperty("originalFilename", sourceFileOriginalName);
            }
            this.routeMessage((UMOMessage)new MuleMessage(msgAdapter), this.endpoint.isSynchronous());
            if (((FileConnector)this.connector).isAutoDelete() && destinationFile == null && !sourceFile.delete()) {
                throw new MuleException(FileMessages.failedToDeleteFile(sourceFile.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            boolean fileWasRolledBack = false;
            if (fileWasMoved) {
                fileWasRolledBack = this.rollbackFileMove(destinationFile, sourceFile.getAbsolutePath());
            }
            RoutingException ex = new RoutingException(FileMessages.exceptionWhileProcessing(sourceFile.getName(), fileWasRolledBack ? "successful" : "unsuccessful"), new MuleMessage(msgAdapter), this.endpoint, e);
            this.handleException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean attemptFileLock(File sourceFile) {
        boolean fileCanBeLocked;
        block24: {
            IOException e2222;
            FileChannel channel;
            FileLock lock;
            block22: {
                lock = null;
                channel = null;
                fileCanBeLocked = false;
                channel = new RandomAccessFile(sourceFile, "rw").getChannel();
                lock = channel.tryLock();
                Object var7_5 = null;
                if (lock == null) break block22;
                fileCanBeLocked = true;
                try {
                    lock.release();
                }
                catch (IOException e2222) {
                    // empty catch block
                }
            }
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e2222) {}
            }
            break block24;
            {
                catch (FileNotFoundException fnfe) {
                    IOException e2222;
                    this.logger.warn((Object)("Unable to open " + sourceFile.getAbsolutePath()), (Throwable)fnfe);
                    Object var7_6 = null;
                    if (lock != null) {
                        fileCanBeLocked = true;
                        try {
                            lock.release();
                        }
                        catch (IOException e2222) {
                            // empty catch block
                        }
                    }
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (IOException e2222) {}
                    }
                    break block24;
                }
                catch (IOException e3) {
                    IOException e2222;
                    Object var7_7 = null;
                    if (lock != null) {
                        fileCanBeLocked = true;
                        try {
                            lock.release();
                        }
                        catch (IOException e2222) {
                            // empty catch block
                        }
                    }
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (IOException e2222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e2222;
                Object var7_8 = null;
                if (lock != null) {
                    fileCanBeLocked = true;
                    try {
                        lock.release();
                    }
                    catch (IOException e2222) {
                        // empty catch block
                    }
                }
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException e2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return fileCanBeLocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean moveFile(File sourceFile, File destinationFile) {
        boolean success = sourceFile.renameTo(destinationFile);
        if (!success) {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                fis = new FileInputStream(sourceFile);
                fos = new FileOutputStream(destinationFile);
                FileChannel srcChannel = fis.getChannel();
                FileChannel dstChannel = fos.getChannel();
                dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                srcChannel.close();
                dstChannel.close();
                success = sourceFile.delete();
            }
            catch (IOException ioex) {
                try {
                    success = false;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly(fis);
                IOUtils.closeQuietly(fos);
            }
            IOUtils.closeQuietly(fis);
            IOUtils.closeQuietly(fos);
        }
        return success;
    }

    protected boolean rollbackFileMove(File sourceFile, String destinationFilePath) {
        boolean result = false;
        try {
            result = this.moveFile(sourceFile, FileUtils.newFile(destinationFilePath));
        }
        catch (Throwable t) {
            this.logger.debug((Object)("rollback of file move failed: " + t.getMessage()));
        }
        return result;
    }

    File[] listFiles() throws MuleException {
        try {
            File[] todoFiles = this.fileFilter != null ? this.readDirectory.listFiles(this.fileFilter) : this.readDirectory.listFiles(this.filenameFilter);
            return todoFiles == null ? new File[]{} : todoFiles;
        }
        catch (Exception e) {
            throw new MuleException(FileMessages.errorWhileListingFiles(), (Throwable)e);
        }
    }

    protected Comparator getComparator() throws Exception {
        Object o = this.getEndpoint().getProperty(COMPARATOR_CLASS_NAME_PROPERTY);
        Object reverseProperty = this.getEndpoint().getProperty(COMPARATOR_REVERSE_ORDER_PROPERTY);
        boolean reverse = false;
        if (o != null) {
            if (reverseProperty != null) {
                reverse = Boolean.valueOf((String)reverseProperty);
            }
            Class<?> clazz = Class.forName(o.toString());
            o = clazz.newInstance();
            return reverse ? new ReverseComparator((Comparator)o) : (Comparator)o;
        }
        return null;
    }
}

