/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.util.ArrayList;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.commons.httpclient.cookie.NetscapeDraftSpec;
import org.apache.commons.httpclient.cookie.RFC2109Spec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CookieHelper {
    protected static final Log logger = LogFactory.getLog((Class)CookieHelper.class);

    private CookieHelper() {
    }

    public static CookieSpec getCookieSpec(String spec) {
        if (spec != null && spec.equalsIgnoreCase("netscape")) {
            return new NetscapeDraftSpec();
        }
        return new RFC2109Spec();
    }

    public static String getCookiePolicy(String spec) {
        if (spec != null && spec.equalsIgnoreCase("netscape")) {
            return "netscape";
        }
        return "rfc2109";
    }

    public static Cookie[] parseCookies(Header header, String spec) throws MalformedCookieException {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        CookieSpec cookieSpec = CookieHelper.getCookieSpec(spec);
        HeaderElement[] headerElements = header.getElements();
        for (int j = 0; j < headerElements.length; ++j) {
            HeaderElement headerElement = headerElements[j];
            NameValuePair[] headerElementParameters = headerElement.getParameters();
            Cookie cookie = new Cookie();
            for (int k = 0; k < headerElementParameters.length; ++k) {
                NameValuePair nameValuePair = headerElementParameters[k];
                cookieSpec.parseAttribute(nameValuePair, cookie);
            }
            if (cookie.isExpired()) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Cookie: " + cookie.toString() + " has expired, not adding it."));
                continue;
            }
            cookies.add(cookie);
        }
        return cookies.toArray(new Cookie[cookies.size()]);
    }
}

