/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.resource.spi.work.Work;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.impl.NullSessionHandler;
import org.mule.impl.OptimizedRequestContext;
import org.mule.impl.RequestContext;
import org.mule.providers.ConnectException;
import org.mule.providers.NullPayload;
import org.mule.providers.http.CookieHelper;
import org.mule.providers.http.HttpConnector;
import org.mule.providers.http.HttpRequest;
import org.mule.providers.http.HttpResponse;
import org.mule.providers.http.HttpServerConnection;
import org.mule.providers.http.RequestLine;
import org.mule.providers.http.i18n.HttpMessages;
import org.mule.providers.tcp.TcpMessageReceiver;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.umo.provider.UMOStreamMessageAdapter;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.MapUtils;
import org.mule.util.ObjectUtils;

public class HttpMessageReceiver
extends TcpMessageReceiver {
    public HttpMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
    }

    protected Work createWork(Socket socket) throws IOException {
        return new HttpWorker(socket);
    }

    protected void doConnect() throws ConnectException {
        if (this.shouldConnect()) {
            super.doConnect();
        }
    }

    protected boolean shouldConnect() {
        StringBuffer requestUri = new StringBuffer(80);
        requestUri.append(this.endpoint.getProtocol()).append("://");
        requestUri.append(this.endpoint.getEndpointURI().getHost());
        requestUri.append(':').append(this.endpoint.getEndpointURI().getPort());
        requestUri.append('*');
        UMOMessageReceiver[] receivers = this.connector.getReceivers(requestUri.toString());
        for (int i = 0; i < receivers.length; ++i) {
            if (!receivers[i].isConnected()) continue;
            return false;
        }
        return true;
    }

    protected UMOMessage handleUnacceptedFilter(UMOMessage message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message request '" + message.getProperty("http.request") + "' is being rejected since it does not match the filter on this endpoint: " + this.endpoint));
        }
        message.setProperty("http.status", String.valueOf(406));
        return message;
    }

    protected String getRequestPath(UMOMessage message) {
        String path = (String)message.getProperty("http.request");
        int i = path.indexOf(63);
        if (i > -1) {
            path = path.substring(0, i);
        }
        return path;
    }

    protected UMOMessageReceiver getTargetReceiver(UMOMessage message, UMOEndpoint endpoint) throws ConnectException {
        UMOMessageReceiver receiver;
        String path = (String)message.getProperty("http.request");
        int i = path.indexOf(63);
        if (i > -1) {
            path = path.substring(0, i);
        }
        StringBuffer requestUri = new StringBuffer(80);
        if (path.indexOf("://") == -1) {
            requestUri.append(endpoint.getProtocol()).append("://");
            requestUri.append(endpoint.getEndpointURI().getHost());
            requestUri.append(':').append(endpoint.getEndpointURI().getPort());
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Looking up receiver on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
        }
        if ((receiver = this.connector.lookupReceiver(requestUri.toString())) == null && !"/".equals(path)) {
            String uriStr;
            int x = path.lastIndexOf(47);
            if (x > 1 && path.indexOf(46) > x) {
                requestUri.append(path.substring(0, x));
            } else {
                requestUri.append(path);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Secondary lookup of receiver on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
            }
            if ((receiver = this.connector.lookupReceiver(uriStr = requestUri.toString())) == null) {
                receiver = HttpMessageReceiver.findReceiverByStem(this.connector.getReceivers(), uriStr);
            }
            if (receiver == null && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("No receiver found with secondary lookup on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
                this.logger.warn((Object)("Receivers on connector are: " + MapUtils.toString(this.connector.getReceivers(), true)));
            }
        }
        return receiver;
    }

    public static UMOMessageReceiver findReceiverByStem(Map receivers, String uriStr) {
        int match = 0;
        UMOMessageReceiver receiver = null;
        Iterator itr = receivers.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            String key = (String)e.getKey();
            UMOMessageReceiver candidate = (UMOMessageReceiver)e.getValue();
            if (!uriStr.startsWith(key) || match >= key.length()) continue;
            match = key.length();
            receiver = candidate;
        }
        return receiver;
    }

    protected class HttpWorker
    implements Work {
        private HttpServerConnection conn;
        private String cookieSpec;
        private boolean enableCookies;
        private String remoteClientAddress;

        public HttpWorker(Socket socket) throws IOException {
            this.conn = HttpMessageReceiver.this.endpoint.getEncoding() != null ? new HttpServerConnection(socket, HttpMessageReceiver.this.endpoint.getEncoding()) : new HttpServerConnection(socket);
            this.cookieSpec = MapUtils.getString((Map)HttpMessageReceiver.this.endpoint.getProperties(), (Object)"cookieSpec", (String)((HttpConnector)HttpMessageReceiver.this.connector).getCookieSpec());
            this.enableCookies = MapUtils.getBooleanValue((Map)HttpMessageReceiver.this.endpoint.getProperties(), (Object)"enableCookies", (boolean)((HttpConnector)HttpMessageReceiver.this.connector).isEnableCookies());
            SocketAddress clientAddress = socket.getRemoteSocketAddress();
            if (clientAddress != null) {
                this.remoteClientAddress = clientAddress.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                do {
                    this.conn.setKeepAlive(false);
                    HttpRequest request = this.conn.readRequest();
                    if (request == null) {
                        break;
                    }
                    this.conn.writeResponse(this.processRequest(request));
                } while (this.conn.isKeepAlive());
            }
            catch (Exception e) {
                HttpMessageReceiver.this.handleException(e);
            }
            finally {
                this.conn.close();
                this.conn = null;
            }
        }

        protected HttpResponse processRequest(HttpRequest request) throws UMOException, IOException {
            RequestLine requestLine = request.getRequestLine();
            String method = requestLine.getMethod();
            if (method.equals("HEAD")) {
                return this.doHead(requestLine);
            }
            if (method.equals("GET") || method.equals("POST") || method.equals("OPTIONS") || method.equals("PUT") || method.equals("DELETE") || method.equals("TRACE") || method.equals("CONNECT")) {
                return this.doRequest(request, requestLine);
            }
            return this.doBad(requestLine);
        }

        protected HttpResponse doHead(RequestLine requestLine) throws UMOException {
            MuleMessage message = new MuleMessage(NullPayload.getInstance());
            MuleEvent event = new MuleEvent((UMOMessage)message, (UMOImmutableEndpoint)HttpMessageReceiver.this.endpoint, new MuleSession(message, new NullSessionHandler()), true);
            OptimizedRequestContext.unsafeSetEvent(event);
            HttpResponse response = new HttpResponse();
            response.setStatusLine(requestLine.getHttpVersion(), 200);
            response = (HttpResponse)HttpMessageReceiver.this.connector.getDefaultResponseTransformer().transform(response);
            return response;
        }

        protected HttpResponse doRequest(HttpRequest request, RequestLine requestLine) throws IOException, UMOException {
            HttpResponse response;
            UMOMessageReceiver receiver;
            Map headers = this.parseHeaders(request);
            UMOMessageAdapter adapter = HttpMessageReceiver.this.endpoint.isStreaming() && request.getBody() != null ? this.buildStreamingAdapter(request, headers) : this.buildStandardAdapter(request, headers);
            MuleMessage message = new MuleMessage(adapter);
            if (HttpMessageReceiver.this.logger.isDebugEnabled()) {
                HttpMessageReceiver.this.logger.debug(message.getProperty("http.request"));
            }
            if ((receiver = HttpMessageReceiver.this.getTargetReceiver(message, HttpMessageReceiver.this.endpoint)) != null) {
                this.preRouteMessage(message);
                UMOMessage returnMessage = receiver.routeMessage((UMOMessage)message, HttpMessageReceiver.this.endpoint.isSynchronous(), null);
                Object tempResponse = returnMessage != null ? returnMessage.getPayload() : NullPayload.getInstance();
                response = tempResponse instanceof HttpResponse ? (HttpResponse)tempResponse : (HttpResponse)HttpMessageReceiver.this.connector.getDefaultResponseTransformer().transform(tempResponse);
                response.disableKeepAlive(!((HttpConnector)HttpMessageReceiver.this.connector).isKeepAlive());
            } else {
                response = this.buildFailureResponse(requestLine, message);
            }
            return response;
        }

        protected HttpResponse doOtherValid(RequestLine requestLine, String method) throws UMOException {
            MuleMessage message = new MuleMessage(NullPayload.getInstance());
            MuleEvent event = new MuleEvent((UMOMessage)message, (UMOImmutableEndpoint)HttpMessageReceiver.this.endpoint, new MuleSession(message, new NullSessionHandler()), true);
            OptimizedRequestContext.unsafeSetEvent(event);
            HttpResponse response = new HttpResponse();
            response.setStatusLine(requestLine.getHttpVersion(), 405);
            response.setBodyString(HttpMessages.methodNotAllowed(method).toString() + "\r\n");
            response = (HttpResponse)HttpMessageReceiver.this.connector.getDefaultResponseTransformer().transform(response);
            return response;
        }

        protected HttpResponse doBad(RequestLine requestLine) throws UMOException {
            MuleMessage message = new MuleMessage(NullPayload.getInstance());
            MuleEvent event = new MuleEvent((UMOMessage)message, (UMOImmutableEndpoint)HttpMessageReceiver.this.endpoint, new MuleSession(message, new NullSessionHandler()), true);
            OptimizedRequestContext.unsafeSetEvent(event);
            HttpResponse response = new HttpResponse();
            response.setStatusLine(requestLine.getHttpVersion(), 400);
            response.setBodyString(HttpMessages.malformedSyntax().toString() + "\r\n");
            response = (HttpResponse)HttpMessageReceiver.this.connector.getDefaultResponseTransformer().transform(response);
            return response;
        }

        protected UMOMessageAdapter buildStreamingAdapter(HttpRequest request, Map headers) throws MessagingException {
            UMOStreamMessageAdapter adapter = HttpMessageReceiver.this.connector.getStreamMessageAdapter(request.getBody(), this.conn.getOutputStream());
            Iterator iterator = headers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                adapter.setProperty((String)entry.getKey(), entry.getValue());
            }
            return adapter;
        }

        protected UMOMessageAdapter buildStandardAdapter(HttpRequest request, Map headers) throws MessagingException, TransformerException, IOException {
            Object body;
            String expectHeaderValue;
            RequestLine requestLine = request.getRequestLine();
            if ("HTTP/1.1".equals(headers.get("http.version")) && "100-continue".equals(expectHeaderValue = ObjectUtils.toString(headers.get("Expect")).toLowerCase())) {
                HttpResponse expected = new HttpResponse();
                expected.setStatusLine(requestLine.getHttpVersion(), 100);
                MuleEvent event = new MuleEvent((UMOMessage)new MuleMessage(expected), (UMOImmutableEndpoint)HttpMessageReceiver.this.endpoint, new MuleSession(HttpMessageReceiver.this.component), true);
                RequestContext.setEvent(event);
                expected = (HttpResponse)HttpMessageReceiver.this.connector.getDefaultResponseTransformer().transform(expected);
                this.conn.writeResponse(expected);
            }
            if ((body = request.getBodyBytes()) == null) {
                body = requestLine.getUri();
            }
            return HttpMessageReceiver.this.connector.getMessageAdapter(new Object[]{body, headers});
        }

        protected HttpResponse buildFailureResponse(RequestLine requestLine, UMOMessage message) throws TransformerException {
            UMOEndpointURI uri = HttpMessageReceiver.this.endpoint.getEndpointURI();
            String failedPath = uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort() + HttpMessageReceiver.this.getRequestPath(message);
            if (HttpMessageReceiver.this.logger.isDebugEnabled()) {
                HttpMessageReceiver.this.logger.debug((Object)("Failed to bind to " + failedPath));
            }
            HttpResponse response = new HttpResponse();
            response.setStatusLine(requestLine.getHttpVersion(), 404);
            response.setBodyString(HttpMessages.cannotBindToAddress(failedPath).toString());
            RequestContext.setEvent(new MuleEvent((UMOMessage)new MuleMessage(response), (UMOImmutableEndpoint)HttpMessageReceiver.this.endpoint, new MuleSession(HttpMessageReceiver.this.component), true));
            return (HttpResponse)HttpMessageReceiver.this.connector.getDefaultResponseTransformer().transform(response);
        }

        protected Map parseHeaders(HttpRequest request) throws MalformedCookieException {
            RequestLine requestLine = request.getRequestLine();
            HashMap<String, Object> headers = new HashMap<String, Object>();
            Iterator rhi = request.getHeaderIterator();
            while (rhi.hasNext()) {
                Header header = (Header)rhi.next();
                String headerName = header.getName();
                Cookie[] headerValue = header.getValue();
                if (headerName.startsWith("X-MULE")) {
                    headerName = headerName.substring(2);
                } else if (headerName.equals("cookies")) {
                    Cookie[] cookies;
                    if (!this.enableCookies || (cookies = CookieHelper.parseCookies(header, this.cookieSpec)).length <= 0) continue;
                    headerValue = cookies;
                }
                headers.put(headerName, headerValue);
            }
            headers.put("http.method", requestLine.getMethod());
            headers.put("http.request", requestLine.getUri());
            headers.put("http.version", requestLine.getHttpVersion().toString());
            headers.put("cookieSpec", this.cookieSpec);
            return headers;
        }

        protected void preRouteMessage(UMOMessage message) {
            message.setProperty("MULE_REMOTE_CLIENT_ADDRESS", this.remoteClientAddress);
        }

        public void release() {
            this.conn.close();
            this.conn = null;
        }
    }
}

