/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.provider.UMOSessionHandler;

public class HttpSessionHandler
implements UMOSessionHandler {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public void retrieveSessionInfoFromMessage(UMOMessage message, UMOSession session) throws UMOException {
        Cookie[] cookies = (Cookie[])message.getProperty("cookies");
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                session.setProperty(cookie.getName(), cookie.getValue());
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added cookie to session: " + cookie.toString()));
            }
        }
    }

    public void storeSessionInfoToMessage(UMOSession session, UMOMessage message) throws UMOException {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        Iterator iterator = session.getPropertyNames();
        while (iterator.hasNext()) {
            Object name = iterator.next();
            Object value = session.getProperty(name);
            cookies.add(new Cookie(null, name.toString(), value.toString()));
        }
        if (cookies.size() > 0) {
            message.setProperty("cookies", cookies.toArray(new Cookie[cookies.size()]));
        }
    }

    public String getSessionIDKey() {
        return "ID";
    }
}

