/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import java.util.Collections;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsMessageAdapter;
import org.mule.providers.jms.MessageRedeliveredException;
import org.mule.providers.jms.RedeliveryHandler;
import org.mule.providers.jms.i18n.JmsMessages;
import org.mule.umo.MessagingException;

public class DefaultRedeliveryHandler
implements RedeliveryHandler {
    protected static final Log logger = LogFactory.getLog((Class)DefaultRedeliveryHandler.class);
    private Map messages = Collections.synchronizedMap(new LRUMap(256));
    protected JmsConnector connector;

    public void setConnector(JmsConnector connector) {
        this.connector = connector;
    }

    public void handleRedelivery(Message message) throws JMSException, MessagingException {
        if (this.connector.getMaxRedelivery() <= 0) {
            return;
        }
        String id = message.getJMSMessageID();
        Integer i = (Integer)this.messages.remove(id);
        if (i == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + id + " has been redelivered for the first time"));
            }
            this.messages.put(id, new Integer(1));
            return;
        }
        if (i.intValue() == this.connector.getMaxRedelivery()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + id + " has been redelivered " + (i + 1) + " times, which exceeds the maxRedelivery setting on the connector"));
            }
            JmsMessageAdapter adapter = (JmsMessageAdapter)this.connector.getMessageAdapter(message);
            throw new MessageRedeliveredException(JmsMessages.tooManyRedeliveries(id, String.valueOf(i + 1)), adapter);
        }
        this.messages.put(id, new Integer(i + 1));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Message with id: " + id + " has been redelivered " + i + " times"));
        }
    }
}

