/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.weblogic;

import java.lang.reflect.Method;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import org.mule.providers.jms.DefaultJmsTopicResolver;
import org.mule.providers.jms.Jms102bSupport;
import org.mule.providers.jms.JmsConnector;
import org.mule.util.ClassUtils;

public class WeblogicJmsTopicResolver
extends DefaultJmsTopicResolver {
    protected static final Class[] PARAMETER_TYPES_NONE = new Class[0];

    public WeblogicJmsTopicResolver(JmsConnector connector) {
        super(connector);
    }

    public boolean isTopic(Destination destination) {
        boolean topic = destination instanceof Topic;
        if (topic && destination instanceof Queue && this.getConnector().getJmsSupport() instanceof Jms102bSupport) {
            try {
                Method topicMethod = ClassUtils.getPublicMethod(destination.getClass(), "isTopic", PARAMETER_TYPES_NONE);
                topic = (Boolean)topicMethod.invoke((Object)destination, ClassUtils.NO_ARGS);
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage());
            }
        }
        return topic;
    }
}

