/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.ssl;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.security.Provider;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManagerFactory;
import org.mule.providers.ssl.SslServerSocketFactory;
import org.mule.providers.ssl.SslSocketFactory;
import org.mule.providers.tcp.TcpConnector;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.security.TlsDirectKeyStore;
import org.mule.umo.security.TlsDirectTrustStore;
import org.mule.umo.security.TlsIndirectKeyStore;
import org.mule.umo.security.provider.SecurityProviderFactory;
import org.mule.umo.security.tls.TlsConfiguration;

public class SslConnector
extends TcpConnector
implements TlsDirectKeyStore,
TlsIndirectKeyStore,
TlsDirectTrustStore {
    public static final String PEER_CERTIFICATES = "PEER_CERTIFICATES";
    public static final String LOCAL_CERTIFICATES = "LOCAL_CERTIFICATES";
    private TlsConfiguration tls = new TlsConfiguration(null);

    public SslConnector() {
        this.setSocketFactory(new SslSocketFactory(this.tls));
        this.setServerSocketFactory(new SslServerSocketFactory(this.tls));
        this.setValidateConnections(false);
    }

    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        this.tls.initialise(null == this.getKeyStore(), "javax.net");
    }

    protected ServerSocket getServerSocket(URI uri) throws IOException {
        SSLServerSocket serverSocket = (SSLServerSocket)super.getServerSocket(uri);
        serverSocket.setNeedClientAuth(this.isRequireClientAuthentication());
        return serverSocket;
    }

    public String getProtocol() {
        return "SSL";
    }

    public String getClientKeyStore() {
        return this.tls.getClientKeyStore();
    }

    public String getClientKeyStorePassword() {
        return this.tls.getClientKeyStorePassword();
    }

    public String getClientKeyStoreType() {
        return this.tls.getClientKeyStoreType();
    }

    public String getKeyManagerAlgorithm() {
        return this.tls.getKeyManagerAlgorithm();
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.tls.getKeyManagerFactory();
    }

    public String getKeyPassword() {
        return this.tls.getKeyPassword();
    }

    public String getKeyStore() {
        return this.tls.getKeyStore();
    }

    public String getKeystoreType() {
        return this.tls.getKeystoreType();
    }

    public String getProtocolHandler() {
        return this.tls.getProtocolHandler();
    }

    public Provider getProvider() {
        return this.tls.getProvider();
    }

    public SecurityProviderFactory getSecurityProviderFactory() {
        return this.tls.getSecurityProviderFactory();
    }

    public String getSslType() {
        return this.tls.getSslType();
    }

    public String getStorePassword() {
        return this.tls.getStorePassword();
    }

    public String getTrustManagerAlgorithm() {
        return this.tls.getTrustManagerAlgorithm();
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.tls.getTrustManagerFactory();
    }

    public String getTrustStore() {
        return this.tls.getTrustStore();
    }

    public String getTrustStorePassword() {
        return this.tls.getTrustStorePassword();
    }

    public String getTrustStoreType() {
        return this.tls.getTrustStoreType();
    }

    public boolean isExplicitTrustStoreOnly() {
        return this.tls.isExplicitTrustStoreOnly();
    }

    public boolean isRequireClientAuthentication() {
        return this.tls.isRequireClientAuthentication();
    }

    public void setClientKeyStore(String clientKeyStore) throws IOException {
        this.tls.setClientKeyStore(clientKeyStore);
    }

    public void setClientKeyStorePassword(String clientKeyStorePassword) {
        this.tls.setClientKeyStorePassword(clientKeyStorePassword);
    }

    public void setClientKeyStoreType(String clientKeyStoreType) {
        this.tls.setClientKeyStoreType(clientKeyStoreType);
    }

    public void setExplicitTrustStoreOnly(boolean explicitTrustStoreOnly) {
        this.tls.setExplicitTrustStoreOnly(explicitTrustStoreOnly);
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        this.tls.setKeyManagerAlgorithm(keyManagerAlgorithm);
    }

    public void setKeyPassword(String keyPassword) {
        this.tls.setKeyPassword(keyPassword);
    }

    public void setKeyStore(String keyStore) throws IOException {
        this.tls.setKeyStore(keyStore);
    }

    public void setKeystoreType(String keystoreType) {
        this.tls.setKeystoreType(keystoreType);
    }

    public void setProtocolHandler(String protocolHandler) {
        this.tls.setProtocolHandler(protocolHandler);
    }

    public void setProvider(Provider provider) {
        this.tls.setProvider(provider);
    }

    public void setRequireClientAuthentication(boolean requireClientAuthentication) {
        this.tls.setRequireClientAuthentication(requireClientAuthentication);
    }

    public void setSecurityProviderFactory(SecurityProviderFactory spFactory) {
        this.tls.setSecurityProviderFactory(spFactory);
    }

    public void setSslType(String sslType) {
        this.tls.setSslType(sslType);
    }

    public void setStorePassword(String storePassword) {
        this.tls.setStorePassword(storePassword);
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this.tls.setTrustManagerAlgorithm(trustManagerAlgorithm);
    }

    public void setTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
        this.tls.setTrustManagerFactory(trustManagerFactory);
    }

    public void setTrustStore(String trustStore) throws IOException {
        this.tls.setTrustStore(trustStore);
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.tls.setTrustStorePassword(trustStorePassword);
    }

    public void setTrustStoreType(String trustStoreType) {
        this.tls.setTrustStoreType(trustStoreType);
    }
}

