/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.stream;

import java.io.OutputStream;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.stream.StreamConnector;
import org.mule.providers.stream.SystemStreamConnector;
import org.mule.providers.stream.i18n.StreamMessages;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.util.StringUtils;

public class StreamMessageDispatcher
extends AbstractMessageDispatcher {
    private final StreamConnector connector;

    public StreamMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (StreamConnector)endpoint.getConnector();
        if (this.connector instanceof SystemStreamConnector) {
            SystemStreamConnector ssc = (SystemStreamConnector)this.connector;
            String outputMessage = (String)endpoint.getProperties().get("outputMessage");
            if (outputMessage != null) {
                ssc.setOutputMessage(outputMessage);
            }
        }
    }

    protected synchronized void doDispatch(UMOEvent event) throws Exception {
        Object data;
        SystemStreamConnector ssc;
        OutputStream out = this.connector.getOutputStream();
        if (out == null) {
            throw new DispatchException(StreamMessages.couldNotFindStreamWithName(event.getEndpoint().getEndpointURI().getAddress()), event.getMessage(), event.getEndpoint());
        }
        if (this.connector instanceof SystemStreamConnector && StringUtils.isNotBlank((ssc = (SystemStreamConnector)this.connector).getOutputMessage())) {
            out.write(ssc.getOutputMessage().getBytes());
        }
        if ((data = event.getTransformedMessage()) instanceof byte[]) {
            out.write((byte[])data);
        } else {
            out.write(data.toString().getBytes());
        }
        out.flush();
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        this.doDispatch(event);
        return event.getMessage();
    }

    protected UMOMessage doReceive(long timeout) throws Exception {
        throw new UnsupportedOperationException("doReceive");
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

