/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.tcp;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.model.streaming.CallbackOutputStream;
import org.mule.providers.AbstractConnector;
import org.mule.providers.tcp.PooledSocketFactory;
import org.mule.providers.tcp.SimpleServerSocketFactory;
import org.mule.providers.tcp.TcpProtocol;
import org.mule.providers.tcp.TcpServerSocketFactory;
import org.mule.providers.tcp.TcpSocketFactory;
import org.mule.providers.tcp.i18n.TcpMessages;
import org.mule.providers.tcp.protocols.DefaultProtocol;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.util.ClassUtils;

public class TcpConnector
extends AbstractConnector {
    public static final String KEEP_SEND_SOCKET_OPEN_PROPERTY = "keepSendSocketOpen";
    public static final int DEFAULT_SOCKET_TIMEOUT = -1;
    public static final int DEFAULT_BUFFER_SIZE = -1;
    public static final int DEFAULT_BACKLOG = -1;
    private int sendTimeout = -1;
    private int receiveTimeout = -1;
    private int sendBufferSize = -1;
    private int receiveBufferSize = -1;
    private int receiveBacklog = -1;
    private boolean sendTcpNoDelay;
    private boolean validateConnections = true;
    private Boolean reuseAddress = null;
    private int socketLinger = -1;
    private String tcpProtocolClassName;
    private TcpProtocol tcpProtocol;
    private boolean keepSendSocketOpen = false;
    private boolean keepAlive = false;
    private PooledSocketFactory socketFactory;
    private SimpleServerSocketFactory serverSocketFactory;
    private GenericKeyedObjectPool dispatcherSocketsPool = new GenericKeyedObjectPool();

    public TcpConnector() {
        this.setSocketFactory(new TcpSocketFactory());
        this.setServerSocketFactory(new TcpServerSocketFactory());
        this.setTcpProtocolClassName(DefaultProtocol.class.getName());
    }

    protected void doInitialise() throws InitialisationException {
        if (this.tcpProtocol == null) {
            try {
                this.tcpProtocol = (TcpProtocol)ClassUtils.instanciateClass(this.tcpProtocolClassName, null);
            }
            catch (Exception e) {
                throw new InitialisationException(TcpMessages.failedToInitMessageReader(), (Object)e);
            }
        }
        this.dispatcherSocketsPool.setFactory(this.getSocketFactory());
        this.dispatcherSocketsPool.setTestOnBorrow(true);
        this.dispatcherSocketsPool.setTestOnReturn(true);
        this.dispatcherSocketsPool.setMaxActive(1);
    }

    protected void doDispose() {
        this.logger.debug((Object)"Closing TCP connector");
        try {
            this.dispatcherSocketsPool.close();
        }
        catch (Exception e) {
            this.logger.warn((Object)("Failed to close dispatcher socket pool: " + e.getMessage()));
        }
    }

    protected Socket getSocket(UMOImmutableEndpoint endpoint) throws Exception {
        Socket socket = (Socket)this.dispatcherSocketsPool.borrowObject(endpoint);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("borrowing socket; debt " + this.dispatcherSocketsPool.getNumActive()));
        }
        return socket;
    }

    void releaseSocket(Socket socket, UMOImmutableEndpoint endpoint) throws Exception {
        this.dispatcherSocketsPool.returnObject(endpoint, socket);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("returned socket; debt " + this.dispatcherSocketsPool.getNumActive()));
        }
    }

    public OutputStream getOutputStream(final UMOImmutableEndpoint endpoint, UMOMessage message) throws UMOException {
        Socket socket;
        try {
            socket = this.getSocket(endpoint);
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToGetOutputStream(), message, (Throwable)e);
        }
        if (socket == null) {
            throw new IllegalStateException("could not get socket for endpoint: " + endpoint.getEndpointURI().getAddress());
        }
        try {
            return new CallbackOutputStream(new DataOutputStream(new BufferedOutputStream(socket.getOutputStream())), new CallbackOutputStream.Callback(){

                public void onClose() throws Exception {
                    TcpConnector.this.releaseSocket(socket, endpoint);
                }
            });
        }
        catch (IOException e) {
            throw new MessagingException(CoreMessages.failedToGetOutputStream(), message, (Throwable)e);
        }
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
        this.dispatcherSocketsPool.clear();
    }

    protected void doStart() throws UMOException {
    }

    protected void doStop() throws UMOException {
    }

    public String getProtocol() {
        return "tcp";
    }

    public boolean isKeepSendSocketOpen() {
        return this.keepSendSocketOpen;
    }

    public void setKeepSendSocketOpen(boolean keepSendSocketOpen) {
        this.keepSendSocketOpen = keepSendSocketOpen;
    }

    public void setTimeout(int timeout) {
        this.setSendTimeout(timeout);
        this.setReceiveTimeout(timeout);
    }

    public int getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(int timeout) {
        this.sendTimeout = TcpConnector.valueOrDefault(timeout, 0, -1);
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(int timeout) {
        this.receiveTimeout = TcpConnector.valueOrDefault(timeout, 0, -1);
    }

    public int getBufferSize() {
        return this.sendBufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.sendBufferSize = TcpConnector.valueOrDefault(bufferSize, 1, -1);
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int bufferSize) {
        this.sendBufferSize = TcpConnector.valueOrDefault(bufferSize, 1, -1);
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int bufferSize) {
        this.receiveBufferSize = TcpConnector.valueOrDefault(bufferSize, 1, -1);
    }

    public int getReceiveBacklog() {
        return this.receiveBacklog;
    }

    public void setReceiveBacklog(int receiveBacklog) {
        this.receiveBacklog = TcpConnector.valueOrDefault(receiveBacklog, 0, -1);
    }

    public int getSendSocketLinger() {
        return this.socketLinger;
    }

    public void setSendSocketLinger(int soLinger) {
        this.socketLinger = TcpConnector.valueOrDefault(soLinger, 0, -1);
    }

    public int getBacklog() {
        return this.receiveBacklog;
    }

    public void setBacklog(int backlog) {
        this.receiveBacklog = backlog;
    }

    public TcpProtocol getTcpProtocol() {
        return this.tcpProtocol;
    }

    public void setTcpProtocol(TcpProtocol tcpProtocol) {
        this.tcpProtocol = tcpProtocol;
    }

    public String getTcpProtocolClassName() {
        return this.tcpProtocolClassName;
    }

    public void setTcpProtocolClassName(String protocolClassName) {
        this.tcpProtocolClassName = protocolClassName;
    }

    public boolean isRemoteSyncEnabled() {
        return true;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isSendTcpNoDelay() {
        return this.sendTcpNoDelay;
    }

    public void setSendTcpNoDelay(boolean sendTcpNoDelay) {
        this.sendTcpNoDelay = sendTcpNoDelay;
    }

    protected void setSocketFactory(PooledSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    protected PooledSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public SimpleServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    public void setServerSocketFactory(SimpleServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
    }

    protected ServerSocket getServerSocket(URI uri) throws IOException {
        return this.getServerSocketFactory().createServerSocket(uri, this.getReceiveBacklog(), this.isReuseAddress());
    }

    private static int valueOrDefault(int value, int threshhold, int deflt) {
        if (value < threshhold) {
            return deflt;
        }
        return value;
    }

    public boolean isValidateConnections() {
        return this.validateConnections;
    }

    public void setValidateConnections(boolean validateConnections) {
        this.validateConnections = validateConnections;
    }

    public Boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(Boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }
}

