/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.nested;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.management.stats.RouterStatistics;
import org.mule.routing.AbstractRouter;
import org.mule.routing.nested.NestedInvocationHandler;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.routing.UMONestedRouter;
import org.mule.umo.routing.UMOOutboundRouter;

public class NestedRouter
extends AbstractRouter
implements UMONestedRouter {
    protected static Log logger = LogFactory.getLog((Class)NestedRouter.class);
    private Class interfaceClass;
    private String methodName;
    private UMOEndpoint endpoint;
    protected UMOOutboundRouter outboundRouter;

    public NestedRouter() {
        this.setRouterStatistics(new RouterStatistics(4));
    }

    public UMOMessage route(UMOEvent event) throws MessagingException {
        UMOImmutableEndpoint endpoint = event.getEndpoint();
        return this.outboundRouter.route(event.getMessage(), event.getSession(), endpoint.isSynchronous());
    }

    public void setInterface(Class interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public Class getInterface() {
        return this.interfaceClass;
    }

    public String getMethod() {
        return this.methodName;
    }

    public void setMethod(String methodName) {
        this.methodName = methodName;
    }

    public Object createProxy(Object target) {
        try {
            Object proxy = Proxy.newProxyInstance(this.getInterface().getClassLoader(), new Class[]{this.getInterface()}, (InvocationHandler)new NestedInvocationHandler(this));
            return proxy;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public UMOEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(UMOEndpoint e) {
        this.endpoint = e;
        this.outboundRouter = new OutboundPassThroughRouter();
        this.outboundRouter.addEndpoint(this.endpoint);
        this.outboundRouter.setTransactionConfig(this.endpoint.getTransactionConfig());
    }

    public Class getInterfaceClass() {
        return this.interfaceClass;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("NestedRouter");
        sb.append("{method='").append(this.methodName).append('\'');
        sb.append(", interface=").append(this.interfaceClass);
        sb.append('}');
        return sb.toString();
    }
}

