/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.List;
import java.util.Map;
import org.mule.MuleManager;
import org.mule.impl.AbstractExceptionListener;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.container.DescriptorContainerKeyPair;
import org.mule.interceptors.LoggingInterceptor;
import org.mule.interceptors.TimerInterceptor;
import org.mule.providers.SimpleRetryConnectionStrategy;
import org.mule.routing.ForwardingCatchAllStrategy;
import org.mule.routing.filters.xml.JXPathFilter;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.testmodels.fruit.FruitCleaner;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.mule.TestCompressionTransformer;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.tck.testmodels.mule.TestDefaultLifecycleAdapterFactory;
import org.mule.tck.testmodels.mule.TestEntryPointResolver;
import org.mule.tck.testmodels.mule.TestExceptionStrategy;
import org.mule.tck.testmodels.mule.TestResponseAggregator;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.UMOInterceptorStack;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.model.UMOModel;
import org.mule.umo.routing.UMOInboundRouterCollection;
import org.mule.umo.routing.UMONestedRouter;
import org.mule.umo.routing.UMONestedRouterCollection;
import org.mule.umo.routing.UMOOutboundRouter;
import org.mule.umo.routing.UMOOutboundRouterCollection;
import org.mule.umo.routing.UMOResponseRouter;
import org.mule.umo.routing.UMOResponseRouterCollection;
import org.mule.umo.transformer.UMOTransformer;

public abstract class AbstractScriptConfigBuilderTestCase
extends FunctionalTestCase {
    protected AbstractScriptConfigBuilderTestCase() {
        this.setDisposeManagerPerSuite(true);
    }

    public void testManagerConfig() throws Exception {
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"true", (Object)MuleManager.getInstance().getProperty("doCompression"));
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)MuleManager.getInstance().getTransactionManager());
    }

    public void testConnectorConfig() throws Exception {
        TestConnector c = (TestConnector)MuleManager.getInstance().lookupConnector("dummyConnector");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)c);
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)c.getExceptionListener());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(c.getExceptionListener() instanceof TestExceptionStrategy));
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)c.getConnectionStrategy());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(c.getConnectionStrategy() instanceof SimpleRetryConnectionStrategy));
        AbstractScriptConfigBuilderTestCase.assertEquals((int)4, (int)((SimpleRetryConnectionStrategy)c.getConnectionStrategy()).getRetryCount());
        AbstractScriptConfigBuilderTestCase.assertEquals((long)3000L, (long)((SimpleRetryConnectionStrategy)c.getConnectionStrategy()).getFrequency());
    }

    public void testGlobalEndpointConfig() {
        UMOEndpoint endpoint = MuleManager.getInstance().lookupEndpoint("fruitBowlEndpoint");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)endpoint.getEndpointURI().getAddress(), (String)"fruitBowlPublishQ");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint.getFilter());
        JXPathFilter filter = (JXPathFilter)endpoint.getFilter();
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"name", (String)filter.getExpression());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"bar", (String)filter.getExpectedValue());
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"http://foo.com", filter.getNamespaces().get("foo"));
    }

    public void testEndpointConfig() {
        String endpointString = MuleManager.getInstance().lookupEndpointIdentifier("Test Queue", null);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)endpointString, (String)"test://test.queue");
        UMOEndpoint endpoint = MuleManager.getInstance().lookupEndpoint("waterMelonEndpoint");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"test.queue", (String)endpoint.getEndpointURI().getAddress());
        UMODescriptor descriptor = MuleManager.getInstance().lookupModel("main").getDescriptor("orangeComponent");
        UMOEndpoint ep = descriptor.getInboundRouter().getEndpoint("Orange");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)ep);
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)ep.getResponseTransformer());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(ep.getResponseTransformer() instanceof TestCompressionTransformer));
    }

    public void testInterceptorStacks() {
        UMOInterceptorStack stack = MuleManager.getInstance().lookupInterceptorStack("default");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)stack);
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)stack.getInterceptors().size());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(stack.getInterceptors().get(0) instanceof LoggingInterceptor));
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(stack.getInterceptors().get(1) instanceof TimerInterceptor));
    }

    public void testExceptionStrategy() {
        UMODescriptor descriptor = MuleManager.getInstance().lookupModel("main").getDescriptor("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)MuleManager.getInstance().lookupModel("main").getExceptionListener());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)descriptor.getExceptionListener());
        AbstractScriptConfigBuilderTestCase.assertTrue((((AbstractExceptionListener)descriptor.getExceptionListener()).getEndpoints().size() > 0 ? 1 : 0) != 0);
        UMOEndpoint ep = (UMOEndpoint)((AbstractExceptionListener)descriptor.getExceptionListener()).getEndpoints().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"test://orange.exceptions", (String)ep.getEndpointURI().toString());
    }

    public void testTransformerConfig() {
        UMOTransformer t = MuleManager.getInstance().lookupTransformer("TestCompressionTransformer");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)t);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(t instanceof TestCompressionTransformer));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)t.getReturnClass(), (Object)String.class);
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)((TestCompressionTransformer)t).getContainerProperty());
    }

    public void testModelConfig() throws Exception {
        UMOModel model = MuleManager.getInstance().lookupModel("main");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)model);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"main", (String)model.getName());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(model.getEntryPointResolver() instanceof TestEntryPointResolver));
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(model.getExceptionListener() instanceof TestExceptionStrategy));
        AbstractScriptConfigBuilderTestCase.assertTrue((((AbstractExceptionListener)model.getExceptionListener()).getEndpoints().size() > 0 ? 1 : 0) != 0);
        UMOEndpoint ep = (UMOEndpoint)((AbstractExceptionListener)model.getExceptionListener()).getEndpoints().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"test://component.exceptions", (String)ep.getEndpointURI().toString());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(model.getLifecycleAdapterFactory() instanceof TestDefaultLifecycleAdapterFactory));
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)model.isComponentRegistered("orangeComponent"));
    }

    public void testPropertiesConfig() throws Exception {
        UMODescriptor descriptor = MuleManager.getInstance().lookupModel("main").getDescriptor("orangeComponent");
        Map props = descriptor.getProperties();
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)props);
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"9", props.get("segments"));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"4.21", props.get("radius"));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"Juicy Baby!", props.get("brand"));
        AbstractScriptConfigBuilderTestCase.assertNotNull(props.get("listProperties"));
        List list = (List)props.get("listProperties");
        AbstractScriptConfigBuilderTestCase.assertEquals((int)3, (int)list.size());
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"prop1", list.get(0));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"prop2", list.get(1));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"prop3", list.get(2));
        AbstractScriptConfigBuilderTestCase.assertNotNull(props.get("arrayProperties"));
        list = (List)props.get("arrayProperties");
        AbstractScriptConfigBuilderTestCase.assertEquals((int)3, (int)list.size());
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"prop4", list.get(0));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"prop5", list.get(1));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"prop6", list.get(2));
        AbstractScriptConfigBuilderTestCase.assertNotNull(props.get("mapProperties"));
        props = (Map)props.get("mapProperties");
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"prop1", props.get("prop1"));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)"prop2", props.get("prop2"));
        AbstractScriptConfigBuilderTestCase.assertEquals((int)7, (int)descriptor.getProperties().size());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)descriptor.getInboundRouter().getEndpoints().size());
    }

    public void testOutboundRouterConfig() {
        UMODescriptor descriptor = MuleManager.getInstance().lookupModel("main").getDescriptor("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)descriptor.getOutboundRouter());
        UMOOutboundRouterCollection router = descriptor.getOutboundRouter();
        AbstractScriptConfigBuilderTestCase.assertNull((Object)router.getCatchAllStrategy());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)router.getRouters().size());
        UMOOutboundRouter route1 = (UMOOutboundRouter)router.getRouters().get(0);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(route1 instanceof OutboundPassThroughRouter));
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)route1.getEndpoints().size());
    }

    public void testNestedRouterConfig() {
        UMODescriptor descriptor = MuleManager.getInstance().lookupModel("main").getDescriptor("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)descriptor.getNestedRouter());
        UMONestedRouterCollection router = descriptor.getNestedRouter();
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)router.getRouters().size());
        UMONestedRouter route1 = (UMONestedRouter)router.getRouters().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)FruitCleaner.class, (Object)route1.getInterface());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"wash", (String)route1.getMethod());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)route1.getEndpoint());
        UMONestedRouter route2 = (UMONestedRouter)router.getRouters().get(1);
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)FruitCleaner.class, (Object)route2.getInterface());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"polish", (String)route2.getMethod());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)route2.getEndpoint());
        Orange orange = (Orange)descriptor.getProperties().get("orange");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)orange);
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)orange.getCleaner());
    }

    public void testDescriptorEndpoints() {
        UMODescriptor descriptor = MuleManager.getInstance().lookupModel("main").getDescriptor("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)descriptor.getOutboundRouter().getRouters().size());
        UMOOutboundRouter router = (UMOOutboundRouter)descriptor.getOutboundRouter().getRouters().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)router.getEndpoints().size());
        UMOEndpoint endpoint = (UMOEndpoint)router.getEndpoints().get(0);
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"appleInEndpoint", (String)endpoint.getName());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint.getTransformer());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(endpoint.getTransformer() instanceof TestCompressionTransformer));
        endpoint = MuleManager.getInstance().lookupEndpoint("appleInEndpoint");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertNull((Object)endpoint.getTransformer());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)descriptor.getInboundRouter().getEndpoints().size());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)descriptor.getInboundRouter().getCatchAllStrategy());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(descriptor.getInboundRouter().getCatchAllStrategy() instanceof ForwardingCatchAllStrategy));
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)descriptor.getInboundRouter().getCatchAllStrategy().getEndpoint());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"test://catch.all", (String)descriptor.getInboundRouter().getCatchAllStrategy().getEndpoint().getEndpointURI().toString());
        endpoint = descriptor.getInboundRouter().getEndpoint("orangeEndpoint");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"orangeEndpoint", (String)endpoint.getName());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"orangeQ", (String)endpoint.getEndpointURI().getAddress());
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint.getTransformer());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(endpoint.getTransformer() instanceof TestCompressionTransformer));
        endpoint = MuleManager.getInstance().lookupEndpoint("orangeEndpoint");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractScriptConfigBuilderTestCase.assertNull((Object)endpoint.getTransformer());
    }

    public void testInboundRouterConfig() {
        UMODescriptor descriptor = MuleManager.getInstance().lookupModel("main").getDescriptor("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)descriptor.getInboundRouter());
        UMOInboundRouterCollection messageRouter = descriptor.getInboundRouter();
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)messageRouter.getCatchAllStrategy());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)0, (int)messageRouter.getRouters().size());
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(messageRouter.getCatchAllStrategy() instanceof ForwardingCatchAllStrategy));
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)messageRouter.getEndpoints().size());
    }

    public void testResponseRouterConfig() {
        UMODescriptor descriptor = MuleManager.getInstance().lookupModel("main").getDescriptor("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)descriptor.getResponseRouter());
        UMOResponseRouterCollection messageRouter = descriptor.getResponseRouter();
        AbstractScriptConfigBuilderTestCase.assertNull((Object)messageRouter.getCatchAllStrategy());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)10001, (int)messageRouter.getTimeout());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)1, (int)messageRouter.getRouters().size());
        UMOResponseRouter router = (UMOResponseRouter)messageRouter.getRouters().get(0);
        AbstractScriptConfigBuilderTestCase.assertTrue((boolean)(router instanceof TestResponseAggregator));
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)messageRouter.getEndpoints());
        AbstractScriptConfigBuilderTestCase.assertEquals((int)2, (int)messageRouter.getEndpoints().size());
        UMOEndpoint ep = (UMOEndpoint)messageRouter.getEndpoints().get(0);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"response1", (String)ep.getEndpointURI().getAddress());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"response", (String)ep.getType());
        ep = (UMOEndpoint)messageRouter.getEndpoints().get(1);
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"AppleResponseQueue", (String)ep.getEndpointURI().getAddress());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"response", (String)ep.getType());
    }

    public void testObjectReferences() throws UMOException {
        MuleDescriptor descriptor = (MuleDescriptor)MuleManager.getInstance().lookupModel("main").getDescriptor("orangeComponent");
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)new DescriptorContainerKeyPair("orangeComponent", "orange"), (Object)descriptor.getImplementation());
        AbstractScriptConfigBuilderTestCase.assertEquals((String)"descriptor", (String)descriptor.getContainer());
        AbstractScriptConfigBuilderTestCase.assertNotNull(descriptor.getProperties().get("orange"));
        AbstractScriptConfigBuilderTestCase.assertEquals((Object)Orange.class, (Object)descriptor.getImplementationClass());
    }

    public void testAgentConfiguration() throws UMOException {
        UMOAgent agent = MuleManager.getInstance().unregisterAgent("jmxAgent");
        AbstractScriptConfigBuilderTestCase.assertNotNull((Object)agent);
    }
}

