/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.encryption;

import java.io.UnsupportedEncodingException;
import org.mule.MuleManager;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.UMOEncryptionStrategy;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.security.CryptoFailureException;
import org.mule.umo.transformer.TransformerException;

public abstract class AbstractEncryptionTransformer
extends AbstractTransformer {
    private UMOEncryptionStrategy strategy = null;
    private String strategyName = null;

    public AbstractEncryptionTransformer() {
        this.registerSourceType([B.class);
        this.registerSourceType(String.class);
        this.setReturnClass([B.class);
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractEncryptionTransformer clone = (AbstractEncryptionTransformer)super.clone();
        clone.setStrategy(this.strategy);
        clone.setStrategyName(this.strategyName);
        return clone;
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        byte[] buf = src instanceof String ? src.toString().getBytes() : (byte[])src;
        try {
            byte[] result = this.getTransformedBytes(buf);
            if (this.getReturnClass().equals(String.class)) {
                if (encoding != null) {
                    try {
                        return new String(result, encoding);
                    }
                    catch (UnsupportedEncodingException ex) {
                        return new String(result);
                    }
                }
                return new String(result);
            }
            return result;
        }
        catch (CryptoFailureException e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    protected abstract byte[] getTransformedBytes(byte[] var1) throws CryptoFailureException;

    public void initialise() throws InitialisationException {
        if (this.strategyName != null) {
            if (MuleManager.getInstance().getSecurityManager() == null) {
                if (this.strategy == null) {
                    throw new InitialisationException(CoreMessages.authSecurityManagerNotSet(), (Object)this);
                }
            } else {
                this.strategy = MuleManager.getInstance().getSecurityManager().getEncryptionStrategy(this.strategyName);
            }
        }
        if (this.strategy == null) {
            throw new InitialisationException(CoreMessages.encryptionStrategyNotSet(), (Object)this);
        }
    }

    public UMOEncryptionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(UMOEncryptionStrategy strategy) {
        this.strategy = strategy;
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }
}

