/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.loaders;

import com.tc.aspectwerkz.transform.inlining.AsmHelper;
import com.tc.object.loaders.BytecodeProvider;
import com.tc.object.loaders.ClassProvider;
import com.tc.object.loaders.NamedClassLoader;
import com.tc.object.loaders.Namespace;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class StandardClassProvider
implements ClassProvider {
    private static final String BOOT = Namespace.getStandardBootstrapLoaderName();
    private static final String EXT = Namespace.getStandardExtensionsLoaderName();
    private static final String SYSTEM = Namespace.getStandardSystemLoaderName();
    private final Map loaders = new HashMap();

    public ClassLoader getClassLoader(String desc) {
        if (this.isStandardLoader(desc)) {
            return SystemLoaderHolder.loader;
        }
        ClassLoader rv = this.lookupLoader(desc);
        if (rv == null) {
            throw new AssertionError((Object)("No registered loader for description: " + desc));
        }
        return rv;
    }

    public Class getClassFor(String className, String desc) throws ClassNotFoundException {
        ClassLoader loader;
        if (this.isStandardLoader(desc)) {
            loader = SystemLoaderHolder.loader;
        } else {
            loader = this.lookupLoader(desc);
            if (loader == null) {
                throw new ClassNotFoundException("No registered loader for description: " + desc + ", trying to load " + className);
            }
        }
        try {
            return Class.forName(className, false, loader);
        }
        catch (ClassNotFoundException e) {
            BytecodeProvider provider;
            byte[] bytes;
            if (loader instanceof BytecodeProvider && (bytes = (provider = (BytecodeProvider)((Object)loader)).__tc_getBytecodeForClass(className)) != null && bytes.length != 0) {
                return AsmHelper.defineClass((ClassLoader)loader, (byte[])bytes, (String)className);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNamedLoader(NamedClassLoader loader) {
        String name = StandardClassProvider.getName(loader);
        Map map = this.loaders;
        synchronized (map) {
            this.loaders.put(name, new WeakReference<NamedClassLoader>(loader));
        }
    }

    private static String getName(NamedClassLoader loader) {
        String name = loader.__tc_getClassLoaderName();
        if (name == null || name.length() == 0) {
            throw new AssertionError((Object)("Invalid name [" + name + "] from loader " + loader));
        }
        return name;
    }

    public String getLoaderDescriptionFor(Class clazz) {
        return this.getLoaderDescriptionFor(clazz.getClassLoader());
    }

    public String getLoaderDescriptionFor(ClassLoader loader) {
        if (loader == null) {
            return BOOT;
        }
        if (loader instanceof NamedClassLoader) {
            return StandardClassProvider.getName((NamedClassLoader)((Object)loader));
        }
        throw this.handleMissingLoader(loader);
    }

    private RuntimeException handleMissingLoader(ClassLoader loader) {
        if ("org.apache.jasper.servlet.JasperLoader".equals(loader.getClass().getName())) {
            return new RuntimeException("JSP instances (and inner classes there of) cannot be distributed, loader = " + loader);
        }
        return new RuntimeException("No loader description for " + loader);
    }

    private boolean isStandardLoader(String desc) {
        return BOOT.equals(desc) || EXT.equals(desc) || SYSTEM.equals(desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader lookupLoader(String desc) {
        ClassLoader rv;
        Map map = this.loaders;
        synchronized (map) {
            WeakReference ref = (WeakReference)this.loaders.get(desc);
            if (ref != null) {
                rv = (ClassLoader)ref.get();
                if (rv == null) {
                    this.loaders.remove(desc);
                }
            } else {
                rv = null;
            }
        }
        return rv;
    }

    public static class SystemLoaderHolder {
        static final ClassLoader loader = ClassLoader.getSystemClassLoader();
    }
}

