/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.loaders;

public class Namespace {
    private static final String SEP = ".";
    private static final String CLASS_NAME_LOADER_SEPARATOR = ":://::";
    private static final String LOGICAL_CLASS_EXTENDS_SEPARATOR = "::";
    public static final String STANDARD_NAMESPACE = "Standard.";
    public static final String TOMCAT_NAMESPACE = "Tomcat.";
    public static final String GERONIMO_NAMESPACE = "Geronimo.";
    public static final String WEBLOGIC_NAMESPACE = "Weblogic.";
    public static final String JBOSS_NAMESPACE = "JBoss.";
    public static final String MODULES_NAMESPACE = "Modules.";
    public static final String JETTY_NAMESPACE = "Jetty.";
    public static final String WEBSPHERE_NAMESPACE = "Websphere.";
    private static final String SYSTEM_LOADER_NAME = "Standard.system";
    private static final String EXT_LOADER_NAME = "Standard.ext";
    private static final String BOOT_LOADER_NAME = "Standard.bootstrap";

    public static String getStandardSystemLoaderName() {
        return SYSTEM_LOADER_NAME;
    }

    public static String getStandardExtensionsLoaderName() {
        return EXT_LOADER_NAME;
    }

    public static String getStandardBootstrapLoaderName() {
        return BOOT_LOADER_NAME;
    }

    public static String getClassNameAndLoaderSeparator() {
        return CLASS_NAME_LOADER_SEPARATOR;
    }

    public static String getLogicalClassExtendsSeparator() {
        return LOGICAL_CLASS_EXTENDS_SEPARATOR;
    }

    public static String createLogicalExtendingClassName(String className, String superClassName) {
        return className + LOGICAL_CLASS_EXTENDS_SEPARATOR + superClassName;
    }

    public static String parseClassNameIfNecessary(String className) {
        int separatorIndex = className.indexOf(LOGICAL_CLASS_EXTENDS_SEPARATOR);
        if (separatorIndex == -1) {
            return className;
        }
        return className.substring(0, separatorIndex);
    }

    public static String parseLogicalNameIfNeceesary(String className) {
        int separatorIndex = className.indexOf(LOGICAL_CLASS_EXTENDS_SEPARATOR);
        if (separatorIndex == -1) {
            return null;
        }
        return className.substring(separatorIndex + LOGICAL_CLASS_EXTENDS_SEPARATOR.length());
    }

    public static String createLoaderName(String topLevel, String subName) {
        if (topLevel == null) {
            throw new IllegalArgumentException("topLevel space is null");
        }
        if (subName == null) {
            throw new IllegalArgumentException("subName is null");
        }
        if (topLevel.equals(TOMCAT_NAMESPACE) || topLevel.equals(WEBLOGIC_NAMESPACE) || topLevel.equals(GERONIMO_NAMESPACE) || topLevel.equals(JBOSS_NAMESPACE) || topLevel.equals(MODULES_NAMESPACE) || topLevel.equals(JETTY_NAMESPACE) || topLevel.equals(WEBSPHERE_NAMESPACE)) {
            return topLevel + subName;
        }
        throw new IllegalArgumentException("Invalid top level namespace: " + topLevel);
    }

    private Namespace() {
    }
}

