/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode.hook.impl;

import com.tc.object.TCObject;
import com.tc.object.util.IdentityWeakHashMap;
import com.tc.util.Assert;
import java.util.HashMap;
import java.util.Map;

public class ArrayManager {
    private static final int CACHE_DEPTH = 2;
    private static final int NUM_MAPS = 128;
    private static final int INITIAL_CAPACITY = 500;
    private static final float LOAD_FACTOR = 0.75f;
    private static final Map[] maps = new Map[128];
    private static final Map primClasses = new HashMap();
    private static final Object[] keys = new Object[256];
    private static final TCObject[] values = new TCObject[256];
    private static final int BOOLEAN = 1;
    private static final int BYTE = 2;
    private static final int CHAR = 3;
    private static final int DOUBLE = 4;
    private static final int FLOAT = 5;
    private static final int INT = 6;
    private static final int LONG = 7;
    private static final int SHORT = 8;

    private ArrayManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Object array, TCObject tco) {
        TCObject prev;
        if (array == null || tco == null) {
            throw new NullPointerException();
        }
        int index = array.hashCode() % 128;
        Map map = maps[index];
        int start = index * 2;
        int end = start + 2;
        Map map2 = map;
        synchronized (map2) {
            for (int i = start; i < end; ++i) {
                if (keys[i] != array) continue;
                ArrayManager.values[i] = tco;
                break;
            }
            prev = map.put(array, tco);
        }
        if (prev != null) {
            throw new AssertionError((Object)("replaced mapping for " + array));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TCObject getObject(Object array) {
        int hash = array.hashCode();
        int index = hash % 128;
        Map map = maps[index];
        int start = index * 2;
        int end = start + 2;
        Map map2 = map;
        synchronized (map2) {
            for (int i = start; i < end; ++i) {
                if (keys[i] != array) continue;
                return values[i];
            }
            int evict = start + hash % 2;
            TCObject rv = (TCObject)map.get(array);
            ArrayManager.keys[evict] = array;
            ArrayManager.values[evict] = rv;
            return rv;
        }
    }

    public static TCObject getCloneObject(Object array) {
        return ArrayManager.getObject(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object get(Object array, int index) {
        if (array == null) {
            throw new NullPointerException();
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array)[index] ? Boolean.TRUE : Boolean.FALSE;
        }
        if (array instanceof byte[]) {
            return new Byte(((byte[])array)[index]);
        }
        if (array instanceof char[]) {
            return new Character(((char[])array)[index]);
        }
        if (array instanceof short[]) {
            return new Short(((short[])array)[index]);
        }
        if (array instanceof int[]) {
            return new Integer(((int[])array)[index]);
        }
        if (array instanceof long[]) {
            return new Long(((long[])array)[index]);
        }
        if (array instanceof float[]) {
            return new Float(((float[])array)[index]);
        }
        if (array instanceof double[]) {
            return new Double(((double[])array)[index]);
        }
        if (array instanceof Object[]) {
            TCObject tco = ArrayManager.getObject(array);
            if (tco != null) {
                Object object = tco.getResolveLock();
                synchronized (object) {
                    tco.resolveArrayReference(index);
                    return ((Object[])array)[index];
                }
            }
            return ((Object[])array)[index];
        }
        throw new IllegalArgumentException("Not an array type: " + array.getClass().getName());
    }

    public static void objectArrayChanged(Object[] array, int index, Object value) {
        Object existingObj = array[index];
        TCObject tco = ArrayManager.getObject(array);
        if (tco != null) {
            tco.objectFieldChanged(array.getClass().getName(), null, value, index);
        }
        array[index] = value;
    }

    public static void shortArrayChanged(short[] array, int index, short value) {
        short existingVal = array[index];
        TCObject tco = ArrayManager.getObject(array);
        if (tco != null) {
            tco.shortFieldChanged(null, null, value, index);
        }
        array[index] = value;
    }

    public static void longArrayChanged(long[] array, int index, long value) {
        long existingVal = array[index];
        TCObject tco = ArrayManager.getObject(array);
        if (tco != null) {
            tco.longFieldChanged(null, null, value, index);
        }
        array[index] = value;
    }

    public static void intArrayChanged(int[] array, int index, int value) {
        int existingVal = array[index];
        TCObject tco = ArrayManager.getObject(array);
        if (tco != null) {
            tco.intFieldChanged(null, null, value, index);
        }
        array[index] = value;
    }

    public static void floatArrayChanged(float[] array, int index, float value) {
        float existingVal = array[index];
        TCObject tco = ArrayManager.getObject(array);
        if (tco != null) {
            tco.floatFieldChanged(null, null, value, index);
        }
        array[index] = value;
    }

    public static void doubleArrayChanged(double[] array, int index, double value) {
        double existingVal = array[index];
        TCObject tco = ArrayManager.getObject(array);
        if (tco != null) {
            tco.doubleFieldChanged(null, null, value, index);
        }
        array[index] = value;
    }

    public static void charArrayChanged(char[] array, int index, char value) {
        char existingVal = array[index];
        TCObject tco = ArrayManager.getObject(array);
        if (tco != null) {
            tco.charFieldChanged(null, null, value, index);
        }
        array[index] = value;
    }

    public static void byteOrBooleanArrayChanged(Object array, int index, byte value) {
        if (array == null) {
            throw new NullPointerException();
        }
        if (array.getClass().getName().charAt(1) == 'Z') {
            boolean[] booleanArray = (boolean[])array;
            boolean existingBooleanVal = booleanArray[index];
            boolean booleanValue = value == 1;
            TCObject tco = ArrayManager.getObject(array);
            if (tco != null) {
                tco.booleanFieldChanged(null, null, booleanValue, index);
            }
            booleanArray[index] = booleanValue;
        } else {
            byte[] byteArray = (byte[])array;
            byte existingByteVal = byteArray[index];
            TCObject tco = ArrayManager.getObject(array);
            if (tco != null) {
                tco.byteFieldChanged(null, null, value, index);
            }
            byteArray[index] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void arraycopy(Object src, int srcPos, Object dest, int destPos, int length) {
        if (src == null || dest == null) {
            throw new NullPointerException();
        }
        TCObject tcDest = ArrayManager.getObject(dest);
        Class<?> destType = dest.getClass().getComponentType();
        if (destType == null) {
            throw new ArrayStoreException();
        }
        boolean isDestPrimitive = destType.isPrimitive();
        if (isDestPrimitive && tcDest == null) {
            System.arraycopy(src, srcPos, dest, destPos, length);
            return;
        }
        TCObject tcSrc = ArrayManager.getObject(src);
        if (tcDest != null || tcSrc != null) {
            Class<?> srcType = src.getClass().getComponentType();
            if (srcType == null) {
                throw new ArrayStoreException();
            }
            boolean isSrcPrimitive = srcType.isPrimitive();
            if (isDestPrimitive) {
                int destCode = ArrayManager.getCodeForType(destType);
                if (isSrcPrimitive) {
                    int srcCode = ArrayManager.getCodeForType(srcType);
                    if (srcCode != destCode) {
                        throw new ArrayStoreException();
                    }
                } else {
                    throw new ArrayStoreException();
                }
                switch (destCode) {
                    case 1: {
                        ArrayManager.booleanArrayCopy((boolean[])src, srcPos, (boolean[])dest, destPos, length, tcDest);
                        break;
                    }
                    case 2: {
                        ArrayManager.byteArrayCopy((byte[])src, srcPos, (byte[])dest, destPos, length, tcDest);
                        break;
                    }
                    case 3: {
                        ArrayManager.charArrayCopy((char[])src, srcPos, (char[])dest, destPos, length, tcDest);
                        break;
                    }
                    case 4: {
                        ArrayManager.doubleArrayCopy((double[])src, srcPos, (double[])dest, destPos, length, tcDest);
                        break;
                    }
                    case 5: {
                        ArrayManager.floatArrayCopy((float[])src, srcPos, (float[])dest, destPos, length, tcDest);
                        break;
                    }
                    case 6: {
                        ArrayManager.intArrayCopy((int[])src, srcPos, (int[])dest, destPos, length, tcDest);
                        break;
                    }
                    case 7: {
                        ArrayManager.longArrayCopy((long[])src, srcPos, (long[])dest, destPos, length, tcDest);
                        break;
                    }
                    case 8: {
                        ArrayManager.shortArrayCopy((short[])src, srcPos, (short[])dest, destPos, length, tcDest);
                        break;
                    }
                    default: {
                        throw Assert.failure((Object)("unexpected type code: " + destCode));
                    }
                }
            } else {
                int i;
                if (isSrcPrimitive) {
                    throw new ArrayStoreException();
                }
                Object[] destArray = (Object[])dest;
                Object[] srcArray = (Object[])src;
                if (srcPos < 0 || destPos < 0 || length < 0 || srcPos + length > srcArray.length || destPos + length > destArray.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                Object[] l2subset = new Object[length];
                if (tcSrc != null) {
                    Object object = tcSrc.getResolveLock();
                    synchronized (object) {
                        for (i = 0; i < length; ++i) {
                            tcSrc.resolveArrayReference(srcPos + i);
                            l2subset[i] = srcArray[srcPos + i];
                        }
                    }
                } else {
                    System.arraycopy(src, srcPos, l2subset, 0, length);
                }
                int actualLength = length;
                if (!destType.isAssignableFrom(srcType)) {
                    int n = l2subset.length;
                    for (i = 0; i < n; ++i) {
                        Object srcVal = l2subset[i];
                        if (srcVal == null || destType.isAssignableFrom(srcVal.getClass())) continue;
                        actualLength = i;
                        break;
                    }
                }
                Object[] localSubset = new Object[actualLength];
                System.arraycopy(l2subset, 0, localSubset, 0, actualLength);
                if (tcDest != null && actualLength > 0) {
                    tcDest.objectArrayChanged(destPos, l2subset, actualLength);
                }
                System.arraycopy(localSubset, 0, dest, destPos, actualLength);
                if (actualLength != length) {
                    throw new ArrayStoreException();
                }
            }
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    private static int getCodeForType(Class type) {
        Integer code = (Integer)primClasses.get(type);
        if (code == null) {
            throw new RuntimeException("No code for type " + type);
        }
        return code;
    }

    private static void booleanArrayCopy(boolean[] src, int srcPos, boolean[] dest, int destPos, int length, TCObject tcDest) {
        if (srcPos < 0 || destPos < 0 || length < 0 || srcPos + length > src.length || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        boolean[] l2subset = new boolean[length];
        System.arraycopy(src, srcPos, l2subset, 0, length);
        tcDest.primitiveArrayChanged(destPos, (Object)l2subset, length);
        System.arraycopy(l2subset, 0, dest, destPos, length);
    }

    private static void byteArrayCopy(byte[] src, int srcPos, byte[] dest, int destPos, int length, TCObject tcDest) {
        if (srcPos < 0 || destPos < 0 || length < 0 || srcPos + length > src.length || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] l2subset = new byte[length];
        System.arraycopy(src, srcPos, l2subset, 0, length);
        tcDest.primitiveArrayChanged(destPos, (Object)l2subset, length);
        System.arraycopy(l2subset, 0, dest, destPos, length);
    }

    public static void charArrayCopy(char[] src, int srcPos, char[] dest, int destPos, int length, TCObject tcDest) {
        if (srcPos < 0 || destPos < 0 || length < 0 || srcPos + length > src.length || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        char[] l2subset = new char[length];
        System.arraycopy(src, srcPos, l2subset, 0, length);
        tcDest.primitiveArrayChanged(destPos, (Object)l2subset, length);
        System.arraycopy(l2subset, 0, dest, destPos, length);
    }

    private static void doubleArrayCopy(double[] src, int srcPos, double[] dest, int destPos, int length, TCObject tcDest) {
        if (srcPos < 0 || destPos < 0 || length < 0 || srcPos + length > src.length || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        double[] l2subset = new double[length];
        System.arraycopy(src, srcPos, l2subset, 0, length);
        tcDest.primitiveArrayChanged(destPos, (Object)l2subset, length);
        System.arraycopy(l2subset, 0, dest, destPos, length);
    }

    private static void floatArrayCopy(float[] src, int srcPos, float[] dest, int destPos, int length, TCObject tcDest) {
        if (srcPos < 0 || destPos < 0 || length < 0 || srcPos + length > src.length || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        float[] l2subset = new float[length];
        System.arraycopy(src, srcPos, l2subset, 0, length);
        tcDest.primitiveArrayChanged(destPos, (Object)l2subset, length);
        System.arraycopy(l2subset, 0, dest, destPos, length);
    }

    private static void intArrayCopy(int[] src, int srcPos, int[] dest, int destPos, int length, TCObject tcDest) {
        if (srcPos < 0 || destPos < 0 || length < 0 || srcPos + length > src.length || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] l2subset = new int[length];
        System.arraycopy(src, srcPos, l2subset, 0, length);
        tcDest.primitiveArrayChanged(destPos, (Object)l2subset, length);
        System.arraycopy(l2subset, 0, dest, destPos, length);
    }

    private static void longArrayCopy(long[] src, int srcPos, long[] dest, int destPos, int length, TCObject tcDest) {
        if (srcPos < 0 || destPos < 0 || length < 0 || srcPos + length > src.length || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long[] l2subset = new long[length];
        System.arraycopy(src, srcPos, l2subset, 0, length);
        tcDest.primitiveArrayChanged(destPos, (Object)l2subset, length);
        System.arraycopy(l2subset, 0, dest, destPos, length);
    }

    private static void shortArrayCopy(short[] src, int srcPos, short[] dest, int destPos, int length, TCObject tcDest) {
        if (srcPos < 0 || destPos < 0 || length < 0 || srcPos + length > src.length || destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        short[] l2subset = new short[length];
        System.arraycopy(src, srcPos, l2subset, 0, length);
        tcDest.primitiveArrayChanged(destPos, (Object)l2subset, length);
        System.arraycopy(l2subset, 0, dest, destPos, length);
    }

    static {
        for (int i = 0; i < maps.length; ++i) {
            ArrayManager.maps[i] = new IdentityWeakHashMap(500, 0.75f);
        }
        primClasses.put(Boolean.TYPE, new Integer(1));
        primClasses.put(Byte.TYPE, new Integer(2));
        primClasses.put(Character.TYPE, new Integer(3));
        primClasses.put(Double.TYPE, new Integer(4));
        primClasses.put(Float.TYPE, new Integer(5));
        primClasses.put(Integer.TYPE, new Integer(6));
        primClasses.put(Long.TYPE, new Integer(7));
        primClasses.put(Short.TYPE, new Integer(8));
    }
}

