/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode.hook.impl;

import com.tc.aspectwerkz.reflect.ClassInfo;
import com.tc.aspectwerkz.transform.InstrumentationContext;
import com.tc.aspectwerkz.transform.WeavingStrategy;
import com.tc.config.schema.IllegalConfigurationChangeHandler;
import com.tc.config.schema.L2ConfigForL1;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.FatalIllegalConfigurationChangeHandler;
import com.tc.config.schema.setup.L1TVSConfigurationSetupManager;
import com.tc.config.schema.setup.StandardTVSConfigurationSetupManagerFactory;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.object.bytecode.Manageable;
import com.tc.object.bytecode.Manager;
import com.tc.object.bytecode.ManagerImpl;
import com.tc.object.bytecode.hook.DSOContext;
import com.tc.object.bytecode.hook.impl.DefaultWeavingStrategy;
import com.tc.object.bytecode.hook.impl.PreparedComponentsFromL2Connection;
import com.tc.object.config.DSOClientConfigHelper;
import com.tc.object.config.IncompleteBootJarException;
import com.tc.object.config.StandardDSOClientConfigHelperImpl;
import com.tc.object.config.UnverifiedBootJarException;
import com.tc.object.loaders.ClassProvider;
import com.tc.object.logging.InstrumentationLogger;
import com.tc.plugins.ModulesLoader;
import com.tc.util.Assert;
import com.tc.util.TCTimeoutException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.io.CopyUtils;

public class DSOContextImpl
implements DSOContext {
    private static final TCLogger logger = TCLogging.getLogger((Class)DSOContextImpl.class);
    private static DSOClientConfigHelper staticConfigHelper;
    private static PreparedComponentsFromL2Connection preparedComponentsFromL2Connection;
    private final DSOClientConfigHelper configHelper;
    private final Manager manager;
    private final InstrumentationLogger instrumentationLogger;
    private final WeavingStrategy weavingStrategy;
    private static final long MAX_HTTP_FETCH_TIME = 30000L;
    private static final long HTTP_FETCH_RETRY_INTERVAL = 1000L;

    public static DSOContext createGlobalContext(ClassProvider globalProvider) throws ConfigurationSetupException {
        DSOClientConfigHelper configHelper = DSOContextImpl.getGlobalConfigHelper();
        ManagerImpl manager = new ManagerImpl(configHelper, globalProvider, preparedComponentsFromL2Connection);
        return new DSOContextImpl(configHelper, globalProvider, (Manager)manager);
    }

    public static DSOContext createContext(String configSpec, ClassProvider globalProvider) throws ConfigurationSetupException {
        PreparedComponentsFromL2Connection l2Connection;
        StandardTVSConfigurationSetupManagerFactory factory = new StandardTVSConfigurationSetupManagerFactory((String[])null, false, (IllegalConfigurationChangeHandler)new FatalIllegalConfigurationChangeHandler(), configSpec);
        L1TVSConfigurationSetupManager config = factory.createL1TVSConfigurationSetupManager();
        config.setupLogging();
        try {
            l2Connection = DSOContextImpl.validateMakeL2Connection(config);
        }
        catch (Exception e) {
            throw new ConfigurationSetupException(e.getLocalizedMessage(), (Throwable)e);
        }
        StandardDSOClientConfigHelperImpl configHelper = new StandardDSOClientConfigHelperImpl(config);
        ManagerImpl manager = new ManagerImpl((DSOClientConfigHelper)configHelper, globalProvider, l2Connection);
        manager.init();
        return DSOContextImpl.createContext((DSOClientConfigHelper)configHelper, globalProvider, (Manager)manager);
    }

    public static DSOContext createContext(DSOClientConfigHelper configHelper, ClassProvider classProvider, Manager manager) {
        return new DSOContextImpl(configHelper, classProvider, manager);
    }

    public static boolean isDSOSessions(String appName) throws ConfigurationSetupException {
        return DSOContextImpl.getGlobalConfigHelper().isDSOSessions(appName);
    }

    private DSOContextImpl(DSOClientConfigHelper configHelper, ClassProvider classProvider, Manager manager) {
        this.checkForProperlyInstrumentedBaseClasses();
        if (configHelper == null) {
            throw new NullPointerException();
        }
        this.configHelper = configHelper;
        this.manager = manager;
        this.instrumentationLogger = manager.getInstrumentationLogger();
        this.weavingStrategy = new DefaultWeavingStrategy(configHelper, this.instrumentationLogger);
        ModulesLoader.initModules((DSOClientConfigHelper)configHelper, (ClassProvider)classProvider, (boolean)false);
        this.validateBootJar();
    }

    private void validateBootJar() {
        try {
            this.configHelper.verifyBootJarContents(null);
        }
        catch (UnverifiedBootJarException ubjex) {
            StringBuffer msg = new StringBuffer(ubjex.getMessage() + " ");
            msg.append("Unable to verify the contents of the boot jar; ");
            msg.append("Please check the client logs for more information.");
            logger.error((Object)ubjex);
            throw new RuntimeException(msg.toString());
        }
        catch (IncompleteBootJarException ibjex) {
            StringBuffer msg = new StringBuffer(ibjex.getMessage() + " ");
            msg.append("The DSO boot jar appears to be incomplete --- some pre-instrumented classes ");
            msg.append("listed in your tc-config is not included in the boot jar file. This could ");
            msg.append("happen if you've modified your DSO clients' tc-config file to specify additional ");
            msg.append("classes for inclusion in the boot jar, but forgot to rebuild the boot jar. Or, you ");
            msg.append("could be a using an older boot jar against a newer Terracotta client installation. ");
            msg.append("Please check the client logs for the list of classes that were not found in your boot jar.");
            logger.error((Object)ibjex);
            throw new RuntimeException(msg.toString());
        }
    }

    private void checkForProperlyInstrumentedBaseClasses() {
        if (!Manageable.class.isAssignableFrom(HashMap.class)) {
            StringBuffer msg = new StringBuffer();
            msg.append("The DSO boot jar is not prepended to your bootclasspath! ");
            msg.append("Generate it using the make-boot-jar script ");
            msg.append("and place the generated jar file in the bootclasspath ");
            msg.append("(i.e. -Xbootclasspath/p:/path/to/terracotta/lib/dso-boot/dso-boot-xxx.jar)");
            throw new RuntimeException(msg.toString());
        }
    }

    public Manager getManager() {
        return this.manager;
    }

    public byte[] preProcess(String name, byte[] data, int offset, int length, ClassLoader caller) {
        InstrumentationContext context = new InstrumentationContext(name, data, caller);
        this.weavingStrategy.transform(name, context);
        return context.getCurrentBytecode();
    }

    public void postProcess(Class clazz, ClassLoader caller) {
    }

    public void addTransient(String className, String fieldName) {
        this.configHelper.addTransient(className, fieldName);
    }

    public void addInclude(String expression, boolean callConstructorOnLoad, String lockExpression, ClassInfo classInfo) {
        this.configHelper.addIncludeAndLockIfRequired(expression, true, callConstructorOnLoad, false, lockExpression, classInfo);
    }

    public Collection getDSOSpringConfigHelpers() {
        return this.configHelper.getDSOSpringConfigs();
    }

    private static synchronized DSOClientConfigHelper getGlobalConfigHelper() throws ConfigurationSetupException {
        if (staticConfigHelper == null) {
            StandardTVSConfigurationSetupManagerFactory factory = new StandardTVSConfigurationSetupManagerFactory(false, (IllegalConfigurationChangeHandler)new FatalIllegalConfigurationChangeHandler());
            logger.debug((Object)"Created StandardTVSConfigurationSetupManagerFactory.");
            L1TVSConfigurationSetupManager config = factory.createL1TVSConfigurationSetupManager();
            config.setupLogging();
            logger.debug((Object)"Created L1TVSConfigurationSetupManager.");
            try {
                preparedComponentsFromL2Connection = DSOContextImpl.validateMakeL2Connection(config);
            }
            catch (Exception e) {
                throw new ConfigurationSetupException(e.getLocalizedMessage(), (Throwable)e);
            }
            staticConfigHelper = new StandardDSOClientConfigHelperImpl(config);
        }
        return staticConfigHelper;
    }

    private static PreparedComponentsFromL2Connection validateMakeL2Connection(L1TVSConfigurationSetupManager config) throws UnknownHostException, IOException, TCTimeoutException {
        L2ConfigForL1.L2Data[] l2Data = (L2ConfigForL1.L2Data[])config.l2Config().l2Data().getObjects();
        Assert.assertNotNull((Object)l2Data);
        String serverHost = l2Data[0].host();
        return new PreparedComponentsFromL2Connection(config);
    }

    private static String getServerConfigMode(String serverHost, int httpPort) throws MalformedURLException, TCTimeoutException, IOException {
        URL theURL = new URL("http", serverHost, httpPort, "/config?query=mode");
        long startTime = System.currentTimeMillis();
        long lastTrial = 0L;
        while (System.currentTimeMillis() < startTime + 30000L) {
            try {
                long untilNextTrial = 1000L - (System.currentTimeMillis() - lastTrial);
                if (untilNextTrial > 0L) {
                    try {
                        Thread.sleep(untilNextTrial);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                logger.debug((Object)("Opening connection to: " + theURL + " to fetch server configuration."));
                lastTrial = System.currentTimeMillis();
                InputStream in = theURL.openStream();
                logger.debug((Object)("Got input stream to: " + theURL));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                CopyUtils.copy((InputStream)in, (OutputStream)baos);
                return baos.toString();
            }
            catch (ConnectException ce) {
                logger.warn((Object)("Unable to fetch configuration mode from L2 at '" + theURL + "'; trying again. " + "(Is an L2 running at that address?): " + ce.getLocalizedMessage()));
            }
        }
        throw new TCTimeoutException("We tried for " + (int)((System.currentTimeMillis() - startTime) / 1000L) + " seconds, but couldn't fetch system configuration mode from the L2 " + "at '" + theURL + "'. Is the L2 running?");
    }

    public int getSessionLockType(String appName) {
        return this.configHelper.getSessionLockType(appName);
    }

    public URL getClassResource(String className) {
        return this.configHelper.getClassResource(className);
    }
}

