/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode.hook.impl;

import com.tc.asm.ClassAdapter;
import com.tc.asm.ClassReader;
import com.tc.asm.ClassVisitor;
import com.tc.asm.ClassWriter;
import com.tc.asm.commons.EmptyVisitor;
import com.tc.aspectwerkz.definition.SystemDefinition;
import com.tc.aspectwerkz.definition.deployer.StandardAspectModuleDeployer;
import com.tc.aspectwerkz.exception.WrappedRuntimeException;
import com.tc.aspectwerkz.expression.ExpressionContext;
import com.tc.aspectwerkz.expression.PointcutType;
import com.tc.aspectwerkz.reflect.ClassInfo;
import com.tc.aspectwerkz.reflect.ClassInfoHelper;
import com.tc.aspectwerkz.reflect.ReflectionInfo;
import com.tc.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import com.tc.aspectwerkz.transform.InstrumentationContext;
import com.tc.aspectwerkz.transform.WeavingStrategy;
import com.tc.aspectwerkz.transform.inlining.weaver.AddInterfaceVisitor;
import com.tc.aspectwerkz.transform.inlining.weaver.AddMixinMethodsVisitor;
import com.tc.aspectwerkz.transform.inlining.weaver.AddWrapperVisitor;
import com.tc.aspectwerkz.transform.inlining.weaver.AlreadyAddedMethodAdapter;
import com.tc.aspectwerkz.transform.inlining.weaver.ConstructorBodyVisitor;
import com.tc.aspectwerkz.transform.inlining.weaver.ConstructorCallVisitor;
import com.tc.aspectwerkz.transform.inlining.weaver.FieldSetFieldGetVisitor;
import com.tc.aspectwerkz.transform.inlining.weaver.HandlerVisitor;
import com.tc.aspectwerkz.transform.inlining.weaver.InstanceLevelAspectVisitor;
import com.tc.aspectwerkz.transform.inlining.weaver.JoinPointInitVisitor;
import com.tc.aspectwerkz.transform.inlining.weaver.LabelToLineNumberVisitor;
import com.tc.aspectwerkz.transform.inlining.weaver.MethodCallVisitor;
import com.tc.aspectwerkz.transform.inlining.weaver.MethodExecutionVisitor;
import com.tc.aspectwerkz.transform.inlining.weaver.StaticInitializationVisitor;
import com.tc.exception.TCLogicalSubclassNotPortableException;
import com.tc.logging.CustomerLogging;
import com.tc.logging.TCLogger;
import com.tc.object.bytecode.ByteCodeUtil;
import com.tc.object.bytecode.ClassAdapterFactory;
import com.tc.object.bytecode.RenameClassesAdapter;
import com.tc.object.bytecode.SafeSerialVersionUIDAdder;
import com.tc.object.config.ClassReplacementMapping;
import com.tc.object.config.DSOClientConfigHelper;
import com.tc.object.logging.InstrumentationLogger;
import com.tc.object.logging.InstrumentationLoggerImpl;
import com.tc.util.AdaptedClassDumper;
import com.tc.util.InitialClassDumper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultWeavingStrategy
implements WeavingStrategy {
    private static final TCLogger consoleLogger;
    private final DSOClientConfigHelper m_configHelper;
    private final InstrumentationLogger m_logger;
    private final InstrumentationLogger m_instrumentationLogger;

    public DefaultWeavingStrategy(DSOClientConfigHelper configHelper, InstrumentationLogger instrumentationLogger) {
        this.m_configHelper = configHelper;
        this.m_instrumentationLogger = instrumentationLogger;
        this.m_logger = new InstrumentationLoggerImpl(this.m_configHelper.getInstrumentationLoggingOptions());
        StandardAspectModuleDeployer.deploy((ClassLoader)this.getClass().getClassLoader(), (String[])StandardAspectModuleDeployer.ASPECT_MODULES);
    }

    public void transform(String className, InstrumentationContext context) {
        try {
            RenameClassesAdapter cv;
            ClassReplacementMapping mapping;
            String replacementClassName;
            boolean isAdvisable;
            byte[] bytecode = context.getInitialBytecode();
            InitialClassDumper.INSTANCE.write(className, bytecode);
            ClassLoader loader = context.getLoader();
            Map aspectModules = this.m_configHelper.getAspectModules();
            Iterator it = aspectModules.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                if (!className.startsWith((String)e.getKey())) continue;
                List modules = (List)e.getValue();
                Iterator it2 = modules.iterator();
                while (it2.hasNext()) {
                    StandardAspectModuleDeployer.deploy((ClassLoader)loader, (String)((String)it2.next()));
                }
            }
            ClassInfo classInfo = AsmClassInfo.getClassInfo((String)className, (byte[])bytecode, (ClassLoader)loader);
            if (classInfo.getName().startsWith("$") && classInfo.getSuperclass().getName().equals("java.lang.reflect.Proxy")) {
                context.setCurrentBytecode(context.getInitialBytecode());
                return;
            }
            if (context.isProxy() && this.isInstrumentedByDSO(classInfo)) {
                context.setCurrentBytecode(context.getInitialBytecode());
                return;
            }
            boolean isDsoAdaptable = this.m_configHelper.shouldBeAdapted(classInfo);
            boolean hasCustomAdapter = this.m_configHelper.hasCustomAdapter(classInfo);
            Set definitions = context.getDefinitions();
            ExpressionContext[] ctxs = new ExpressionContext[]{new ExpressionContext(PointcutType.EXECUTION, (ReflectionInfo)classInfo, (ReflectionInfo)classInfo), new ExpressionContext(PointcutType.CALL, null, (ReflectionInfo)classInfo), new ExpressionContext(PointcutType.GET, null, (ReflectionInfo)classInfo), new ExpressionContext(PointcutType.SET, null, (ReflectionInfo)classInfo), new ExpressionContext(PointcutType.HANDLER, null, (ReflectionInfo)classInfo), new ExpressionContext(PointcutType.STATIC_INITIALIZATION, (ReflectionInfo)classInfo, (ReflectionInfo)classInfo), new ExpressionContext(PointcutType.WITHIN, (ReflectionInfo)classInfo, (ReflectionInfo)classInfo)};
            boolean bl = isAdvisable = !DefaultWeavingStrategy.classFilter(definitions, ctxs, classInfo);
            if (!(isAdvisable || isDsoAdaptable || hasCustomAdapter)) {
                context.setCurrentBytecode(context.getInitialBytecode());
                return;
            }
            if (this.m_instrumentationLogger.getClassInclusion()) {
                this.m_instrumentationLogger.classIncluded(className);
            }
            if ((isDsoAdaptable || hasCustomAdapter) && (replacementClassName = (mapping = this.m_configHelper.getClassReplacementMapping()).getReplacementClassName(className)) != null && !replacementClassName.equals(className)) {
                URL replacementResource = mapping.getReplacementResource(replacementClassName, loader);
                if (replacementResource == null) {
                    throw new ClassNotFoundException("No resource found for class: " + replacementClassName);
                }
                InputStream is = replacementResource.openStream();
                try {
                    byte[] replacementBytes = ByteCodeUtil.getBytesForInputstream((InputStream)is);
                    ClassReader cr = new ClassReader(replacementBytes);
                    ClassWriter cw = new ClassWriter(cr, 1);
                    cv = new RenameClassesAdapter((ClassVisitor)cw, mapping);
                    cr.accept((ClassVisitor)cv, 4);
                    context.setCurrentBytecode(cw.toByteArray());
                    classInfo = AsmClassInfo.newClassInfo((byte[])context.getCurrentBytecode(), (ClassLoader)loader);
                }
                catch (IOException e) {
                    throw new ClassNotFoundException("Error reading bytes for " + replacementResource, e);
                }
                finally {
                    is.close();
                }
            }
            if (isAdvisable) {
                boolean filterForStaticinitialization;
                boolean filterForCall = DefaultWeavingStrategy.classFilterFor(definitions, new ExpressionContext[]{new ExpressionContext(PointcutType.CALL, null, (ReflectionInfo)classInfo), new ExpressionContext(PointcutType.WITHIN, (ReflectionInfo)classInfo, (ReflectionInfo)classInfo)});
                boolean filterForGetSet = DefaultWeavingStrategy.classFilterFor(definitions, new ExpressionContext[]{new ExpressionContext(PointcutType.GET, null, (ReflectionInfo)classInfo), new ExpressionContext(PointcutType.SET, null, (ReflectionInfo)classInfo), new ExpressionContext(PointcutType.WITHIN, (ReflectionInfo)classInfo, (ReflectionInfo)classInfo)});
                boolean filterForHandler = DefaultWeavingStrategy.classFilterFor(definitions, new ExpressionContext[]{new ExpressionContext(PointcutType.HANDLER, null, (ReflectionInfo)classInfo), new ExpressionContext(PointcutType.WITHIN, (ReflectionInfo)classInfo, (ReflectionInfo)classInfo)});
                boolean bl2 = filterForStaticinitialization = !classInfo.hasStaticInitializer() || DefaultWeavingStrategy.classFilterFor(definitions, new ExpressionContext[]{new ExpressionContext(PointcutType.STATIC_INITIALIZATION, (ReflectionInfo)classInfo.staticInitializer(), (ReflectionInfo)classInfo)});
                if (!filterForStaticinitialization) {
                    filterForStaticinitialization = !DefaultWeavingStrategy.hasPointcut(definitions, new ExpressionContext(PointcutType.STATIC_INITIALIZATION, (ReflectionInfo)classInfo.staticInitializer(), (ReflectionInfo)classInfo));
                }
                ClassReader crLookahead = new ClassReader(bytecode);
                HashMap newInvocationsByCallerMemberHash = null;
                if (!filterForCall) {
                    newInvocationsByCallerMemberHash = new HashMap();
                    crLookahead.accept((ClassVisitor)new ConstructorCallVisitor.LookaheadNewDupInvokeSpecialInstructionClassAdapter(newInvocationsByCallerMemberHash), 6);
                }
                ArrayList catchLabels = new ArrayList();
                if (!filterForHandler) {
                    cv = new EmptyVisitor();
                    HandlerVisitor.LookaheadCatchLabelsClassAdapter lookForCatches = new HandlerVisitor.LookaheadCatchLabelsClassAdapter((ClassVisitor)cv, loader, classInfo, context, catchLabels);
                    ClassReader crLookahead2 = new ClassReader(bytecode);
                    crLookahead2.accept((ClassVisitor)lookForCatches, 4);
                }
                HashSet addedMethods = new HashSet();
                crLookahead.accept((ClassVisitor)new AlreadyAddedMethodAdapter(addedMethods), 6);
                ClassReader readerPhase1 = new ClassReader(bytecode);
                ClassWriter writerPhase1 = new ClassWriter(readerPhase1, 1);
                AddMixinMethodsVisitor reversedChainPhase1 = new AddMixinMethodsVisitor((ClassVisitor)writerPhase1, classInfo, context, addedMethods);
                reversedChainPhase1 = new AddInterfaceVisitor((ClassVisitor)reversedChainPhase1, classInfo, context);
                readerPhase1.accept((ClassVisitor)reversedChainPhase1, 4);
                context.setCurrentBytecode(writerPhase1.toByteArray());
                classInfo = AsmClassInfo.newClassInfo((byte[])context.getCurrentBytecode(), (ClassLoader)loader);
                ClassReader readerPhase2 = new ClassReader(context.getCurrentBytecode());
                ClassWriter writerPhase2 = new ClassWriter(readerPhase2, 1);
                InstanceLevelAspectVisitor reversedChainPhase2 = new InstanceLevelAspectVisitor((ClassVisitor)writerPhase2, classInfo, context);
                reversedChainPhase2 = new MethodExecutionVisitor((ClassVisitor)reversedChainPhase2, classInfo, context, addedMethods);
                reversedChainPhase2 = new ConstructorBodyVisitor((ClassVisitor)reversedChainPhase2, classInfo, context, addedMethods);
                if (!filterForStaticinitialization) {
                    reversedChainPhase2 = new StaticInitializationVisitor((ClassVisitor)reversedChainPhase2, context, addedMethods);
                }
                reversedChainPhase2 = new HandlerVisitor((ClassVisitor)reversedChainPhase2, context, catchLabels);
                if (!filterForCall) {
                    reversedChainPhase2 = new MethodCallVisitor((ClassVisitor)reversedChainPhase2, loader, classInfo, context);
                    reversedChainPhase2 = new ConstructorCallVisitor((ClassVisitor)reversedChainPhase2, loader, classInfo, context, newInvocationsByCallerMemberHash);
                }
                if (!filterForGetSet) {
                    reversedChainPhase2 = new FieldSetFieldGetVisitor((ClassVisitor)reversedChainPhase2, loader, classInfo, context);
                }
                reversedChainPhase2 = new LabelToLineNumberVisitor((ClassVisitor)reversedChainPhase2, context);
                readerPhase2.accept((ClassVisitor)reversedChainPhase2, 4);
                context.setCurrentBytecode(writerPhase2.toByteArray());
                if (context.isAdvised()) {
                    ClassReader readerPhase3 = new ClassReader(context.getCurrentBytecode());
                    ClassWriter writerPhase3 = new ClassWriter(readerPhase3, 1);
                    AddWrapperVisitor reversedChainPhase3 = new AddWrapperVisitor((ClassVisitor)writerPhase3, context, addedMethods);
                    reversedChainPhase3 = new JoinPointInitVisitor((ClassVisitor)reversedChainPhase3, context);
                    readerPhase3.accept((ClassVisitor)reversedChainPhase3, 4);
                    context.setCurrentBytecode(writerPhase3.toByteArray());
                }
            }
            if (hasCustomAdapter) {
                ClassAdapterFactory factory = this.m_configHelper.getCustomAdapter(classInfo);
                ClassReader reader = new ClassReader(context.getCurrentBytecode());
                ClassWriter writer = new ClassWriter(reader, 1);
                ClassAdapter adapter = factory.create((ClassVisitor)writer, context.getLoader());
                reader.accept((ClassVisitor)adapter, 4);
                context.setCurrentBytecode(writer.toByteArray());
            }
            if (isDsoAdaptable) {
                ClassReader dsoReader = new ClassReader(context.getCurrentBytecode());
                ClassWriter dsoWriter = new ClassWriter(dsoReader, 1);
                ClassAdapter dsoVisitor = this.m_configHelper.createClassAdapterFor(dsoWriter, classInfo, this.m_logger, loader);
                try {
                    dsoReader.accept((ClassVisitor)dsoVisitor, 4);
                    context.setCurrentBytecode(dsoWriter.toByteArray());
                }
                catch (TCLogicalSubclassNotPortableException e) {
                    ArrayList<String> l = new ArrayList<String>(1);
                    l.add(e.getSuperClassName());
                    this.m_logger.subclassOfLogicallyManagedClasses(e.getClassName(), l);
                }
                String[] missingRoots = this.m_configHelper.getMissingRootDeclarations(classInfo);
                for (int i = 0; i < missingRoots.length; ++i) {
                    String MESSAGE = "The root expression ''{0}'' meant for the class ''{1}'' has no effect, make sure that it is a valid expression and that it is spelled correctly.";
                    Object[] info = new Object[]{missingRoots[i], classInfo.getName()};
                    String message = MessageFormat.format(MESSAGE, info);
                    consoleLogger.warn((Object)message);
                }
            }
            if ((context.isAdvised() || isDsoAdaptable) && ClassInfoHelper.implementsInterface((ClassInfo)classInfo, (String)"java.io.Serializable")) {
                ClassReader readerPhase3 = new ClassReader(context.getCurrentBytecode());
                ClassWriter writerPhase3 = new ClassWriter(readerPhase3, 1);
                readerPhase3.accept((ClassVisitor)new SafeSerialVersionUIDAdder((ClassVisitor)writerPhase3), 4);
                context.setCurrentBytecode(writerPhase3.toByteArray());
            }
            AdaptedClassDumper.INSTANCE.write(className, context.getCurrentBytecode());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new WrappedRuntimeException(t);
        }
    }

    private boolean isInstrumentedByDSO(ClassInfo classInfo) {
        ClassInfo[] interfaces = classInfo.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().equals("com.tc.object.bytecode.TransparentAccess")) continue;
            return true;
        }
        return false;
    }

    private static boolean classFilter(Set definitions, ExpressionContext[] ctxs, ClassInfo classInfo) {
        if (classInfo.isInterface()) {
            return true;
        }
        Iterator defs = definitions.iterator();
        while (defs.hasNext()) {
            if (DefaultWeavingStrategy.classFilter((SystemDefinition)defs.next(), ctxs, classInfo)) continue;
            return false;
        }
        return true;
    }

    private static boolean classFilter(SystemDefinition definition, ExpressionContext[] ctxs, ClassInfo classInfo) {
        if (classInfo.isInterface()) {
            return true;
        }
        String className = classInfo.getName();
        if (definition.inExcludePackage(className)) {
            return true;
        }
        if (!definition.inIncludePackage(className)) {
            return true;
        }
        if (definition.isAdvised(ctxs)) {
            return false;
        }
        if (definition.hasMixin(ctxs)) {
            return false;
        }
        if (definition.hasIntroducedInterface(ctxs)) {
            return false;
        }
        return !definition.inPreparePackage(className);
    }

    private static boolean classFilterFor(Set definitions, ExpressionContext[] ctxs) {
        Iterator defs = definitions.iterator();
        while (defs.hasNext()) {
            if (DefaultWeavingStrategy.classFilterFor((SystemDefinition)defs.next(), ctxs)) continue;
            return false;
        }
        return true;
    }

    private static boolean classFilterFor(SystemDefinition definition, ExpressionContext[] ctxs) {
        return !definition.isAdvised(ctxs);
    }

    private static boolean hasPointcut(Set definitions, ExpressionContext ctx) {
        Iterator defs = definitions.iterator();
        while (defs.hasNext()) {
            if (!DefaultWeavingStrategy.hasPointcut((SystemDefinition)defs.next(), ctx)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasPointcut(SystemDefinition definition, ExpressionContext ctx) {
        return definition.hasPointcut(ctx);
    }

    static {
        InitialClassDumper initialClassDumper = InitialClassDumper.INSTANCE;
        consoleLogger = CustomerLogging.getConsoleLogger();
    }
}

