/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.loaders;

import com.tc.asm.ClassReader;
import com.tc.asm.ClassVisitor;
import com.tc.asm.ClassWriter;
import com.tc.object.ClientObjectManager;
import com.tc.object.bytecode.Manager;
import com.tc.object.bytecode.ManagerImpl;
import com.tc.object.bytecode.hook.impl.ClassProcessorHelper;
import com.tc.object.bytecode.hook.impl.DSOContextImpl;
import com.tc.object.bytecode.hook.impl.PreparedComponentsFromL2Connection;
import com.tc.object.config.DSOClientConfigHelper;
import com.tc.object.loaders.ClassProvider;
import com.tc.object.loaders.NamedClassLoader;
import com.tc.object.loaders.StandardClassProvider;
import com.tc.object.tx.ClientTransactionManager;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class IsolationClassLoader
extends URLClassLoader
implements NamedClassLoader {
    private static final ClassLoader SYSTEM_LOADER = ClassLoader.getSystemClassLoader();
    private final Manager manager;
    private final DSOClientConfigHelper config;
    private final Map onLoadErrors;
    private final StandardClassProvider classProvider;
    private final Map adapters = new HashMap();

    public IsolationClassLoader(DSOClientConfigHelper config, PreparedComponentsFromL2Connection connectionComponents) {
        this(config, true, null, null, connectionComponents);
    }

    public IsolationClassLoader(DSOClientConfigHelper config, ClientObjectManager objectManager, ClientTransactionManager txManager) {
        this(config, false, objectManager, txManager, null);
    }

    private IsolationClassLoader(DSOClientConfigHelper config, boolean startClient, ClientObjectManager objectManager, ClientTransactionManager txManager, PreparedComponentsFromL2Connection connectionComponents) {
        super(IsolationClassLoader.getSystemURLS(), (ClassLoader)null);
        this.config = config;
        this.classProvider = new StandardClassProvider();
        this.manager = this.createManager(startClient, objectManager, txManager, config, connectionComponents);
        this.onLoadErrors = new HashMap();
    }

    public void init() {
        this.manager.initForTests();
        ClassProcessorHelper.setContext(this, DSOContextImpl.createContext(this.config, this.classProvider, this.manager));
    }

    private static URL[] getSystemURLS() {
        return ((URLClassLoader)SYSTEM_LOADER).getURLs();
    }

    private Manager createManager(boolean startClient, ClientObjectManager objectManager, ClientTransactionManager txManager, DSOClientConfigHelper theConfig, PreparedComponentsFromL2Connection connectionComponents) {
        this.classProvider.registerNamedLoader(this);
        return new ManagerImpl(startClient, objectManager, txManager, theConfig, (ClassProvider)this.classProvider, connectionComponents, false);
    }

    public void stop() {
        this.manager.stop();
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        this.throwIfNeeded(name);
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (name.startsWith("com.tc.")) {
            return SYSTEM_LOADER.loadClass(name);
        }
        if (this.adapters.containsKey(name)) {
            System.out.println("***** using adapter!  name=[" + name + "]");
            return this.adaptClass(name);
        }
        return super.loadClass(name);
    }

    private Class adaptClass(String name) throws ClassNotFoundException {
        byte[] orig = this.getBytes(name);
        ClassReader cr = new ClassReader(orig);
        ClassWriter cw = new ClassWriter(cr, 1);
        Class adapterClass = (Class)this.adapters.get(name);
        try {
            Constructor cstr = adapterClass.getConstructor(ClassVisitor.class);
            cstr.setAccessible(true);
            ClassVisitor cv = (ClassVisitor)cstr.newInstance(cw);
            cr.accept(cv, 4);
            byte[] adapted = cw.toByteArray();
            return this.defineClass(name, adapted, 0, adapted.length);
        }
        catch (Exception e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    private byte[] getBytes(String name) throws ClassNotFoundException {
        InputStream is = super.getResourceAsStream(name.replace('.', '/').concat(".class"));
        if (is == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(name, ioe);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private void throwIfNeeded(String name) throws ClassNotFoundException {
        String t = (String)this.onLoadErrors.get(name);
        if (t != null) {
            ClassNotFoundException rv = new ClassNotFoundException(t);
            throw rv;
        }
    }

    public String __tc_getClassLoaderName() {
        return IsolationClassLoader.loaderName();
    }

    public static String loaderName() {
        return IsolationClassLoader.class.getName();
    }

    public void __tc_setClassLoaderName(String name) {
        throw new AssertionError();
    }

    public void throwOnLoad(String className, String errorMessage) {
        this.onLoadErrors.put(className, errorMessage);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        this.throwIfNeeded(name);
        return super.findClass(name);
    }

    public void addAdapter(String name, Class adapterClass) {
        Class prev = this.adapters.put(name, adapterClass);
        if (prev != null) {
            throw new AssertionError((Object)("adapter already exists for " + name));
        }
    }
}

