/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.loaders;

import com.tc.asm.ClassAdapter;
import com.tc.asm.ClassVisitor;
import com.tc.asm.MethodVisitor;
import com.tc.asm.Opcodes;
import com.tc.asm.commons.AdviceAdapter;
import com.tc.object.bytecode.ByteCodeUtil;

public class StandardClassLoaderAdapter
extends ClassAdapter
implements Opcodes {
    private static final String LOADER_NAME = "__tc_loaderName";
    private final String loaderName;
    private final String sysProp;
    private boolean hasStaticInit;
    private String className;

    public StandardClassLoaderAdapter(ClassVisitor cv, String loaderName, String sysProp) {
        super(cv);
        this.loaderName = loaderName;
        this.sysProp = sysProp;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        interfaces = ByteCodeUtil.addInterfaces((String[])interfaces, (String[])new String[]{"com/tc/object/loaders/NamedClassLoader"});
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitEnd() {
        this.addNamedClassLoaderMethods();
        super.visitField(4122, LOADER_NAME, "Ljava/lang/String;", null, null);
        if (!this.hasStaticInit) {
            MethodVisitor mv = super.visitMethod(8, "<clinit>", "()V", null, null);
            mv.visitCode();
            this.setupLoaderName(mv);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        super.visitEnd();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ("<clinit>".equals(name)) {
            this.hasStaticInit = true;
            return new StaticInitAdapter(mv, access, name, desc);
        }
        return mv;
    }

    private void addNamedClassLoaderMethods() {
        MethodVisitor mv = super.visitMethod(4113, "__tc_getClassLoaderName", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, this.className, LOADER_NAME, "Ljava/lang/String;");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = super.visitMethod(4113, "__tc_setClassLoaderName", "(Ljava/lang/String;)V", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/lang/AssertionError");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)"Classloader names cannot be set programmatically. Please use -Dcom.tc.loader.system.name to specify a custom name to the Standard Class Loader");
        mv.visitMethodInsn(183, "java/lang/AssertionError", "<init>", "(Ljava/lang/Object;)V");
        mv.visitInsn(191);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void setupLoaderName(MethodVisitor mv) {
        mv.visitLdcInsn((Object)this.sysProp);
        mv.visitLdcInsn((Object)this.loaderName);
        mv.visitMethodInsn(184, "java/lang/System", "getProperty", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;");
        mv.visitFieldInsn(179, this.className, LOADER_NAME, "Ljava/lang/String;");
    }

    private class StaticInitAdapter
    extends AdviceAdapter {
        public StaticInitAdapter(MethodVisitor mv, int access, String name, String desc) {
            super(mv, access, name, desc);
        }

        protected void onMethodEnter() {
        }

        protected void onMethodExit(int opcode) {
            if (177 == opcode) {
                StandardClassLoaderAdapter.this.setupLoaderName((MethodVisitor)this);
            }
        }
    }
}

