/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode.hook.impl;

import [Ljava.lang.String;;
import com.tc.object.bytecode.hook.impl.ClassProcessorHelper;
import com.tc.object.bytecode.hook.impl.Util;
import com.tc.text.Banner;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class SessionsHelper {
    private static final String TC_SESSION_CLASSPATH = "tc.session.classpath";

    private SessionsHelper() {
    }

    private static String[] getSessionsPaths() {
        ArrayList<String> classPaths = new ArrayList<String>();
        String tcSessionCP = System.getProperty(TC_SESSION_CLASSPATH);
        if (tcSessionCP != null) {
            tcSessionCP = tcSessionCP.replace('\\', '/');
            String[] paths = tcSessionCP.split(File.pathSeparator);
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                if (path.endsWith(".jar")) {
                    classPaths.add(path);
                    continue;
                }
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                classPaths.add(path);
            }
        } else {
            File installRoot = ClassProcessorHelper.getTCInstallDir(false);
            File sessionsLib = new File(installRoot, "lib");
            File tcSessionLib = new File(sessionsLib, "session");
            File tcSessionJar = new File(tcSessionLib, "tc-session.jar");
            if (tcSessionJar.exists() && tcSessionJar.isFile() && tcSessionJar.canRead()) {
                classPaths.add(tcSessionJar.getAbsolutePath());
            } else {
                Banner.errorBanner((String)(tcSessionJar.getAbsolutePath() + " does not exist, or is not an accessible directory"));
                Util.exit();
            }
        }
        return classPaths.toArray(new String[classPaths.size()]);
    }

    public static void injectClasses(ClassLoader loader) {
        String[] sessionsClasspaths = SessionsHelper.getSessionsPaths();
        if (!SessionsHelper.invokeAddURLMethodIfPresent(loader, sessionsClasspaths) && !SessionsHelper.invokeAddPathsMethodIfPresent(loader, sessionsClasspaths)) {
            AssertionError ae = new AssertionError((Object)("SessionsHelper.injectClasses() cannot recognize classloader of type: " + loader.getClass().getName()));
            throw ae;
        }
    }

    private static boolean invokeAddPathsMethodIfPresent(ClassLoader loader, String[] classPaths) {
        try {
            Method m = loader.getClass().getDeclaredMethod("addPaths", String;.class);
            m.setAccessible(true);
            m.invoke((Object)loader, new Object[]{classPaths});
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
    }

    private static boolean invokeAddURLMethodIfPresent(ClassLoader loader, String[] classPaths) {
        try {
            Method m = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            m.setAccessible(true);
            for (int pos = 0; pos < classPaths.length; ++pos) {
                m.invoke((Object)loader, new URL("file", "", classPaths[pos]));
            }
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
    }
}

