/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.model;

import java.lang.reflect.Method;
import org.jboss.interceptor.model.InterceptionModel;
import org.jboss.interceptor.model.InterceptionModelImpl;
import org.jboss.interceptor.model.InterceptionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptionModelBuilder<T, I> {
    private InterceptionModelImpl<T, I> interceptionModel;
    private T interceptedEntity;

    private InterceptionModelBuilder(T interceptedEntity) {
        this.interceptedEntity = interceptedEntity;
        this.interceptionModel = new InterceptionModelImpl(interceptedEntity);
    }

    public static <T, I> InterceptionModelBuilder<T, I> newBuilderFor(T entity, Class<I> clazz) {
        return new InterceptionModelBuilder<T, I>(entity);
    }

    public T getInterceptedEntity() {
        return this.interceptedEntity;
    }

    public InterceptionModel<T, I> build() {
        return this.interceptionModel;
    }

    public MethodInterceptorDescriptor interceptAll() {
        return new MethodInterceptorDescriptor(null, InterceptionType.values());
    }

    public MethodInterceptorDescriptor interceptAroundInvoke(Method m) {
        return new MethodInterceptorDescriptor(m, InterceptionType.AROUND_INVOKE);
    }

    public MethodInterceptorDescriptor interceptAroundTimeout(Method m) {
        return new MethodInterceptorDescriptor(m, InterceptionType.AROUND_TIMEOUT);
    }

    public MethodInterceptorDescriptor interceptPostConstruct() {
        return new MethodInterceptorDescriptor(null, InterceptionType.POST_CONSTRUCT);
    }

    public MethodInterceptorDescriptor interceptPreDestroy() {
        return new MethodInterceptorDescriptor(null, InterceptionType.PRE_DESTROY);
    }

    public MethodInterceptorDescriptor interceptPrePassivate() {
        return new MethodInterceptorDescriptor(null, InterceptionType.PRE_PASSIVATE);
    }

    public MethodInterceptorDescriptor interceptPostActivate() {
        return new MethodInterceptorDescriptor(null, InterceptionType.POST_ACTIVATE);
    }

    public void ignoreGlobalInterceptors(Method m) {
        this.interceptionModel.setIgnoresGlobals(m, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class MethodInterceptorDescriptor {
        private Method method;
        private InterceptionType[] interceptionTypes;

        public MethodInterceptorDescriptor(Method m, InterceptionType ... interceptionType) {
            this.method = m;
            this.interceptionTypes = interceptionType;
        }

        public void with(I ... interceptors) {
            for (InterceptionType interceptionType : this.interceptionTypes) {
                InterceptionModelBuilder.this.interceptionModel.appendInterceptors(interceptionType, this.method, interceptors);
            }
        }
    }
}

