/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.zookeeper;

import java.io.File;
import org.apache.log4j.PropertyConfigurator;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ZooKeeper
extends Thread {
    private static Log logger = LogFactory.getLog(ZooKeeper.class);
    public static final String DEFAULT_ZOOKEEPER_PORT = "2181";
    public static final String DEFAULT_ZOOKEEPER_SNAPSHOT_DIRECTORY = "~/snapshotZoo";
    private String[] conf = new String[2];
    private NIOServerCnxn.Factory cnxnFactory;

    public ZooKeeper() {
        this.conf[0] = DEFAULT_ZOOKEEPER_PORT;
        this.conf[1] = DEFAULT_ZOOKEEPER_SNAPSHOT_DIRECTORY;
    }

    public ZooKeeper(String port, String snapshotDirectory) {
        this.conf[0] = port;
        this.conf[1] = snapshotDirectory;
    }

    public void startup() {
        this.deleteSnapshotDirectory();
        this.start();
    }

    private void deleteSnapshotDirectory() {
        File snapshotDir = new File(this.conf[1]);
        logger.info((Object)"Deleting snapshot directory", new Object[0]);
        try {
            this.deleteDirectory(snapshotDir);
        }
        catch (Exception e) {
            logger.info((Object)"Impossible to delete snapshot directory, maybe it does not exists", new Object[0]);
        }
    }

    private void deleteDirectory(File f) {
        if (f.isFile()) {
            logger.error((Object)"Cannot delete this directory {0} because it is a file", new Object[]{f.getAbsolutePath()});
        } else {
            String rootPath = f.getAbsolutePath();
            File[] childList = f.listFiles();
            if (childList.length == 0) {
                f.delete();
            } else {
                for (int i = 0; i < childList.length; ++i) {
                    File child = childList[i];
                    if (child.isDirectory()) {
                        this.deleteDirectory(child);
                        continue;
                    }
                    this.deleteFile(child);
                }
                f.delete();
            }
        }
    }

    private void deleteFile(File f) {
        if (f.isDirectory()) {
            logger.error((Object)"Cannot delete this file {0} because it is a directory", new Object[]{f.getAbsolutePath()});
        } else {
            f.delete();
        }
    }

    public void shutdown() {
        logger.info((Object)"Stopping Zookeeper", new Object[0]);
        this.cnxnFactory.shutdown();
    }

    public void run() {
        PropertyConfigurator.configure(this.getClass().getClassLoader().getResource("log4j.properties"));
        try {
            logger.info((Object)"Zookeeper starting on port {0}", new Object[]{this.conf[0]});
            ZooKeeperServer zkServer = new ZooKeeperServer();
            ServerConfig config = new ServerConfig();
            config.parse(this.conf);
            FileTxnSnapLog ftxn = new FileTxnSnapLog(new File(config.getDataLogDir()), new File(config.getDataDir()));
            zkServer.setTxnLogFactory(ftxn);
            zkServer.setTickTime(config.getTickTime());
            zkServer.setMinSessionTimeout(config.getMinSessionTimeout());
            zkServer.setMaxSessionTimeout(config.getMaxSessionTimeout());
            this.cnxnFactory = new NIOServerCnxn.Factory(config.getClientPortAddress(), config.getMaxClientCnxns());
            this.cnxnFactory.startup(zkServer);
            this.cnxnFactory.join();
            if (zkServer.isRunning()) {
                zkServer.shutdown();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while starting ZooKeeper", new Object[0]);
            e.printStackTrace();
        }
    }
}

