/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.CreateResponse;
import org.apache.zookeeper.proto.ExistsRequest;
import org.apache.zookeeper.proto.ExistsResponse;
import org.apache.zookeeper.proto.GetACLRequest;
import org.apache.zookeeper.proto.GetACLResponse;
import org.apache.zookeeper.proto.GetChildren2Request;
import org.apache.zookeeper.proto.GetChildren2Response;
import org.apache.zookeeper.proto.GetChildrenRequest;
import org.apache.zookeeper.proto.GetChildrenResponse;
import org.apache.zookeeper.proto.GetDataRequest;
import org.apache.zookeeper.proto.GetDataResponse;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.SetACLResponse;
import org.apache.zookeeper.proto.SetDataResponse;
import org.apache.zookeeper.proto.SetWatches;
import org.apache.zookeeper.proto.SyncRequest;
import org.apache.zookeeper.proto.SyncResponse;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.txn.CreateSessionTxn;
import org.apache.zookeeper.txn.ErrorTxn;

public class FinalRequestProcessor
implements RequestProcessor {
    private static final Logger LOG = Logger.getLogger(FinalRequestProcessor.class);
    ZooKeeperServer zks;

    public FinalRequestProcessor(ZooKeeperServer zks) {
        this.zks = zks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(Request request) {
        NIOServerCnxn.Factory scxn;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing request:: " + request);
        }
        long traceMask = 2L;
        if (request.type == 11) {
            traceMask = 128L;
        }
        if (LOG.isTraceEnabled()) {
            ZooTrace.logRequest(LOG, traceMask, 'E', request, "");
        }
        DataTree.ProcessTxnResult rc = null;
        List<ZooKeeperServer.ChangeRecord> list = this.zks.outstandingChanges;
        synchronized (list) {
            while (!this.zks.outstandingChanges.isEmpty() && this.zks.outstandingChanges.get((int)0).zxid <= request.zxid) {
                ZooKeeperServer.ChangeRecord cr = this.zks.outstandingChanges.remove(0);
                if (cr.zxid < request.zxid) {
                    LOG.warn("Zxid outstanding " + cr.zxid + " is less than current " + request.zxid);
                }
                if (this.zks.outstandingChangesForPath.get(cr.path) != cr) continue;
                this.zks.outstandingChangesForPath.remove(cr.path);
            }
            if (request.hdr != null) {
                rc = this.zks.getZKDatabase().processTxn(request.hdr, request.txn);
                if (request.type == -10) {
                    if (request.txn instanceof CreateSessionTxn) {
                        CreateSessionTxn cst = (CreateSessionTxn)request.txn;
                        this.zks.sessionTracker.addSession(request.sessionId, cst.getTimeOut());
                    } else {
                        LOG.warn("*****>>>>> Got " + request.txn.getClass() + " " + request.txn.toString());
                    }
                } else if (request.type == -11) {
                    this.zks.sessionTracker.removeSession(request.sessionId);
                }
            }
            if (Request.isQuorum(request.type)) {
                this.zks.getZKDatabase().addCommittedProposal(request);
            }
        }
        if (request.hdr != null && request.hdr.getType() == -11 && (scxn = this.zks.getServerCnxnFactory()) != null && request.cnxn == null) {
            scxn.closeSession(request.sessionId);
            return;
        }
        if (request.cnxn == null) {
            return;
        }
        ServerCnxn cnxn = request.cnxn;
        String lastOp = "NA";
        this.zks.decInProcess();
        KeeperException.Code err = KeeperException.Code.OK;
        Record rsp = null;
        boolean closeSession = false;
        try {
            if (request.hdr != null && request.hdr.getType() == -1) {
                throw KeeperException.create(KeeperException.Code.get(((ErrorTxn)request.txn).getErr()));
            }
            KeeperException ke = request.getException();
            if (ke != null) {
                throw ke;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(request);
            }
            switch (request.type) {
                case 11: {
                    this.zks.serverStats().updateLatency(request.createTime);
                    lastOp = "PING";
                    ((NIOServerCnxn.CnxnStats)cnxn.getStats()).updateForResponse(request.cxid, request.zxid, lastOp, request.createTime, System.currentTimeMillis());
                    cnxn.sendResponse(new ReplyHeader(-2, this.zks.getZKDatabase().getDataTreeLastProcessedZxid(), 0), null, "response");
                    return;
                }
                case -10: {
                    this.zks.serverStats().updateLatency(request.createTime);
                    lastOp = "SESS";
                    ((NIOServerCnxn.CnxnStats)cnxn.getStats()).updateForResponse(request.cxid, request.zxid, lastOp, request.createTime, System.currentTimeMillis());
                    cnxn.finishSessionInit(true);
                    return;
                }
                case 1: {
                    lastOp = "CREA";
                    rsp = new CreateResponse(rc.path);
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 2: {
                    lastOp = "DELE";
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 5: {
                    lastOp = "SETD";
                    rsp = new SetDataResponse(rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 7: {
                    lastOp = "SETA";
                    rsp = new SetACLResponse(rc.stat);
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case -11: {
                    lastOp = "CLOS";
                    closeSession = true;
                    err = KeeperException.Code.get(rc.err);
                    break;
                }
                case 9: {
                    lastOp = "SYNC";
                    SyncRequest syncRequest = new SyncRequest();
                    ZooKeeperServer.byteBuffer2Record(request.request, syncRequest);
                    rsp = new SyncResponse(syncRequest.getPath());
                    break;
                }
                case 3: {
                    lastOp = "EXIS";
                    ExistsRequest existsRequest = new ExistsRequest();
                    ZooKeeperServer.byteBuffer2Record(request.request, existsRequest);
                    String path = existsRequest.getPath();
                    if (path.indexOf(0) != -1) {
                        throw new KeeperException.BadArgumentsException();
                    }
                    Stat stat = this.zks.getZKDatabase().statNode(path, existsRequest.getWatch() ? cnxn : null);
                    rsp = new ExistsResponse(stat);
                    break;
                }
                case 4: {
                    Long aclL;
                    lastOp = "GETD";
                    GetDataRequest getDataRequest = new GetDataRequest();
                    ZooKeeperServer.byteBuffer2Record(request.request, getDataRequest);
                    DataNode n = this.zks.getZKDatabase().getNode(getDataRequest.getPath());
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    DataNode dataNode = n;
                    synchronized (dataNode) {
                        aclL = n.acl;
                    }
                    PrepRequestProcessor.checkACL(this.zks, this.zks.getZKDatabase().convertLong(aclL), 1, request.authInfo);
                    Stat stat = new Stat();
                    byte[] b = this.zks.getZKDatabase().getData(getDataRequest.getPath(), stat, getDataRequest.getWatch() ? cnxn : null);
                    rsp = new GetDataResponse(b, stat);
                    break;
                }
                case 101: {
                    lastOp = "SETW";
                    SetWatches setWatches = new SetWatches();
                    request.request.rewind();
                    ZooKeeperServer.byteBuffer2Record(request.request, setWatches);
                    long relativeZxid = setWatches.getRelativeZxid();
                    this.zks.getZKDatabase().setWatches(relativeZxid, setWatches.getDataWatches(), setWatches.getExistWatches(), setWatches.getChildWatches(), cnxn);
                    break;
                }
                case 6: {
                    lastOp = "GETA";
                    GetACLRequest getACLRequest = new GetACLRequest();
                    ZooKeeperServer.byteBuffer2Record(request.request, getACLRequest);
                    Stat stat = new Stat();
                    List<ACL> acl = this.zks.getZKDatabase().getACL(getACLRequest.getPath(), stat);
                    rsp = new GetACLResponse(acl, stat);
                    break;
                }
                case 8: {
                    Long aclG;
                    lastOp = "GETC";
                    GetChildrenRequest getChildrenRequest = new GetChildrenRequest();
                    ZooKeeperServer.byteBuffer2Record(request.request, getChildrenRequest);
                    DataNode n = this.zks.getZKDatabase().getNode(getChildrenRequest.getPath());
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    DataNode stat = n;
                    synchronized (stat) {
                        aclG = n.acl;
                    }
                    PrepRequestProcessor.checkACL(this.zks, this.zks.getZKDatabase().convertLong(aclG), 1, request.authInfo);
                    List<String> children = this.zks.getZKDatabase().getChildren(getChildrenRequest.getPath(), null, getChildrenRequest.getWatch() ? cnxn : null);
                    rsp = new GetChildrenResponse(children);
                    break;
                }
                case 12: {
                    Long aclG;
                    lastOp = "GETC";
                    GetChildren2Request getChildren2Request = new GetChildren2Request();
                    ZooKeeperServer.byteBuffer2Record(request.request, getChildren2Request);
                    Stat stat = new Stat();
                    DataNode n = this.zks.getZKDatabase().getNode(getChildren2Request.getPath());
                    if (n == null) {
                        throw new KeeperException.NoNodeException();
                    }
                    DataNode b = n;
                    synchronized (b) {
                        aclG = n.acl;
                    }
                    PrepRequestProcessor.checkACL(this.zks, this.zks.getZKDatabase().convertLong(aclG), 1, request.authInfo);
                    List<String> children = this.zks.getZKDatabase().getChildren(getChildren2Request.getPath(), stat, getChildren2Request.getWatch() ? cnxn : null);
                    rsp = new GetChildren2Response(children, stat);
                    break;
                }
            }
        }
        catch (KeeperException.SessionMovedException e) {
            cnxn.sendCloseSession();
            return;
        }
        catch (KeeperException e) {
            err = e.code();
        }
        catch (Exception e) {
            LOG.error("Failed to process " + request, e);
            StringBuilder sb = new StringBuilder();
            ByteBuffer bb = request.request;
            bb.rewind();
            while (bb.hasRemaining()) {
                sb.append(Integer.toHexString(bb.get() & 0xFF));
            }
            LOG.error("Dumping request buffer: 0x" + sb.toString());
            err = KeeperException.Code.MARSHALLINGERROR;
        }
        ReplyHeader hdr = new ReplyHeader(request.cxid, request.zxid, err.intValue());
        this.zks.serverStats().updateLatency(request.createTime);
        ((NIOServerCnxn.CnxnStats)cnxn.getStats()).updateForResponse(request.cxid, request.zxid, lastOp, request.createTime, System.currentTimeMillis());
        try {
            cnxn.sendResponse(hdr, rsp, "response");
            if (closeSession) {
                cnxn.sendCloseSession();
            }
        }
        catch (IOException e) {
            LOG.error("FIXMSG", e);
        }
    }

    public void shutdown() {
        LOG.info("shutdown of request processor complete");
    }
}

