/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999-2007 Bull S.A.S.
 * Contact: jonas-team@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Activator.java 2841 2008-04-11 14:51:02Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.ee.deploy.impl.osgi;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.ow2.util.archive.api.IArchiveManager;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.impl.deployer.DeployerManager;

/**
 * Activator which registers DeployerManager, ArchiveManager and OSGi Deployer
 * services.
 * @author Francois Fornaciari
 */
public class Activator implements BundleActivator {

    /**
     * Called when this bundle is started so the Framework can perform the
     * bundle-specific activities necessary to start this bundle. This method
     * can be used to register services or to allocate any resources that this
     * bundle needs.
     * @param context The execution context of the bundle being started.
     */
    public void start(final BundleContext bc) {

        // Create the OSGi deployer
        OSGiDeployer osgiDeployer = new OSGiDeployer();
        osgiDeployer.setBundleContext(bc);

        // Create a new deployer manager
        DeployerManager deployerManager = new DeployerManager();

        // Register the deployer on the deployer manager
        deployerManager.register(osgiDeployer);

        // Register the deployer manager and the deployer as an OSGi service
        bc.registerService(IDeployerManager.class.getName(), deployerManager, null);
        bc.registerService(IDeployer.class.getName(), osgiDeployer, null);

        // Add also the archive manager
        ArchiveManager archiveManager = ArchiveManager.getInstance();
        bc.registerService(IArchiveManager.class.getName(), archiveManager, null);

    }

    /**
     * Called when this bundle is stopped so the Framework can perform the
     * bundle-specific activities necessary to stop the bundle.
     * @param context The execution context of the bundle being stopped.
     */
    public void stop(final BundleContext bc) {
        // Do nothing
    }

}
