/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.car.impl.xml.merge;

import java.util.jar.Attributes;
import org.ow2.util.archive.api.IArchiveMetadata;
import org.ow2.util.ee.metadata.car.api.ICarClassMetadata;
import org.ow2.util.ee.metadata.car.impl.CarDeployableMetadata;
import org.ow2.util.ee.metadata.car.impl.xml.struct.CAR;
import org.ow2.util.ee.metadata.common.api.interfaces.IEnvironmentRefAccessor;
import org.ow2.util.ee.metadata.common.impl.xml.merge.MetadataMerge;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CarMetadataMerge
extends MetadataMerge {
    private static final Log LOGGER = LogFactory.getLog(CarMetadataMerge.class);
    private CarDeployableMetadata carDeployableMetadata;

    public CarMetadataMerge(CarDeployableMetadata carDeployableMetadata) {
        this.carDeployableMetadata = carDeployableMetadata;
    }

    public void merge(CAR car) {
        this.applyJndiEnvironmentRefsGroup(car, (IEnvironmentRefAccessor)this.carDeployableMetadata);
        String callbackHandler = car.getCallbackHandler();
        if (callbackHandler != null) {
            ICarClassMetadata carClassMetadata = this.getClassMetadata(callbackHandler.replace('.', '/'));
            if (carClassMetadata == null) {
                LOGGER.error((Object)("The callback handler class '" + callbackHandler + "' defined in xml was not found."), new Object[0]);
            } else {
                carClassMetadata.setCallbackHandler(true);
            }
        }
    }

    public ICarClassMetadata getClassMetadata(String className) {
        return this.carDeployableMetadata.getCarClassMetadata(className);
    }

    public String findDefaultClassForEnvironment(IEnvironmentRefAccessor env) {
        IArchiveMetadata metadata = this.carDeployableMetadata.getDeployable().getArchive().getMetadata();
        String mainClassName = metadata.get(Attributes.Name.MAIN_CLASS.toString());
        if (mainClassName == null && (mainClassName = metadata.get("main-class")) != null) {
            LOGGER.warn((Object)("The '" + Attributes.Name.MAIN_CLASS.toString() + "' attribute is not written correctly in the archive '" + this.carDeployableMetadata.getDeployable().getArchive() + "'"), new Object[0]);
        }
        if (mainClassName == null) {
            throw new IllegalStateException("No '" + Attributes.Name.MAIN_CLASS.toString() + "' attribute found in the archive '" + this.carDeployableMetadata.getDeployable().getArchive() + "'");
        }
        return CarMetadataMerge.encode((String)mainClassName);
    }
}

