/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.war.impl.xml.parsing;

import java.net.URL;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.ParsingException;
import org.ow2.util.ee.metadata.war.impl.xml.parsing.AbsWebLoader;
import org.ow2.util.ee.metadata.war.impl.xml.parsing.WAREntityResolver;
import org.ow2.util.ee.metadata.war.impl.xml.struct.WAR;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class WARDeploymentDescLoader
extends AbsWebLoader {
    private static Log logger = LogFactory.getLog(WARDeploymentDescLoader.class);

    protected WARDeploymentDescLoader(URL url) {
        super(url);
    }

    public static WAR loadDeploymentDescriptor(URL url) throws ParsingException {
        logger.debug((Object)"Analyzing url {0}", new Object[]{url});
        WARDeploymentDescLoader warDeploymentDescLoader = new WARDeploymentDescLoader(url);
        warDeploymentDescLoader.parse();
        return warDeploymentDescLoader.getWAR();
    }

    public void parse() throws ParsingException {
        Document document = null;
        try {
            document = DocumentParser.getDocument((URL)this.getURL(), (boolean)false, (EntityResolver)((Object)new WAREntityResolver()));
        }
        catch (DocumentParserException e) {
            throw new ParsingException("Cannot parse the url", (Throwable)e);
        }
        Element webAppRootElement = document.getDocumentElement();
        if (webAppRootElement.getNamespaceURI() != null) {
            this.defineXMLNS(webAppRootElement);
        }
        this.analyzeEnvironment(webAppRootElement, this.getWAR());
        this.analyzeServlets(webAppRootElement);
        this.analyzeListeners(webAppRootElement);
        this.analyzeFilters(webAppRootElement);
        String metadataComplete = webAppRootElement.getAttribute("metadata-complete");
        if (metadataComplete.equals("true")) {
            this.getWAR().setMetadataComplete(true);
        }
    }
}

