/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    private static final int BUFFER_SIZE = 4096;
    private static Log logger = LogFactory.getLog(FileUtils.class);
    private static final String DATE_FORMAT = "_yyyy.MM.dd-HH.mm.ss";

    private FileUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unpack(JarFile packedJar, File dest) throws FileUtilsException {
        JarEntry entry = null;
        Enumeration<JarEntry> entries = packedJar.entries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            File entryFile = new File(dest, entry.getName());
            if (entry.isDirectory()) {
                if (entryFile.exists() || entryFile.mkdirs()) continue;
                String err = "Can not create directory " + entryFile + ", Check the write access.";
                throw new FileUtilsException(err);
            }
            entryFile.getParentFile().mkdirs();
            InputStream is = null;
            try {
                is = packedJar.getInputStream(entry);
                FileUtils.dump(is, entryFile);
            }
            catch (IOException ioe) {
                try {
                    throw new FileUtilsException("Cannot get inputstream of entry '" + entry + "' of file '" + packedJar + "'.");
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException ioe2) {
                        logger.error((Object)"Cannot close input stream", new Object[]{ioe2});
                    }
                    throw throwable;
                }
            }
            try {
                is.close();
            }
            catch (IOException ioe) {
                logger.error((Object)"Cannot close input stream", new Object[]{ioe});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(InputStream in, File entryFile) throws FileUtilsException {
        try {
            FileOutputStream out = new FileOutputStream(entryFile);
            int n = 0;
            try {
                byte[] buffer = new byte[4096];
                n = in.read(buffer);
                while (n > 0) {
                    out.write(buffer, 0, n);
                    n = in.read(buffer);
                }
                out.flush();
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            String err = "Error while unpacking entry " + entryFile + " : ";
            throw new FileUtilsException(err, e);
        }
    }

    public static void print(File txtFile, PrintWriter printWriter) throws FileUtilsException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(txtFile)));
            String line = bufferedReader.readLine();
            while (line != null) {
                printWriter.println(line);
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            throw new FileUtilsException("Error while printing", e);
        }
    }

    public static void print(File txtFile) throws FileUtilsException {
        FileUtils.print(txtFile, new PrintWriter(System.out, true));
    }

    public static void copyFile(String src, String dest) throws FileUtilsException {
        FileUtils.copyFile(new File(src), new File(dest));
    }

    /*
     * Loose catch block
     */
    public static void copyFile(File src, File dest) throws FileUtilsException {
        block17: {
            File newDest = null;
            if (dest.isDirectory()) {
                logger.debug((Object)"Copy a file to a directory, append source filename to directory.", new Object[0]);
                newDest = new File(dest, src.getName());
            } else {
                newDest = dest;
            }
            FileInputStream fIn = null;
            FileOutputStream fOut = null;
            AbstractInterruptibleChannel sourceFC = null;
            AbstractInterruptibleChannel targetFC = null;
            fIn = new FileInputStream(src);
            fOut = new FileOutputStream(newDest);
            sourceFC = fIn.getChannel();
            targetFC = fOut.getChannel();
            ((FileChannel)targetFC).transferFrom((ReadableByteChannel)((Object)sourceFC), 0L, ((FileChannel)sourceFC).size());
            ((FileChannel)targetFC).force(true);
            Object var9_7 = null;
            try {
                if (sourceFC != null) {
                    sourceFC.close();
                }
                if (targetFC != null) {
                    targetFC.close();
                }
                if (fOut != null) {
                    fOut.flush();
                    fOut.close();
                }
                if (fIn != null) {
                    fIn.close();
                }
                break block17;
            }
            catch (Exception e) {
                logger.error((Object)"Cannot close some i/o which are open.", new Object[]{e});
            }
            break block17;
            {
                catch (Exception e) {
                    throw new FileUtilsException("Error during copy file : " + src + " -> " + newDest, e);
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                try {
                    if (sourceFC != null) {
                        sourceFC.close();
                    }
                    if (targetFC != null) {
                        targetFC.close();
                    }
                    if (fOut != null) {
                        fOut.flush();
                        fOut.close();
                    }
                    if (fIn != null) {
                        fIn.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Cannot close some i/o which are open.", new Object[]{e});
                }
                throw throwable;
            }
        }
    }

    public static boolean delete(String path) {
        return FileUtils.delete(new File(path));
    }

    public static boolean delete(File f) {
        if (f.isFile()) {
            return f.delete();
        }
        File[] children = f.listFiles();
        if (children == null) {
            return f.delete();
        }
        boolean result = true;
        for (int i = 0; i < children.length; ++i) {
            result &= FileUtils.delete(children[i]);
        }
        return result && f.delete();
    }

    public static void copyDirectory(String src, String dest) throws FileUtilsException {
        FileUtils.copyDirectory(new File(src), new File(dest));
    }

    public static void copyDirectory(File src, File dest) throws FileUtilsException {
        File[] childs;
        if (!src.isDirectory()) {
            throw new IllegalArgumentException("Source '" + src + "' must be a directory");
        }
        if (!dest.exists()) {
            dest.mkdirs();
        }
        if ((childs = src.listFiles()) != null) {
            for (int i = 0; i < childs.length; ++i) {
                File child = childs[i];
                if (child.isFile()) {
                    FileUtils.copyFile(child, dest);
                    continue;
                }
                FileUtils.copyDirectory(child, new File(dest, child.getName()));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateAttributesInManifest(String jarName, Map<String, String> attributes) throws FileUtilsException {
        Manifest manifest;
        File file;
        block15: {
            file = new File(jarName);
            if (!file.exists()) {
                throw new FileUtilsException("The file '" + file + "' is not existing on the filesystem");
            }
            JarFile jarFile = null;
            manifest = null;
            try {
                try {
                    jarFile = new JarFile(file);
                    manifest = jarFile.getManifest();
                }
                catch (IOException e) {
                    throw new FileUtilsException("Error while using jar file " + file + "'", e);
                }
                Object var7_5 = null;
                if (jarFile == null) break block15;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (jarFile == null) throw throwable;
                try {
                    jarFile.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FileUtilsException("Error while closing jar file " + jarFile + "'", e);
                }
            }
            try {}
            catch (IOException e) {
                throw new FileUtilsException("Error while closing jar file " + jarFile + "'", e);
            }
            jarFile.close();
        }
        boolean manifestUpdated = false;
        if (manifest == null) {
            manifest = new Manifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            mainAttributes.putValue("Manifest-Version", "1.0");
            manifestUpdated = true;
        }
        Attributes manifestAttributes = manifest.getMainAttributes();
        Set<Map.Entry<String, String>> entries = attributes.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String attributeName = entry.getKey();
            String attributeValue = entry.getValue();
            String manifestAttributeValue = manifestAttributes.getValue(attributeName);
            if (attributeValue == null || attributeValue.equals(manifestAttributeValue)) continue;
            Attributes.Name manifestAttributeName = new Attributes.Name(attributeName);
            manifestAttributes.put(manifestAttributeName, attributeValue);
            manifestUpdated = true;
        }
        if (!manifestUpdated) {
            return;
        }
        File tmpJarFile = null;
        try {
            try {
                tmpJarFile = File.createTempFile("tmpGenICFile", ".jar");
                FileUtils.updateJarFile(file, manifest, tmpJarFile);
                FileUtils.copyFile(tmpJarFile, file);
            }
            catch (IOException e) {
                throw new FileUtilsException("Cannot create temporary file", e);
            }
            Object var15_20 = null;
            tmpJarFile.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var15_21 = null;
            tmpJarFile.delete();
            throw throwable;
        }
    }

    public static String lastModifiedFileName(File file) throws FileUtilsException {
        if (!file.exists()) {
            throw new FileUtilsException("Cannot get File '" + file + "'.");
        }
        Date lastModificationDate = new Date(file.lastModified());
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return file.getName().replaceAll("\\..{3}$", sdf.format(lastModificationDate) + "$0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateJarFile(File file, Manifest manifest, File tmpJarFile) throws FileUtilsException {
        FileOutputStream fileOS = null;
        try {
            fileOS = new FileOutputStream(tmpJarFile);
        }
        catch (FileNotFoundException e) {
            throw new FileUtilsException("Cannot create file output stream on the file '" + file + "'", e);
        }
        JarOutputStream fileJarOutputStream = null;
        try {
            fileJarOutputStream = new JarOutputStream((OutputStream)fileOS, manifest);
        }
        catch (IOException e) {
            throw new FileUtilsException("Cannot create Jar OutputStream", e);
        }
        JarFile jarFile = null;
        try {
            try {
                byte[] buffer = new byte[4096];
                jarFile = new JarFile(file);
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    Object var12_14;
                    JarEntry jarEntry = jarEntries.nextElement();
                    if ("META-INF/MANIFEST.MF".equals(jarEntry.getName())) continue;
                    fileJarOutputStream.putNextEntry(jarEntry);
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    try {
                        int n = inputStream.read(buffer);
                        while (n > 0) {
                            fileJarOutputStream.write(buffer, 0, n);
                            n = inputStream.read(buffer);
                        }
                        fileJarOutputStream.closeEntry();
                        var12_14 = null;
                        if (inputStream == null) continue;
                    }
                    catch (Throwable throwable) {
                        var12_14 = null;
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                }
                Object var14_16 = null;
            }
            catch (IOException ioe) {
                throw new FileUtilsException("Cannot update jar file '" + file + "'", ioe);
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            try {
                fileJarOutputStream.flush();
                fileJarOutputStream.close();
            }
            catch (IOException e) {
                throw new FileUtilsException("Cannot close jar file output stream", e);
            }
            try {
                fileOS.close();
            }
            catch (IOException e) {
                throw new FileUtilsException("Cannot close file output stream", e);
            }
            try {
                if (jarFile == null) throw throwable;
                jarFile.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new FileUtilsException("Cannot close jar file '" + jarFile + "'.", e);
            }
        }
        try {}
        catch (IOException e) {
            throw new FileUtilsException("Cannot close jar file output stream", e);
        }
        fileJarOutputStream.flush();
        fileJarOutputStream.close();
        try {}
        catch (IOException e) {
            throw new FileUtilsException("Cannot close file output stream", e);
        }
        fileOS.close();
        try {}
        catch (IOException e) {
            throw new FileUtilsException("Cannot close jar file '" + jarFile + "'.", e);
        }
        if (jarFile == null) return;
        jarFile.close();
    }
}

