/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
* USA
*
* --------------------------------------------------------------------------
* $Id: Activator.java 5364 2010-02-24 14:37:05Z benoitf $
* --------------------------------------------------------------------------
*/
package org.ow2.util.jmx.impl.osgi;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.util.jmx.api.ICommonsModelerExtService;
import org.ow2.util.jmx.impl.CommonsModelerExtService;

/**
 * 
 * @author missonng
 */
public class Activator implements BundleActivator {
    private CommonsModelerExtService service;
    private ServiceRegistration sr;
    
    /**
     * Start the jmx service.
     * @param The  bundle context.
     */
    public void start(final BundleContext bc) {
        this.service = new CommonsModelerExtService();
        this.service.start();
        this.sr = bc.registerService(ICommonsModelerExtService.class.getName(), this.service, null);
    }

    /**
     * Stop the jmx service.
     * @param The  bundle context.
     */
    public void stop(final BundleContext bc) {
        this.sr.unregister();
        this.service.stop();
        this.service = null;
    }

}
