/**
 * OW2 Util
 * Copyright (C) 2008 SERLI
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id FetcherActivator.java $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.log.impl.osgi;


import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;

/**
 * Activator for register an implementation of the OSGi LogService.
 * @author Francois Fornaciari
 */
public class Activator implements BundleActivator {
    private ServiceRegistration sr;
    
    /**
     * Register the OSGi LogService.
     * @param The  bundle context.
     */
    public void start(final BundleContext bc) {
        this.sr = bc.registerService(LogService.class.getName(), new LoggerService(), null);
    }

    /**
     * UNregister the OSGi LogService.
     * @param The  bundle context.
     */
    public void stop(final BundleContext bc) {
        this.sr.unregister();
    }

}
