/**
 * OW2 Util
 * Copyright (C) 2008 SERLI
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id FetcherActivator.java $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.log.impl.osgi;

import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * Basic implementation of the OSGi LogService.
 * @author Francois Fornaciari
 */
public class LoggerService implements LogService {

    /**
     * The logger.
     */
    private Log logger = LogFactory.getLog(LoggerService.class);

    /**
     * {@inheritDoc}
     */
    public void log(final int level, final String message) {
        log(level, message, null);
    }

    /**
     * {@inheritDoc}
     */
    public void log(final int level, final String message, final Throwable exception) {
        switch (level) {
        case LogService.LOG_ERROR:
            logger.error(message, exception);
            break;
        case LogService.LOG_WARNING:
            logger.warn(message, exception);
            break;
        case LogService.LOG_INFO:
            logger.info(message, exception);
            break;
        case LogService.LOG_DEBUG:
            logger.debug(message, exception);
            break;
        default:
            logger.debug(message, exception);
            break;
        }
    }

    /**
     * {@inheritDoc}
     */
    public void log(ServiceReference sr, final int level, final String message) {
        log(level, message);
    }

    /**
     * {@inheritDoc}
     */
    public void log(ServiceReference sr, final int level, final String message, final Throwable exception) {
        log(level, message, exception);
    }

}
