/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.substitution.resolver;

import java.util.Collections;
import java.util.List;
import org.ow2.util.substitution.IPropertyResolver;
import org.ow2.util.substitution.resolver.ForwardingResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixingResolver
extends ForwardingResolver {
    private IPropertyResolver delegate;
    private List<String> prefixes;
    private boolean lax = false;

    public PrefixingResolver(IPropertyResolver delegate, String prefix) {
        this(delegate, Collections.singletonList(prefix));
    }

    public PrefixingResolver(IPropertyResolver delegate, List<String> prefixes) {
        this.delegate = delegate;
        this.prefixes = prefixes;
    }

    public boolean isLax() {
        return this.lax;
    }

    public void setLax(boolean lax) {
        this.lax = lax;
    }

    @Override
    protected IPropertyResolver delegate() {
        return this.delegate;
    }

    @Override
    public String resolve(String expression) {
        for (String prefix : this.prefixes) {
            String resolved;
            if (!expression.startsWith(prefix) || (resolved = this.delegate().resolve(expression.substring(prefix.length()))) == null) continue;
            return resolved;
        }
        if (this.isLax()) {
            return super.resolve(expression);
        }
        return null;
    }
}

