/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.substitution.engine;

import java.util.logging.Logger;
import org.ow2.util.substitution.IPropertyResolver;
import org.ow2.util.substitution.ISubstitutionEngine;
import org.ow2.util.substitution.engine.IResolvableElement;
import org.ow2.util.substitution.engine.element.CompositeElement;
import org.ow2.util.substitution.engine.element.FixedValueElement;
import org.ow2.util.substitution.engine.element.VariableElement;
import org.ow2.util.substitution.engine.util.StringUtils;

public class DefaultSubstitutionEngine
implements ISubstitutionEngine {
    private static final Logger logger = Logger.getLogger(DefaultSubstitutionEngine.class.getName());
    public static final char DEFAULT_MARKER = '$';
    public static final char DEFAULT_OPENING = '{';
    public static final char DEFAULT_ENDING = '}';
    private char markerChar = (char)36;
    private char openingChar = (char)123;
    private char endingChar = (char)125;
    private IPropertyResolver resolver;

    public void setMarkerChar(char markerChar) {
        this.markerChar = markerChar;
    }

    public void setOpeningChar(char openingChar) {
        this.openingChar = openingChar;
    }

    public void setEndingChar(char endingChar) {
        this.endingChar = endingChar;
    }

    public void setResolver(IPropertyResolver resolver) {
        this.resolver = resolver;
    }

    public String substitute(String variableValue) {
        IResolvableElement element = this.buildResolvableElement(variableValue);
        logger.fine(element.toString());
        return element.getValue(this.resolver);
    }

    private IResolvableElement buildResolvableElement(String input) {
        CompositeElement element = new CompositeElement();
        this.buildResolvableElement(element, input);
        return element;
    }

    private void buildResolvableElement(CompositeElement composite, String input) {
        String opening = String.valueOf(this.markerChar).concat(String.valueOf(this.openingChar));
        String ending = String.valueOf(this.endingChar);
        String remaining = input;
        while (!StringUtils.isEmpty(remaining)) {
            String prefix;
            int openingMarkerIndex = remaining.indexOf(opening);
            VariableElement variable = new VariableElement();
            if (openingMarkerIndex == -1) {
                prefix = remaining;
                variable = null;
            } else {
                prefix = openingMarkerIndex == 0 ? "" : remaining.substring(0, openingMarkerIndex);
            }
            if (openingMarkerIndex != -1 && prefix.contains(ending)) {
                throw new IllegalArgumentException(remaining + " is not a valid expression: '" + opening + "' missing");
            }
            if (!StringUtils.isEmpty(prefix)) {
                composite.getElements().add(new FixedValueElement(prefix));
            }
            if (variable != null) {
                int startIndex;
                int closingMarkerIndex;
                int subPropertyCounter = 1;
                for (closingMarkerIndex = startIndex = openingMarkerIndex + opening.length(); subPropertyCounter != 0 && closingMarkerIndex < remaining.length(); ++closingMarkerIndex) {
                    if (remaining.charAt(closingMarkerIndex) == this.endingChar) {
                        --subPropertyCounter;
                        continue;
                    }
                    if (remaining.charAt(closingMarkerIndex) != this.openingChar) continue;
                    ++subPropertyCounter;
                }
                if (subPropertyCounter != 0 && closingMarkerIndex == remaining.length()) {
                    throw new IllegalArgumentException(remaining + " is not a valid expression: " + ending + " missing");
                }
                String name = remaining.substring(startIndex, closingMarkerIndex - 1);
                if (StringUtils.isEmpty(name)) {
                    throw new IllegalArgumentException("The chain " + opening + ending + " is forbidden.");
                }
                this.buildResolvableElement(variable, name);
                composite.getElements().add(variable);
                remaining = remaining.substring(closingMarkerIndex);
                continue;
            }
            remaining = null;
        }
    }
}

